/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.windsystem;

import com.denfop.api.windsystem.EnumHorizonSide;
import com.denfop.api.windsystem.EnumRotorSide;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.IWindSystem;
import com.denfop.api.windsystem.event.WindGeneratorEvent;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.mechanism.water.TileBaseWaterGenerator;
import com.denfop.tiles.mechanism.wind.TileWindGenerator;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WindSystem
implements IWindSystem {
    public static IWindSystem windSystem;
    public EnumTypeWind enumTypeWind;
    public EnumWindSide windSide;
    public int tick = 12000;
    public EnumTypeWind[] enumTypeWinds = EnumTypeWind.values();
    List<IWindMechanism> mechanismList = new ArrayList<IWindMechanism>();
    Random rand;
    Map<EnumFacing, EnumFacing> facingMap = new HashMap<EnumFacing, EnumFacing>();
    private double Wind_Strength;

    public WindSystem() {
        windSystem = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.rand = new Random();
        this.windSide = EnumWindSide.getValue(this.rand.nextInt(8));
        this.facingMap.put(EnumFacing.EAST, EnumFacing.NORTH);
        this.facingMap.put(EnumFacing.NORTH, EnumFacing.WEST);
        this.facingMap.put(EnumFacing.WEST, EnumFacing.SOUTH);
        this.facingMap.put(EnumFacing.SOUTH, EnumFacing.EAST);
        this.enumTypeWind = EnumTypeWind.SIX;
    }

    @Override
    public EnumTypeWind getEnumTypeWind() {
        return this.enumTypeWind;
    }

    @Override
    public int getLevelWind() {
        return this.enumTypeWind.ordinal() + 1;
    }

    @Override
    public EnumWindSide getWindSide() {
        return this.windSide;
    }

    @Override
    public void getNewFacing(EnumFacing facing, IWindMechanism windMechanism) {
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            return;
        }
        facing = this.facingMap.get(facing);
        if (windMechanism instanceof TileWindGenerator) {
            ((TileWindGenerator)windMechanism).setFacingWrench(facing, null);
            new PacketUpdateFieldTile((TileWindGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
            this.changeRotorSide(windMechanism, windMechanism.getFacing());
        } else {
            ((TileBaseWaterGenerator)windMechanism).setFacingWrench(facing, null);
            new PacketUpdateFieldTile((TileBaseWaterGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
            this.changeRotorSide(windMechanism, windMechanism.getFacing());
        }
    }

    @SubscribeEvent
    public void LoadWindMechanism(WindGeneratorEvent event) {
        IWindMechanism windMechanism = event.getWindMechanism();
        if (event.getLoad()) {
            windMechanism.setCoefficient(this.getCoefficient(windMechanism));
            if (windMechanism.getAuto()) {
                this.getNewPositionOfMechanism(windMechanism);
                windMechanism.setCoefficient(this.getCoefficient(windMechanism));
            }
            if (!this.mechanismList.contains(windMechanism)) {
                this.mechanismList.add(windMechanism);
            }
        } else {
            this.mechanismList.remove(windMechanism);
        }
    }

    @SubscribeEvent
    public void EventWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            this.mechanismList.clear();
        }
    }

    @Override
    public double getWind_Strength() {
        return this.Wind_Strength;
    }

    @Override
    public void changeRotorSide(IWindMechanism windMechanism, EnumFacing facing) {
        windMechanism.setRotorSide(this.getRotorSide(facing));
        windMechanism.setCoefficient(this.getCoefficient(windMechanism));
    }

    @Override
    public void getNewPositionOfMechanism(IWindMechanism windMechanism) {
        EnumFacing newFacing = this.getNewFacing();
        if (windMechanism instanceof TileWindGenerator) {
            if (windMechanism.getFacing() != newFacing) {
                ((TileWindGenerator)windMechanism).setFacingWrench(newFacing, null);
                new PacketUpdateFieldTile((TileWindGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
                this.changeRotorSide(windMechanism, windMechanism.getFacing());
            }
        } else if (windMechanism.getFacing() != newFacing) {
            ((TileBaseWaterGenerator)windMechanism).setFacingWrench(newFacing, null);
            new PacketUpdateFieldTile((TileBaseWaterGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
            this.changeRotorSide(windMechanism, windMechanism.getFacing());
        }
    }

    @Override
    public EnumFacing getNewFacing() {
        switch (this.windSide) {
            case E: {
                return EnumFacing.SOUTH;
            }
            case W: 
            case SW: {
                return EnumFacing.NORTH;
            }
            case N: 
            case NW: 
            case SE: {
                return EnumFacing.EAST;
            }
            case S: 
            case NE: {
                return EnumFacing.WEST;
            }
        }
        return null;
    }

    @Override
    public EnumRotorSide getRotorSide(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EnumRotorSide.E;
            }
            case WEST: {
                return EnumRotorSide.W;
            }
            case NORTH: {
                return EnumRotorSide.N;
            }
            case SOUTH: {
                return EnumRotorSide.S;
            }
        }
        return null;
    }

    public double getCoefficient(IWindMechanism windMechanism) {
        if (windMechanism == null) {
            return 0.0;
        }
        EnumHorizonSide side = this.windSide.getList().get(0);
        EnumRotorSide side_rotor = windMechanism.getRotorSide();
        EnumHorizonSide bad_sides = side_rotor.getBad_sides();
        EnumHorizonSide good_side = side_rotor.getGood_sides();
        EnumHorizonSide neutral_side = side_rotor.getNeutral_sides();
        for (EnumHorizonSide side2 : side.getEnumWindSide()) {
            for (EnumHorizonSide side1 : good_side.getEnumWindSide()) {
                if (side1 != side2) continue;
                return 1.0;
            }
            for (EnumHorizonSide side1 : neutral_side.getEnumWindSide()) {
                if (side1 != side2) continue;
                return 0.75;
            }
            for (EnumHorizonSide side1 : bad_sides.getEnumWindSide()) {
                if (side1 != side2) continue;
                return 0.5;
            }
        }
        return 0.0;
    }

    @Override
    public double getSpeed() {
        return ModUtils.limit(this.getWind_Strength() / (EnumTypeWind.TEN.getMax() * 1.5), 0.0, 2.0);
    }

    @Override
    public double getSpeed(double speed) {
        return ModUtils.limit(speed / (EnumTypeWind.TEN.getMax() * 1.5), 0.0, 2.0);
    }

    @SubscribeEvent
    public void windTick(TickEvent.WorldTickEvent event) {
        World world;
        if (event.side == Side.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.world.field_73011_w.getDimension() == 0) {
            --this.tick;
        }
        if (this.tick == 0) {
            this.windSide = EnumWindSide.getValue(this.rand.nextInt(8));
            if (this.enumTypeWind == null) {
                this.enumTypeWind = EnumTypeWind.values()[this.rand.nextInt(EnumTypeWind.values().length)];
            } else {
                int rand = this.rand.nextInt(100);
                switch (this.enumTypeWind.ordinal()) {
                    case 0: {
                        this.enumTypeWind = rand >= 10 ? EnumTypeWind.TWO : EnumTypeWind.ONE;
                        this.tick = 12000;
                        break;
                    }
                    case 1: {
                        if (rand >= 20) {
                            this.enumTypeWind = EnumTypeWind.THREE;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.ONE;
                        }
                        this.tick = 12000;
                        break;
                    }
                    case 2: {
                        if (rand >= 30) {
                            this.enumTypeWind = EnumTypeWind.FOUR;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.TWO;
                        }
                        this.tick = 13000;
                        break;
                    }
                    case 3: {
                        if (rand >= 40) {
                            this.enumTypeWind = EnumTypeWind.FIVE;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.THREE;
                        }
                        this.tick = 14000;
                        break;
                    }
                    case 4: {
                        if (rand >= 50) {
                            this.enumTypeWind = EnumTypeWind.SIX;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.FOUR;
                        }
                        this.tick = 15000;
                        break;
                    }
                    case 5: {
                        if (rand >= 60) {
                            this.enumTypeWind = EnumTypeWind.SEVEN;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.FIVE;
                        }
                        this.tick = 15000;
                        break;
                    }
                    case 6: {
                        if (rand >= 70) {
                            this.enumTypeWind = EnumTypeWind.EIGHT;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.SIX;
                        }
                        this.tick = 16000;
                        break;
                    }
                    case 7: {
                        if (rand >= 80) {
                            this.enumTypeWind = EnumTypeWind.NINE;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.SEVEN;
                        }
                        this.tick = 15000;
                        break;
                    }
                    case 8: {
                        if (rand >= 90) {
                            this.enumTypeWind = EnumTypeWind.TEN;
                        } else if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.EIGHT;
                        }
                        this.tick = 14000;
                        break;
                    }
                    case 9: {
                        if (this.rand.nextInt(100) > 50) {
                            this.enumTypeWind = EnumTypeWind.NINE;
                        }
                        this.tick = 12000;
                    }
                }
            }
            for (IWindMechanism windMechanism : this.mechanismList) {
                windMechanism.setCoefficient(this.getCoefficient(windMechanism));
                if (!windMechanism.getAuto()) continue;
                this.getNewPositionOfMechanism(windMechanism);
                windMechanism.setCoefficient(this.getCoefficient(windMechanism));
            }
        }
        if ((world = event.world).func_72820_D() % 20L == 0L) {
            double coef = this.enumTypeWind.getMax() - this.enumTypeWind.getMin();
            this.Wind_Strength = this.enumTypeWind.getMin() + (double)world.field_73012_v.nextInt((int)(coef *= 10.0) + 1) / 10.0;
            double speed = this.getSpeed();
            for (IWindMechanism windMechanism : this.mechanismList) {
                if (windMechanism == null) continue;
                windMechanism.setRotationSpeed((float)speed);
            }
        }
    }

    @Override
    public int getTime() {
        return this.tick;
    }

    @Override
    public double getPower(World world, BlockPos pos, boolean min, IWindMechanism rotor) {
        if (world.field_72995_K) {
            return 0.0;
        }
        if (rotor.getMinWind() != 0) {
            int meta = Math.min(this.enumTypeWind.ordinal() + rotor.getMinWind(), 9);
            EnumTypeWind enumTypeWinds = this.enumTypeWinds[meta];
            double coef = enumTypeWinds.getMax() - enumTypeWinds.getMin();
            coef *= 10.0;
            coef = enumTypeWinds.getMin() + (double)world.field_73012_v.nextInt((int)coef + 1) / 10.0;
            coef += (double)rotor.getMinWindSpeed();
            coef = Math.min(coef, EnumTypeWind.TEN.getMax());
            int y = pos.func_177956_o();
            if (min) {
                y = 150;
            }
            coef = y < 150 ? (coef *= (double)y / 150.0) : (coef *= 150.0 / (double)y);
            return coef * 27.0;
        }
        double coef = this.Wind_Strength;
        coef += (double)rotor.getMinWindSpeed();
        int y = pos.func_177956_o();
        if (min) {
            y = 150;
        }
        coef = y < 150 ? (coef *= (double)y / 150.0) : (coef *= 150.0 / (double)y);
        return coef * 27.0;
    }

    @Override
    public double getSpeedFromPower(BlockPos pos, IWindMechanism rotor, double power) {
        double copy_power = power / 27.0;
        copy_power /= (double)rotor.getRotor().getEfficiency(rotor.getItemStack()) * (1.0 + rotor.getAdditionalPower()) * (rotor.getCoefficient() * (1.0 + rotor.getAdditionalCoefficient()));
        int y = pos.func_177956_o();
        if (rotor.getMin()) {
            y = 150;
        }
        copy_power = y < 150 ? (copy_power /= (double)y / 150.0) : (copy_power /= 150.0 / (double)y);
        return copy_power;
    }

    @Override
    public double getSpeedFromWaterPower(BlockPos pos, IWindMechanism rotor, double power) {
        double copy_power = power / 27.0;
        return copy_power /= (double)rotor.getRotor().getEfficiency(rotor.getItemStack()) * (1.0 + rotor.getAdditionalPower()) * (rotor.getCoefficient() * (1.0 + rotor.getAdditionalCoefficient()));
    }

    @Override
    public double getPowerFromWindRotor(World world, BlockPos pos, IWindMechanism windMechanism, ItemStack stack) {
        return this.getPower(world, pos, windMechanism.getMin(), windMechanism) * ((double)windMechanism.getRotor().getEfficiency(stack) * (1.0 + windMechanism.getAdditionalPower())) * (windMechanism.getCoefficient() * (1.0 + windMechanism.getAdditionalCoefficient()));
    }

    @Override
    public double getPowerFromWaterRotor(World world, IWindMechanism windMechanism, ItemStack stack) {
        return this.getPower(world, new BlockPos(0, 150, 0), windMechanism.getMin(), windMechanism) / 27.0 * 25.0 * ((double)windMechanism.getRotor().getEfficiency(stack) * (1.0 + windMechanism.getAdditionalPower())) * (windMechanism.getCoefficient() * (1.0 + windMechanism.getAdditionalCoefficient()));
    }
}

