/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.audio;

import com.denfop.audio.EnumSound;
import com.denfop.audio.PlayerSound;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SoundHandler {
    private static final SoundManager soundManager = Minecraft.func_71410_x().func_147118_V().field_147694_f;

    public static void stopSound(BlockPos pos) {
        SoundHandler.getSoundAtPosition(pos).ifPresent(arg_0 -> ((SoundManager)soundManager).func_148602_b(arg_0));
    }

    public static void stopAllSounds() {
        SoundHandler.getAllSoundsFromMod().forEach(arg_0 -> ((SoundManager)soundManager).func_148602_b(arg_0));
    }

    public static void stopSound(EnumSound sound) {
        SoundHandler.getSoundsMatching(sound.getNameSounds().toLowerCase()).forEach(arg_0 -> ((SoundManager)soundManager).func_148602_b(arg_0));
    }

    public static void playSound(EntityPlayer player, Object sound) {
        String soundName;
        if (player == null || sound == null) {
            return;
        }
        String string = soundName = sound instanceof EnumSound ? ((EnumSound)((Object)sound)).getNameSounds().toLowerCase() : sound.toString().toLowerCase();
        if (!SoundHandler.isSoundPlaying(soundName)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PlayerSound(player, EnumSound.getSondFromString(soundName).func_187503_a()));
        }
    }

    private static boolean isSoundPlaying(String soundName) {
        return SoundHandler.soundManager.field_148630_i.keySet().stream().anyMatch(sound -> SoundHandler.isSoundFromMod(sound) && sound.func_147650_b().func_110623_a().contains(soundName));
    }

    private static List<ISound> getAllSoundsFromMod() {
        ArrayList<ISound> sounds = new ArrayList<ISound>();
        SoundHandler.soundManager.field_148630_i.keySet().stream().filter(SoundHandler::isSoundFromMod).forEach(sounds::add);
        return sounds;
    }

    private static List<ISound> getSoundsMatching(String soundName) {
        ArrayList<ISound> sounds = new ArrayList<ISound>();
        SoundHandler.soundManager.field_148630_i.keySet().stream().filter(sound -> SoundHandler.isSoundFromMod(sound) && sound.func_147650_b().func_110623_a().contains(soundName)).forEach(sounds::add);
        return sounds;
    }

    private static Optional<ISound> getSoundAtPosition(BlockPos pos) {
        if (pos.func_177958_n() < 0) {
            pos = pos.func_177982_a(-1, 0, 0);
        }
        if (pos.func_177952_p() < 0) {
            pos = pos.func_177982_a(0, 0, -1);
        }
        BlockPos finalPos = pos;
        return SoundHandler.soundManager.field_148630_i.keySet().stream().filter(sound -> SoundHandler.isSoundFromMod(sound) && SoundHandler.isSoundAtPosition(sound, finalPos)).findFirst();
    }

    private static boolean isSoundFromMod(ISound sound) {
        return sound.func_184365_d() == SoundCategory.PLAYERS && sound.func_147650_b().func_110624_b().equals("industrialupgrade");
    }

    private static boolean isSoundAtPosition(ISound sound, BlockPos pos) {
        return new BlockPos((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i()).equals((Object)pos);
    }
}

