/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.IUPotion;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IVolcanoArmor;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.blocks.StateMapperIU;
import com.denfop.blocks.state.BoolProperty;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class BlockBasalts
extends BlockCore
implements IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static final BoolProperty BOOL_PROPERTY = new BoolProperty("hasdamage");

    public BlockBasalts() {
        super(Material.field_151576_e, "industrialupgrade");
        this.func_149663_c("blockbasalts");
        this.func_149647_a(IUCore.IUTab);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.basalt)));
        this.setHarvestLevel("pickaxe", 1);
        this.func_149675_a(true);
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public ItemStack getItemStack(Type type) {
        return this.getItemStack(this.getState(type));
    }

    public IBlockState getState(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("invalid type: " + (Object)((Object)type));
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type));
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int meta = this.func_176201_c(state);
        if (meta == 6) {
            drops.add((Object)new ItemStack((Item)IUItem.iudust, rand.nextInt(2) + 1 + rand.nextInt(fortune + 1), 31));
            return;
        }
        if (meta == 7) {
            drops.add((Object)new ItemStack((Item)IUItem.crafting_elements, rand.nextInt(2) + 1 + rand.nextInt(fortune + 1), 477));
            return;
        }
        if (meta == 5) {
            drops.add((Object)new ItemStack((Block)IUItem.basalts, 1, 2));
            return;
        }
        if (meta == 1) {
            drops.add((Object)new ItemStack((Block)IUItem.basalts, 1, 8));
            return;
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        boolean damage = (Boolean)state.func_177229_b((IProperty)BOOL_PROPERTY);
        if (!damage) {
            return;
        }
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 2));
        List list = world.func_72872_a(EntityPlayer.class, axisAlignedBB);
        for (EntityPlayer player : list) {
            boolean can = !IVolcanoArmor.hasCompleteHazmat((EntityLivingBase)player);
            if (!can) continue;
            player.func_70690_d(new PotionEffect((Potion)IUPotion.poison_gas, 200, 0));
        }
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, IBlockState p_180633_3_, EntityLivingBase p_180633_4_, ItemStack p_180633_5_) {
        super.func_180633_a(p_180633_1_, p_180633_2_, p_180633_3_, p_180633_4_, p_180633_5_);
        p_180633_3_ = p_180633_3_.func_177226_a((IProperty)BOOL_PROPERTY, (Comparable)Boolean.valueOf(false));
        p_180633_1_.func_175656_a(p_180633_2_, p_180633_3_);
    }

    public ItemStack getItemStack(IBlockState state) {
        if (state.func_177230_c() != this) {
            return null;
        }
        Item item = Item.func_150898_a((Block)this);
        if (item != Items.field_190931_a) {
            int meta = this.func_176201_c(state);
            return new ItemStack(item, 1, meta);
        }
        throw new RuntimeException("no matching item for " + this);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, BOOL_PROPERTY});
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "iu." + Type.values()[meta].func_176610_l() + ".name";
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return ((Type)((Object)state.func_177229_b(VARIANT))).getExplosionResistance();
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 4) {
            return 4;
        }
        return this.field_149784_t;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
        ModelLoader.setCustomStateMapper((Block)this, block -> block.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(state -> state, state -> {
            StateMapperIU stateMapper = new StateMapperIU(this.getRegistryName());
            return stateMapper.func_178132_a((IBlockState)state);
        })));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((Type)((Object)blockState.func_177229_b(VARIANT))).getHardness();
    }

    @Override
    public boolean preInit() {
        this.setRegistryName("blockbasalts");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore(this);
        itemBlock.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        IUCore.proxy.addIModelRegister(this);
        return true;
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        int meta = this.func_176201_c(state);
        if (meta == 4 && !entityIn.func_70045_F() && entityIn instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess p_185484_2_, BlockPos p_185484_3_) {
        int meta = this.func_176201_c(state);
        if (meta == 4) {
            return 0xF000F0;
        }
        return super.func_185484_c(state, p_185484_2_, p_185484_3_);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    protected void onStartFalling(EntityFallingBlock fallingEntity) {
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockBasalts.canFallThrough(worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    this.onStartFalling(entityfallingblock);
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockBasalts.canFallThrough(worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public void onEndFalling(World worldIn, BlockPos pos, IBlockState p_176502_3_, IBlockState p_176502_4_) {
    }

    public void onBroken(World worldIn, BlockPos pos) {
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public void func_180650_b(World p_180650_1_, BlockPos p_180650_2_, IBlockState p_180650_3_, Random p_180650_4_) {
        int meta = this.func_176201_c(p_180650_3_);
        if (p_180650_1_.field_72995_K || meta == 5) {
            // empty if block
        }
    }

    public boolean func_189872_a(IBlockState p_189872_1_, Entity p_189872_2_) {
        return p_189872_2_.func_70045_F();
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 4) {
            return 3;
        }
        return this.field_149784_t;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).metal ? SoundType.field_185852_e : SoundType.field_185851_d;
    }

    public boolean initialize() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        basalt(5.0f, 45.0f, false),
        basalt_cobblestone(5.0f, 45.0f, false),
        basalt_melted(10.0f, 45.0f, false),
        basalt_blocked(5.0f, 45.0f, false),
        basalt_magma(2.5f, 45.0f, false),
        basalt_pylon(5.0f, 45.0f, false),
        basalt_sulfur_ore(5.0f, 45.0f, false),
        basalt_boron_ore(10.0f, 45.0f, false),
        basalt_spongy(5.0f, 45.0f, false),
        basalt_smooth(5.0f, 45.0f, false);

        private final float hardness;
        private final float explosionResistance;
        private final boolean metal;
        private final int metadata = this.ordinal();
        private final String name = this.name().toLowerCase(Locale.US);

        private Type(float hardness, float explosionResistance, boolean metal) {
            this.hardness = hardness;
            this.explosionResistance = explosionResistance;
            this.metal = metal;
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public float getExplosionResistance() {
            return this.explosionResistance;
        }

        public float getHardness() {
            return this.hardness;
        }

        public boolean isMetal() {
            return this.metal;
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return 0;
        }

        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }
    }
}

