/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.items.block.ItemBlockIU;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBase
extends Block
implements IModelRegister {
    protected BlockBase(String name, Material material) {
        this(name, material, ItemBlockIU.supplier);
    }

    protected BlockBase(String name, Material material, Class<? extends ItemBlock> itemClass) {
        this(name, material, BlockBase.createItemBlockSupplier(itemClass));
    }

    protected BlockBase(String name, Material material, Function<Block, Item> itemSupplier) {
        super(material);
        this.func_149647_a(IUCore.IUTab);
        if (name != null) {
            this.register(name, IUCore.getIdentifier(name), itemSupplier);
        }
        IUCore.proxy.addIModelRegister(this);
    }

    protected static Function<Block, Item> createItemBlockSupplier(Class<? extends ItemBlock> cls) {
        if (cls == null) {
            throw new NullPointerException("null item class");
        }
        return input -> {
            try {
                return (Item)cls.getConstructor(Block.class).newInstance(input);
            }
            catch (Exception var3) {
                throw new RuntimeException(var3);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerDefaultItemModel(Block block) {
        BlockBase.registerItemModels(block, Collections.singletonList(block.func_176223_P()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels(Block block, Iterable<IBlockState> states) {
        BlockBase.registerItemModels(block, states, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels(Block block, Iterable<IBlockState> states, IStateMapper mapper) {
        ResourceLocation loc;
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a && (loc = ModUtils.getName(item)) != null) {
            Map locations = mapper != null ? mapper.func_178130_a(block) : null;
            for (IBlockState state : states) {
                ModelResourceLocation location;
                int meta = block.func_176201_c(state);
                ModelResourceLocation modelResourceLocation = location = locations != null ? (ModelResourceLocation)locations.get(state) : new ModelResourceLocation(loc, new DefaultStateMapper().func_178131_a((Map)state.func_177228_b()));
                if (location == null) {
                    throw new RuntimeException("can't map state " + state);
                }
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerDefaultVanillaItemModel(Block block, String path) {
        ResourceLocation loc;
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a && (loc = ModUtils.getName(item)) != null) {
            path = path != null && !path.isEmpty() ? path + '/' + loc : loc.toString();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(path, null));
        }
    }

    protected void register(String name, ResourceLocation identifier, Function<Block, Item> itemSupplier) {
        this.func_149663_c(name);
        Register.registerBlock(this, identifier);
        if (itemSupplier != null) {
            Register.registerItem(itemSupplier.apply(this), identifier);
        }
    }

    protected void register(String name, ResourceLocation identifier, Item itemSupplier) {
        this.func_149663_c(name);
        Register.registerBlock(this, identifier);
        if (itemSupplier != null) {
            Register.registerItem(itemSupplier, identifier);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        BlockBase.registerDefaultItemModel(this);
    }

    public String func_149739_a() {
        return "iu." + super.func_149739_a().substring(5);
    }

    public String func_149732_F() {
        return Localization.translate(this.func_149739_a());
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }
}

