/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.IUPotion;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IHazmatLike;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.blocks.StateMapperIU;
import com.denfop.blocks.state.BoolProperty;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockClassicOre
extends BlockCore
implements IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static final BoolProperty BOOL_PROPERTY = new BoolProperty("hasdamage");

    public BlockClassicOre() {
        super(Material.field_151576_e, "industrialupgrade");
        this.func_149663_c("classicore");
        this.func_149647_a(IUCore.OreTab);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.copper)));
        this.setHarvestLevel("pickaxe", 1);
    }

    public ItemStack getItemStack(Type type) {
        return this.getItemStack(this.getState(type));
    }

    public IBlockState getState(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("invalid type: " + (Object)((Object)type));
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type));
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        Type type = (Type)((Object)state.func_177229_b(VARIANT));
        if (type != Type.uranium) {
            return;
        }
        boolean damage = (Boolean)state.func_177229_b((IProperty)BOOL_PROPERTY);
        if (!damage) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        new PacketUpdateRadiationValue(chunkPos, 1.0);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 2));
        List list = world.func_72872_a(EntityPlayer.class, axisAlignedBB);
        for (EntityPlayer player : list) {
            boolean can = !IHazmatLike.hasCompleteHazmat((EntityLivingBase)player);
            if (!can) continue;
            player.func_70690_d(new PotionEffect((Potion)IUPotion.radiation, 400, 0));
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 400, 0));
        }
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, IBlockState p_180633_3_, EntityLivingBase p_180633_4_, ItemStack p_180633_5_) {
        super.func_180633_a(p_180633_1_, p_180633_2_, p_180633_3_, p_180633_4_, p_180633_5_);
        p_180633_3_ = p_180633_3_.func_177226_a((IProperty)BOOL_PROPERTY, (Comparable)Boolean.valueOf(false));
        p_180633_1_.func_175656_a(p_180633_2_, p_180633_3_);
    }

    public ItemStack getItemStack(IBlockState state) {
        if (state.func_177230_c() != this) {
            return null;
        }
        Item item = Item.func_150898_a((Block)this);
        if (item != Items.field_190931_a) {
            int meta = this.func_176201_c(state);
            return new ItemStack(item, 1, meta);
        }
        throw new RuntimeException("no matching item for " + this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, BOOL_PROPERTY});
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "iu." + Type.values()[meta].func_176610_l() + "_ore.name";
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    public IBlockState func_176203_a(int meta) {
        boolean property = meta == 3;
        return this.func_176223_P().func_177226_a((IProperty)BOOL_PROPERTY, (Comparable)Boolean.valueOf(property)).func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            drops.add((Object)new ItemStack((Item)IUItem.rawMetals, 1 + this.getDrop(fortune), 16));
        } else if (meta == 1) {
            drops.add((Object)new ItemStack((Item)IUItem.rawMetals, 1 + this.getDrop(fortune), 20));
        } else if (meta == 2) {
            drops.add((Object)new ItemStack((Item)IUItem.rawMetals, 1 + this.getDrop(fortune), 19));
        } else if (meta == 3) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    private int getDrop(int fortune) {
        switch (fortune) {
            case 0: {
                return 0;
            }
            case 1: {
                return WorldBaseGen.random.nextDouble() < 0.25 ? 1 : 0;
            }
            case 2: {
                return WorldBaseGen.random.nextDouble() < 0.5 ? 1 : 0;
            }
        }
        return WorldBaseGen.random.nextDouble() < 0.75 ? 1 : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
        ModelLoader.setCustomStateMapper((Block)this, block -> block.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(state -> state, state -> {
            StateMapperIU stateMapper = new StateMapperIU(this.getRegistryName());
            return stateMapper.func_178132_a((IBlockState)state);
        })));
    }

    @Override
    public boolean preInit() {
        this.setRegistryName("classicore");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore(this);
        itemBlock.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        IUCore.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        copper(0),
        tin(1),
        lead(2),
        uranium(3);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return 0;
        }

        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }
    }
}

