/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.IDeposits;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.items.energy.ItemHammer;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockDeposits2
extends BlockCore
implements IModelRegister,
IDeposits {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static final AxisAlignedBB Deposits = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    Map<Integer, List<String>> mapInf = new HashMap<Integer, List<String>>();

    public BlockDeposits2() {
        super(Material.field_151576_e, "industrialupgrade");
        this.func_149663_c("deposits2");
        this.func_149647_a(IUCore.OreTab);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.deposits_fergusonite)));
        this.setHarvestLevel("pickaxe", 0);
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Deposits;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, 2);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, 2);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockDeposits2.canFallThrough(worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    this.onStartFalling(entityfallingblock);
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockDeposits2.canFallThrough(worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    protected void onStartFalling(EntityFallingBlock fallingEntity) {
    }

    public int func_149738_a(World worldIn) {
        return 10;
    }

    public void onEndFalling(World worldIn, BlockPos pos, IBlockState p_176502_3_, IBlockState p_176502_4_) {
    }

    public void onBroken(World worldIn, BlockPos pos) {
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "iu." + Type.values()[meta].func_176610_l() + ".name";
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    @Nonnull
    public IBlockState getStateMeta(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta % Type.values().length]));
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (!itemstack.func_190926_b()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockDeposits2.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.dropBlockAsItemWithChance(worldIn, pos, state, 1.0f, i, player);
            this.harvesters.set(null);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune, EntityPlayer player) {
        NonNullList ret = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)ret, world, pos, state, fortune, player);
        return ret;
    }

    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune, EntityPlayer player) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List<ItemStack> drops = this.getDrops((IBlockAccess)worldIn, pos, state, fortune, player);
            chance = ForgeEventFactory.fireBlockHarvesting(drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockDeposits2.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    @Override
    public List<String> getInformationFromMeta(int meta) {
        List<String> inf = this.mapInf.get(meta);
        if (inf == null) {
            VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
            ArrayList<String> stringList = new ArrayList<String>();
            String s = Localization.translate("deposists.jei1") + (vein.getHeavyOre() != null ? new ItemStack(vein.getHeavyOre().getBlock(), 1, vein.getMeta()).func_82833_r() : new ItemStack(vein.getOres().get(0).getBlock().func_177230_c(), 1, vein.getOres().get(0).getMeta()).func_82833_r());
            stringList.add(s);
            if (vein.getHeavyOre() != null) {
                String s1 = new ItemStack(vein.getHeavyOre().getBlock(), 1, vein.getMeta()).func_82833_r() + " 50%";
                stringList.add(s1);
                for (int i = 0; i < vein.getOres().size(); ++i) {
                    ChanceOre chanceOre = vein.getOres().get(i);
                    String s2 = new ItemStack(chanceOre.getBlock().func_177230_c(), 1, chanceOre.getMeta()).func_82833_r() + " " + chanceOre.getChance() + "%";
                    stringList.add(s2);
                }
            } else {
                for (int i = 0; i < vein.getOres().size(); ++i) {
                    ChanceOre chanceOre = vein.getOres().get(i);
                    String s2 = new ItemStack(chanceOre.getBlock().func_177230_c(), 1, chanceOre.getMeta()).func_82833_r() + " " + chanceOre.getChance() + "%";
                    stringList.add(s2);
                }
            }
            this.mapInf.put(meta, stringList);
            return stringList;
        }
        return inf;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = this.func_176201_c(state);
        VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
        if (vein.getHeavyOre() == null) {
            ChanceOre block = vein.getOres().get(0);
            return new ItemStack(block.getBlock().func_177230_c(), 1, block.getMeta());
        }
        return new ItemStack(vein.getHeavyOre().getBlock(), 1, vein.getMeta());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune, EntityPlayer player) {
        if (player.func_184586_b(player.func_184600_cs()).func_77973_b() instanceof ItemHammer) {
            int meta = this.func_176201_c(state);
            VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
            if (vein.getHeavyOre() == null) {
                ChanceOre block = vein.getOres().get(0);
                drops.add((Object)new ItemStack(block.getBlock().func_177230_c(), 1, block.getMeta()));
            } else {
                List<BaseMachineRecipe> recipe_list;
                IBaseRecipe recipe = Recipes.recipes.getRecipe("handlerho");
                MachineRecipe output = Recipes.recipes.getRecipeMachineRecipeOutput(recipe, recipe_list = Recipes.recipes.getRecipeList("handlerho"), false, Collections.singletonList(new ItemStack(vein.getHeavyOre().getBlock(), 1, vein.getMeta())));
                if (output != null) {
                    int[] col = new int[output.getRecipe().output.items.size()];
                    for (int i = 0; i < col.length; ++i) {
                        col[i] = output.getRecipe().output.metadata.func_74762_e("input" + i);
                        col[i] = Math.min(col[i], 95);
                    }
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < col.length; ++i) {
                        Random rand = player.func_130014_f_().field_73012_v;
                        if (rand.nextInt(100) >= col[i]) continue;
                        stacks.add(output.getRecipe().output.items.get(i));
                    }
                    for (ItemStack stack : stacks) {
                        BaseMachineRecipe rec1 = Recipes.recipes.getRecipeOutput("macerator", false, stack);
                        if (rec1 != null) {
                            ItemStack stack1 = rec1.output.items.get(0).func_77946_l();
                            stack1.func_190920_e(1);
                            drops.add((Object)stack1);
                            continue;
                        }
                        drops.add((Object)stack.func_77946_l());
                    }
                }
            }
        } else {
            int meta = this.func_176201_c(state);
            VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
            if (vein.getHeavyOre() == null) {
                ChanceOre block = vein.getOres().get(0);
                drops.add((Object)new ItemStack(block.getBlock().func_177230_c(), 1, block.getMeta()));
            } else {
                drops.add((Object)new ItemStack(vein.getHeavyOre().getBlock(), 1, vein.getMeta()));
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int meta = this.func_176201_c(state);
        VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
        if (vein.getHeavyOre() == null) {
            ChanceOre block = vein.getOres().get(0);
            drops.add((Object)new ItemStack(block.getBlock().func_177230_c(), 1, block.getMeta()));
        } else {
            drops.add((Object)new ItemStack(vein.getHeavyOre().getBlock(), 1, vein.getMeta()));
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
    }

    @Override
    public boolean preInit() {
        this.setRegistryName("deposits2");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore(this);
        itemBlock.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        IUCore.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        deposits_fergusonite(0),
        deposits_appatite(1),
        deposits_crystal(2),
        deposits_coal(3),
        deposits_redstone(4);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return 0;
        }

        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }
    }
}

