/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.IUPotion;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IHazmatLike;
import com.denfop.blocks.BlockBase;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.items.block.ItemBlockIU;
import com.denfop.register.Register;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIUFluid
extends BlockFluidClassic
implements IModelRegister {
    protected final Fluid fluid;

    public BlockIUFluid(FluidName name, Fluid fluid, Material material) {
        super(fluid, ((IUFluid)fluid).getFluid().canBeLava() ? Material.field_151587_i : material);
        this.func_149663_c(name.name());
        this.func_149647_a(IUCore.FluidBlockTab);
        this.fluid = fluid;
        if (name == FluidName.fluidpahoehoe_lava) {
            this.setMaxScaledLight(10);
            this.setQuantaPerBlock(5);
        }
        ResourceLocation regName = IUCore.getIdentifier(name.name());
        Register.registerBlock(this, regName);
        Register.registerItem(new ItemBlockIU((Block)this), regName);
        IUCore.proxy.addIModelRegister(this);
    }

    private static boolean isFluid(@Nonnull IBlockState blockstate) {
        return blockstate.func_185904_a().func_76224_d() || blockstate.func_177230_c() instanceof IFluidBlock;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState oldState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int j;
        int i;
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty((IUnlistedProperty)FLOW_DIRECTION, (Object)Float.valueOf((float)BlockIUFluid.getFlowDirection((IBlockAccess)world, (BlockPos)pos)));
        IBlockState[][] upBlockState = new IBlockState[3][3];
        float[][] height = new float[3][3];
        float[][] corner = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}};
        upBlockState[1][1] = world.func_180495_p(pos.func_177979_c(this.densityDir));
        height[1][1] = this.getFluidHeightForRender(world, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    upBlockState[i][j] = world.func_180495_p(pos.func_177982_a(i - 1, 0, j - 1).func_177979_c(this.densityDir));
                    height[i][j] = this.getFluidHeightForRender(world, pos.func_177982_a(i - 1, 0, j - 1), upBlockState[i][j]);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(new float[]{height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]});
                }
            }
            boolean n = BlockIUFluid.isFluid(upBlockState[0][1]);
            boolean s = BlockIUFluid.isFluid(upBlockState[2][1]);
            boolean w = BlockIUFluid.isFluid(upBlockState[1][0]);
            boolean e = BlockIUFluid.isFluid(upBlockState[1][2]);
            boolean nw = BlockIUFluid.isFluid(upBlockState[0][0]);
            boolean ne = BlockIUFluid.isFluid(upBlockState[0][2]);
            boolean sw = BlockIUFluid.isFluid(upBlockState[2][0]);
            boolean se = BlockIUFluid.isFluid(upBlockState[2][2]);
            if (nw || n || w) {
                corner[0][0] = 1.0f;
            }
            if (ne || n || e) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e) {
                corner[1][1] = 1.0f;
            }
        }
        for (i = 0; i < 4; ++i) {
            EnumFacing side = EnumFacing.func_176731_b((int)i);
            BlockPos blockPos = pos.func_177972_a(side);
        }
        try {
            state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[0], (Object)Float.valueOf(corner[0][0]));
            state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[1], (Object)Float.valueOf(corner[0][1]));
            state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[2], (Object)Float.valueOf(corner[1][1]));
            state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[3], (Object)Float.valueOf(corner[1][0]));
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return state;
    }

    private boolean isWithinFluid(IBlockAccess world, BlockPos pos, Vec3d vec) {
        float filled = this.getFilledPercentage(world, pos);
        return filled < 0.0f ? vec.field_72448_b > (double)((float)pos.func_177956_o() + filled + 1.0f) : vec.field_72448_b < (double)((float)pos.func_177956_o() + filled);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        if (!this.isWithinFluid((IBlockAccess)world, pos, ActiveRenderInfo.func_178806_a((Entity)entity, (double)partialTicks))) {
            if (state.func_185904_a() == Material.field_151586_h) {
                float f12 = 0.0f;
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase ent = (EntityLivingBase)entity;
                    f12 = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)ent) * 0.2f;
                    if (ent.func_70644_a(MobEffects.field_76427_o)) {
                        f12 = f12 * 0.3f + 0.6f;
                    }
                }
                return new Vec3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
            }
            if (state.func_185904_a() == Material.field_151587_i) {
                return new Vec3d((double)0.6f, (double)0.1f, 0.0);
            }
            return originalColor;
        }
        if (this.getFluid() != null) {
            int color = this.getFluid().getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            return new Vec3d((double)red, (double)green, (double)blue);
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        BlockBase.registerDefaultItemModel((Block)this);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.fluid != FluidName.fluidlava.getInstance() && this.fluid != FluidName.fluidwater.getInstance()) {
            items.add((Object)new ItemStack((Block)this));
        }
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        super.func_180650_b(worldIn, pos, state, random);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((IUFluid)this.fluid).getFluid().canBeLava() ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 25;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return ((IUFluid)this.fluid).getFluid().canBeLava();
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.canDisplace(world, pos);
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos neighborPos) {
        super.func_189540_a(state, world, pos, block, neighborPos);
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_176213_c(world, pos, state);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
            world.func_184133_a(null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        if (entityIn instanceof EntityPlayer && state.func_177230_c() instanceof BlockIUFluid) {
            if (((BlockIUFluid)state.func_177230_c()).getFluid() == FluidName.fluidcoolant.getInstance() || ((BlockIUFluid)state.func_177230_c()).getFluid() == FluidName.fluidazot.getInstance()) {
                ((EntityPlayer)entityIn).func_70690_d(new PotionEffect((Potion)IUPotion.frostbite, 200, 0));
            }
            if (((BlockIUFluid)state.func_177230_c()).getFluid().isGaseous() && !IHazmatLike.hasCompleteHazmat((EntityLivingBase)entityIn)) {
                ((EntityPlayer)entityIn).func_70690_d(new PotionEffect((Potion)IUPotion.poison_gas, 200, 0));
            }
            if (((BlockIUFluid)state.func_177230_c()).getFluid() == FluidName.fluidpahoehoe_lava.getInstance() && !entityIn.field_70178_ae) {
                entityIn.func_70097_a(DamageSource.field_76371_c, 2.0f);
                entityIn.func_70015_d(15);
            }
        }
    }

    public void func_176199_a(World world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
    }

    @Nonnull
    public String func_149739_a() {
        return "iu." + super.func_149739_a().substring(5);
    }
}

