/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOre
extends BlockCore
implements IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockOre() {
        super(Material.field_151576_e, "industrialupgrade");
        this.func_149663_c("baseore");
        this.func_149647_a(IUCore.OreTab);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.titanium)));
        this.setHarvestLevel("pickaxe", 1);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "iu." + Type.values()[meta].func_176610_l() + ".name";
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        ret.add((Object)new ItemStack((Item)IUItem.rawMetals, 1 + this.getDrop(fortune), this.func_176201_c(state)));
        return ret;
    }

    private int getDrop(int fortune) {
        switch (fortune) {
            case 0: {
                return 0;
            }
            case 1: {
                return WorldBaseGen.random.nextInt(100) < 25 ? 1 : 0;
            }
            case 2: {
                return WorldBaseGen.random.nextInt(100) < 50 ? 1 : 0;
            }
        }
        return WorldBaseGen.random.nextInt(100) < 75 ? 1 : 0;
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
    }

    @Override
    public boolean preInit() {
        this.setRegistryName("baseore");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore(this);
        itemBlock.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        IUCore.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        mikhail(0),
        aluminium(1),
        vanady(2),
        wolfram(3),
        cobalt(4),
        magnesium(5),
        nickel(6),
        platium(7),
        titanium(8),
        chromium(9),
        spinel(10),
        silver(11),
        zinc(12),
        manganese(13),
        iridium(14),
        germanium(15);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return 0;
        }

        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }
    }
}

