/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class BlockResource
extends BlockCore
implements IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockResource() {
        super(Material.field_151576_e, "industrialupgrade");
        this.func_149663_c("blockresource");
        this.func_149647_a(IUCore.IUTab);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.bronze_block)));
        this.setHarvestLevel("pickaxe", 1);
        this.setHarvestLevel("shovel", 1, this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.peat)));
        this.setHarvestLevel("shovel", 1, this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.untreated_peat)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77952_i() == 10) {
            tooltip.add(Localization.translate("iu.ore_spawn.info"));
        }
    }

    public ItemStack getItemStack(Type type) {
        return this.getItemStack(this.getState(type));
    }

    public IBlockState getState(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("invalid type: " + (Object)((Object)type));
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type));
    }

    public ItemStack getItemStack(IBlockState state) {
        if (state.func_177230_c() != this) {
            return null;
        }
        Item item = Item.func_150898_a((Block)this);
        if (item != Items.field_190931_a) {
            int meta = this.func_176201_c(state);
            return new ItemStack(item, 1, meta);
        }
        throw new RuntimeException("no matching item for " + this);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.func_176201_c(state) != 10) {
            super.getDrops(drops, world, pos, state, fortune);
        } else {
            Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
            int count = rand.nextInt(3) + 1;
            for (int i = 0; i < 1; ++i) {
                drops.add((Object)new ItemStack((Item)IUItem.peat_balls, count));
            }
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "iu." + Type.values()[meta].func_176610_l() + ".name";
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return ((Type)((Object)state.func_177229_b(VARIANT))).getExplosionResistance();
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177229_b(VARIANT) != Type.tempered_glass;
    }

    public boolean func_149730_j(IBlockState state) {
        return state.func_177229_b(VARIANT) == Type.tempered_glass;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(VARIANT) != Type.tempered_glass;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(VARIANT) != Type.tempered_glass;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (state.func_177229_b(VARIANT) != Type.tempered_glass) {
            return super.func_176225_a(state, world, pos, side);
        }
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((Type)((Object)blockState.func_177229_b(VARIANT))).getHardness();
    }

    @Override
    public boolean preInit() {
        this.setRegistryName("blockresource");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore(this);
        itemBlock.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        IUCore.proxy.addIModelRegister(this);
        return true;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).metal ? SoundType.field_185852_e : SoundType.field_185851_d;
    }

    public boolean initialize() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        cryogen(8.0f, 10.0f, true),
        bronze_block(5.0f, 10.0f, true),
        copper_block(4.0f, 10.0f, true),
        lead_block(4.0f, 10.0f, true),
        steel_block(8.0f, 10.0f, true),
        tin_block(4.0f, 10.0f, true),
        uranium_block(6.0f, 10.0f, true),
        reinforced_stone(80.0f, 180.0f, false),
        machine(5.0f, 10.0f, true),
        advanced_machine(8.0f, 10.0f, true),
        peat(1.0f, 1.0f, false),
        untreated_peat(1.0f, 1.0f, false),
        steam_machine(8.0f, 10.0f, true),
        tempered_glass(0.1f, 7.0f, false),
        bio_machine(8.1f, 7.0f, true),
        asphalt(0.1f, 1.0f, false);

        private final float hardness;
        private final float explosionResistance;
        private final boolean metal;
        private final int metadata = this.ordinal();
        private final String name = this.name().toLowerCase(Locale.US);

        private Type(float hardness, float explosionResistance, boolean metal) {
            this.hardness = hardness;
            this.explosionResistance = explosionResistance;
            this.metal = metal;
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public float getExplosionResistance() {
            return this.explosionResistance;
        }

        public float getHardness() {
            return this.hardness;
        }

        public boolean isMetal() {
            return this.metal;
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return 0;
        }

        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }
    }
}

