/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSpace1
extends BlockCore
implements IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockSpace1() {
        super(Material.field_151576_e, "industrialupgrade");
        this.func_149663_c("blockspace2");
        this.func_149647_a(IUCore.OreTab);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.europa_mikhail_ore)));
        this.setHarvestLevel("pickaxe", 1);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    @Nonnull
    public IBlockState getStateMeta(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "iu." + Type.values()[meta].func_176610_l() + ".name";
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
    }

    @Override
    public boolean preInit() {
        this.setRegistryName("blockspace2");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore(this);
        itemBlock.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        IUCore.proxy.addIModelRegister(this);
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        Type type = Type.values()[this.func_176201_c(state)];
        if (type.ordinal() == 0 || type.ordinal() == 1 || type.ordinal() == 4 || type.ordinal() == 7 || type.ordinal() == 12 || type.ordinal() == 13 || type.ordinal() == 14) {
            ItemStack stack = type.getStack();
            if (stack == null) {
                stack = (ItemStack)OreDictionary.getOres((String)type.getRaw()).get(0);
                type.setStack(stack);
            }
            stack = stack.func_77946_l();
            stack.func_190920_e(1 + this.getDrop(fortune));
            ret.add((Object)stack);
        } else if (type.ordinal() == 6) {
            int i = WorldBaseGen.random.nextInt(fortune + 1) + 1;
            ret.add((Object)new ItemStack(Items.field_151045_i, i));
        } else if (type.ordinal() == 10) {
            int i = WorldBaseGen.random.nextInt(fortune + 1) + 1;
            ret.add((Object)new ItemStack(Items.field_151166_bC, i));
        } else if (type.ordinal() == 11) {
            ret.add((Object)ModUtils.setSize(IUItem.smallSulfurDust, 4 + WorldBaseGen.random.nextInt(fortune + 1)));
        } else if (type.ordinal() == 9) {
            int i = WorldBaseGen.random.nextInt(fortune + 2) + 1;
            ret.add((Object)new ItemStack(Items.field_151128_bU, i));
        } else if (type.ordinal() == 5) {
            if (WorldBaseGen.random.nextDouble() < 0.5) {
                ret.add((Object)new ItemStack((Block)IUItem.apatite, 1, 1));
            } else {
                ret.add((Object)new ItemStack((Block)IUItem.apatite, 1, 0));
            }
        } else {
            ret.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
        return ret;
    }

    private int getDrop(int fortune) {
        switch (fortune) {
            case 0: {
                return 0;
            }
            case 1: {
                return WorldBaseGen.random.nextDouble() < 0.25 ? 1 : 0;
            }
            case 2: {
                return WorldBaseGen.random.nextDouble() < 0.5 ? 1 : 0;
            }
        }
        return WorldBaseGen.random.nextDouble() < 0.75 ? 1 : 0;
    }

    public static enum Type implements IStringSerializable
    {
        europa_mikhail_ore(0),
        ganymede_aluminium_ore(1),
        ganymede_beryllium(2),
        ganymede_calcium(3),
        ganymede_tungsten_ore(4),
        haumea_apatite(5),
        haumea_diamond(6),
        haumea_iridium(7),
        haumea_lithium(8),
        haumea_quartz(9),
        io_emerald_ore(10),
        io_sulfur(11),
        makemake_bismuth(12),
        makemake_gold(13),
        makemake_silver(14),
        mars_adamantium_ore(15);

        private final int metadata;
        private final String name;
        ItemStack stack;
        private String raw;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String getRaw() {
            return this.raw;
        }

        public void setRaw(String name) {
            this.raw = "raw" + name;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return 0;
        }

        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }
    }
}

