/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUCore;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSpace3
extends BlockCore
implements IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockSpace3() {
        super(Material.field_151576_e, "industrialupgrade");
        this.func_149663_c("blockspace4");
        this.func_149647_a(IUCore.OreTab);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.rhea_chromium)));
        this.setHarvestLevel("pickaxe", 1);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    @Nonnull
    public IBlockState getStateMeta(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "iu." + Type.values()[meta].func_176610_l() + ".name";
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.values()[i].func_176610_l()));
        }
    }

    @Override
    public boolean preInit() {
        this.setRegistryName("blockspace4");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore(this);
        itemBlock.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        IUCore.proxy.addIModelRegister(this);
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        Type type = Type.values()[this.func_176201_c(state)];
        if (type.ordinal() != 12) {
            ItemStack stack = type.getStack();
            if (stack == null) {
                stack = (ItemStack)OreDictionary.getOres((String)type.getRaw()).get(0);
                type.setStack(stack);
            }
            stack = stack.func_77946_l();
            stack.func_190920_e(1 + this.getDrop(fortune));
            ret.add((Object)stack);
        } else {
            int i = WorldBaseGen.random.nextInt(fortune + 2) + 1;
            ret.add((Object)new ItemStack(Items.field_151045_i, i));
        }
        return ret;
    }

    private int getDrop(int fortune) {
        switch (fortune) {
            case 0: {
                return 0;
            }
            case 1: {
                return WorldBaseGen.random.nextDouble() < 0.25 ? 1 : 0;
            }
            case 2: {
                return WorldBaseGen.random.nextDouble() < 0.5 ? 1 : 0;
            }
        }
        return WorldBaseGen.random.nextDouble() < 0.75 ? 1 : 0;
    }

    public static enum Type implements IStringSerializable
    {
        rhea_chromium(0),
        rhea_osmium_ore(1),
        rhea_vanadium_ore(2),
        tethys_gallium(3),
        tethys_molybdenum_ore(4),
        titan_nickel_ore(5),
        titan_titanium_ore(6),
        titania_polonium_ore(7),
        titania_yttrium(8),
        triton_neodymium(9),
        triton_strontium(10),
        umbriel_spinel_ore(11),
        venus_diamond_ore(12);

        private final int metadata;
        private final String name;
        ItemStack stack;
        private String raw;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return 0;
        }

        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }

        public String getRaw() {
            return this.raw;
        }

        public void setRaw(String name) {
            this.raw = "raw" + name;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }
    }
}

