/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.item.IMultiBlockItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.TileHandlerHeavyOre;
import com.denfop.tiles.mechanism.TileMagnet;
import com.denfop.tiles.mechanism.TileMagnetGenerator;
import com.denfop.tiles.mechanism.TileWitherMaker;
import com.denfop.tiles.mechanism.dual.TileEnrichment;
import com.denfop.tiles.mechanism.dual.TileSynthesis;
import com.denfop.tiles.mechanism.generator.energy.fluid.TileEntityAdvGeoGenerator;
import com.denfop.tiles.mechanism.generator.energy.fluid.TileEntityImpGeoGenerator;
import com.denfop.tiles.mechanism.generator.energy.fluid.TileEntityPerGeoGenerator;
import com.denfop.tiles.mechanism.triple.heat.TileAdvAlloySmelter;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum BlockBaseMachine1 implements IMultiTileBlock,
IMultiBlockItem
{
    adv_alloy_smelter(TileAdvAlloySmelter.class, 3),
    adv_geo(TileEntityAdvGeoGenerator.class, 4),
    imp_geo(TileEntityImpGeoGenerator.class, 5),
    per_geo(TileEntityPerGeoGenerator.class, 6),
    enrichment(TileEnrichment.class, 10),
    synthesis(TileSynthesis.class, 11),
    handler_ho(TileHandlerHeavyOre.class, 12),
    gen_wither(TileWitherMaker.class, 13),
    magnet(TileMagnet.class, 14),
    magnet_generator(TileMagnetGenerator.class, 15);

    public static final ResourceLocation IDENTITY;
    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    int idBlock;
    private TileEntityBlock dummyTe;

    private BlockBaseMachine1(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this(teClass, itemMeta, EnumRarity.UNCOMMON);
    }

    private BlockBaseMachine1(Class<? extends TileEntityBlock> teClass, int itemMeta, EnumRarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)IUCore.getIdentifier(this.func_176610_l()));
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        for (BlockBaseMachine1 block : BlockBaseMachine1.values()) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String func_176610_l() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    @Nonnull
    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return true;
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    @Override
    public float getHardness() {
        return 1.0f;
    }

    @Override
    @Nonnull
    public MultiTileBlock.HarvestTool getHarvestTool() {
        return MultiTileBlock.HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public MultiTileBlock.DefaultDrop getDefaultDrop() {
        return MultiTileBlock.DefaultDrop.Machine;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    @Override
    public boolean hasUniqueRender(ItemStack itemStack) {
        return false;
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack itemStack) {
        return null;
    }

    static {
        IDENTITY = IUCore.getIdentifier("basemachine1");
    }
}

