/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.gaswell.TileEntityGasWellAnalyzer;
import com.denfop.tiles.gaswell.TileEntityGasWellCasing;
import com.denfop.tiles.gaswell.TileEntityGasWellController;
import com.denfop.tiles.gaswell.TileEntityGasWellDrill;
import com.denfop.tiles.gaswell.TileEntityGasWellEnergy;
import com.denfop.tiles.gaswell.TileEntityGasWellTank;
import com.denfop.tiles.gaswell.TileEntityGasWellTransport;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum BlockGasWell implements IMultiTileBlock
{
    gas_well_controller(TileEntityGasWellController.class, 0),
    gas_well_socket(TileEntityGasWellEnergy.class, 1),
    gas_well_analyzer(TileEntityGasWellAnalyzer.class, 2),
    gas_well_drill(TileEntityGasWellDrill.class, 3),
    gas_well_casing(TileEntityGasWellCasing.class, 4),
    gas_well_transport(TileEntityGasWellTransport.class, 5),
    gas_well_tank(TileEntityGasWellTank.class, 6);

    public static final ResourceLocation IDENTITY;
    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final EnumRarity rarity;
    int idBlock;
    private TileEntityBlock dummyTe;

    private BlockGasWell(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this(teClass, itemMeta, EnumRarity.UNCOMMON);
    }

    private BlockGasWell(Class<? extends TileEntityBlock> teClass, int itemMeta, EnumRarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)IUCore.getIdentifier(this.func_176610_l()));
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public Material getMaterial() {
        return Material.field_151573_f;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        for (BlockGasWell block : BlockGasWell.values()) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String func_176610_l() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    @Nonnull
    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return true;
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    @Override
    public float getHardness() {
        return 3.0f;
    }

    @Override
    @Nonnull
    public MultiTileBlock.HarvestTool getHarvestTool() {
        return MultiTileBlock.HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public MultiTileBlock.DefaultDrop getDefaultDrop() {
        return MultiTileBlock.DefaultDrop.Self;
    }

    @Override
    public boolean allowWrenchRotating() {
        return false;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        IDENTITY = IUCore.getIdentifier("gas_well");
    }
}

