/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.transport.tiles.TileEntitySteamPipe;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum BlockSteamPipe implements IMultiTileBlock
{
    spipe(TileEntitySteamPipe.class, -1);

    public static final ResourceLocation IDENTITY;
    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    int idBlock;
    private TileEntityBlock dummyTe;

    private BlockSteamPipe(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)IUCore.getIdentifier(this.func_176610_l()));
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        for (BlockSteamPipe block : BlockSteamPipe.values()) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Material getMaterial() {
        return IMultiTileBlock.CABLE;
    }

    @Override
    public float getHardness() {
        return 0.5f;
    }

    public String func_176610_l() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    @Nonnull
    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    @Override
    public boolean hasItem() {
        return this.teClass != null && this.itemMeta != -1;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return false;
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getSupportedFacings() {
        return ModUtils.noFacings;
    }

    @Override
    @Nonnull
    public MultiTileBlock.HarvestTool getHarvestTool() {
        return MultiTileBlock.HarvestTool.Pickaxe;
    }

    @Override
    @Nonnull
    public MultiTileBlock.DefaultDrop getDefaultDrop() {
        return MultiTileBlock.DefaultDrop.Self;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        IDENTITY = IUCore.getIdentifier("spipe");
    }
}

