/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.state;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.blocks.state.State;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TypeProperty
implements IProperty<State> {
    public static State invalid = new StatesBlocks((IMultiTileBlock)MultiTileBlock.invalid, (String)"", null).statesBlocks.get(0);
    public final String resourceLocationName;
    private final HashMap<IMultiTileBlock, StatesBlocks> mapStates;
    public List<State> allowedValues;
    List<StatesBlocks> locationBlocks;

    public TypeProperty(ResourceLocation identifier, TileBlockCreator.InfoAboutTile<?> value) {
        this.resourceLocationName = identifier.toString();
        this.mapStates = new HashMap();
        this.locationBlocks = new LinkedList<StatesBlocks>();
        for (IMultiTileBlock teBlock : value.getTeBlocks()) {
            String stateName = teBlock.hasActive() ? "active" : "";
            String[] multiModels = teBlock.getMultiModels(teBlock);
            StatesBlocks state = new StatesBlocks(teBlock, stateName, multiModels);
            this.locationBlocks.add(state);
            this.mapStates.put(teBlock, state);
        }
        this.allowedValues = new LinkedList<State>();
        this.allowedValues.add(invalid);
        for (StatesBlocks teBlockPair : this.locationBlocks) {
            this.allowedValues.addAll(teBlockPair.statesBlocks);
        }
        this.allowedValues = new ArrayList<State>(this.allowedValues);
        this.locationBlocks = new ArrayList<StatesBlocks>(this.locationBlocks);
    }

    public List<StatesBlocks> getAllStates() {
        return this.locationBlocks;
    }

    public State getState(IMultiTileBlock teBlock) {
        return this.getState(teBlock, "");
    }

    public State getState(IMultiTileBlock teBlock, String active) {
        StatesBlocks state = this.mapStates.get(teBlock);
        return state == null ? invalid : state.getState(active);
    }

    public String func_177701_a() {
        return "type";
    }

    @NotNull
    public Collection<State> func_177700_c() {
        return this.allowedValues;
    }

    @NotNull
    public Class<State> func_177699_b() {
        return State.class;
    }

    public Optional<State> func_185929_b(String value) {
        for (State block : this.allowedValues) {
            if (!this.getName(block).equals(value)) continue;
            return Optional.of((Object)block);
        }
        return Optional.absent();
    }

    public String getName(State value) {
        return !value.state.isEmpty() ? value.teBlock.func_176610_l() + "_" + value.state : value.teBlock.func_176610_l();
    }

    public String toString() {
        return "TypeProperty{For " + this.resourceLocationName + '}';
    }

    public static class StatesBlocks {
        public final boolean hasActive;
        public List<State> statesBlocks = new ArrayList<State>();

        public StatesBlocks(IMultiTileBlock block, String state, String[] multiModels) {
            this.statesBlocks.add(new State(block, ""));
            if (state.equals("active")) {
                this.statesBlocks.add(new State(block, state));
                this.hasActive = true;
            } else {
                this.hasActive = false;
            }
            if (multiModels != null) {
                for (String multiModel : multiModels) {
                    this.statesBlocks.add(new State(block, multiModel));
                }
            }
        }

        public IMultiTileBlock getBlock() {
            return this.statesBlocks.get((int)0).teBlock;
        }

        public State getState(String stateName) {
            for (State state : this.statesBlocks) {
                if (!state.state.equals(stateName)) continue;
                return state;
            }
            return this.statesBlocks.get(0);
        }

        public boolean hasActive() {
            return this.hasActive;
        }

        public boolean hasItem() {
            return this.getBlock().hasItem();
        }

        public ResourceLocation getIdentifier() {
            return this.getBlock().getIdentifier();
        }

        public String getName() {
            return this.getBlock().func_176610_l();
        }
    }
}

