/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.pollution.IPollutionMechanism;
import com.denfop.api.pollution.PollutionAirLoadEvent;
import com.denfop.api.pollution.PollutionAirUnLoadEvent;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AirPollutionComponent
extends AbstractComponent
implements IPollutionMechanism {
    private double pollution;
    private double default_pollution;
    private ChunkPos chunkPos;
    private double percent = 1.0;

    public AirPollutionComponent(TileEntityInventory parent, double pollution) {
        super(parent);
        this.pollution = pollution;
        this.default_pollution = pollution;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.parent != null && this.parent.func_145831_w() == null) {
            tooltip.add(Localization.translate("iu.pollution.air.info") + " " + String.format("%.2f", this.default_pollution) + Localization.translate("iu.pollution.air.info1"));
        }
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tagCompound = super.writeToNbt();
        tagCompound.func_74780_a("percent", this.percent);
        return tagCompound;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        this.percent = nbt.func_74769_h("percent");
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(EntityPlayer player) {
        return this.percent != 1.0;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        if (this.percent == 0.0) {
            this.percent = 0.5;
            return new ItemStack((Item)IUItem.antiairpollution1);
        }
        this.percent = 1.0;
        return new ItemStack((Item)IUItem.antiairpollution);
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.percent == 0.0) {
            ret.add(new ItemStack((Item)IUItem.antiairpollution1));
            ret.add(new ItemStack((Item)IUItem.antiairpollution));
        } else if (this.percent == 0.5) {
            ret.add(new ItemStack((Item)IUItem.antiairpollution));
        }
        return ret;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand) {
        if (!this.parent.func_145831_w().field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            Item item = stack.func_77973_b();
            if (this.percent == 1.0 && item == IUItem.antiairpollution) {
                stack.func_190918_g(1);
                this.percent = 0.5;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            } else if (this.percent == 0.5 && item == IUItem.antiairpollution1) {
                stack.func_190918_g(1);
                this.percent = 0.0;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            }
        }
        return super.onBlockActivated(player, hand);
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.pollution = is.readDouble();
        this.default_pollution = is.readDouble();
        this.percent = is.readDouble();
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.parent.getActive()) {
            // empty if block
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.parent.getActive()) {
            this.setPollution(this.default_pollution * this.percent);
        } else {
            this.setPollution(0.0);
        }
    }

    @Override
    public void onLoaded() {
        if (!this.parent.func_145831_w().field_72995_K && this.parent.func_145831_w().field_73011_w.getDimension() == 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirLoadEvent(this.parent.func_145831_w(), this));
        }
    }

    public double getDefault_pollution() {
        return this.default_pollution;
    }

    @Override
    public void onUnloaded() {
        if (!this.parent.func_145831_w().field_72995_K && this.parent.func_145831_w().field_73011_w.getDimension() == 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirUnLoadEvent(this.parent.func_145831_w(), this));
        }
    }

    @Override
    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.getParent().func_174877_v());
        }
        return this.chunkPos;
    }

    @Override
    public double getPollution() {
        return this.pollution;
    }

    public void setPollution(double pollution) {
        if (this.pollution != pollution * this.percent && !this.parent.func_145831_w().field_72995_K && this.parent.func_145831_w().field_73011_w.getDimension() == 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirUnLoadEvent(this.parent.func_145831_w(), this));
            this.pollution = pollution * this.percent;
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirLoadEvent(this.parent.func_145831_w(), this));
        }
    }
}

