/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.sytem.EnergyEvent;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.EnumTypeEvent;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IDual;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.sytem.ISink;
import com.denfop.api.sytem.ISource;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

public class ComponentBaseEnergy
extends AbstractComponent {
    public final boolean fullEnergy;
    private final EnergyType type;
    private final double defaultCapacity;
    public double capacity;
    public double storage;
    public int sinkTier;
    public int sourceTier;
    public Set<EnumFacing> sinkDirections;
    public Set<EnumFacing> sourceDirections;
    public List<InvSlot> managedSlots;
    public boolean multiSource;
    public int sourcePackets;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public double tick;
    protected double pastEnergy;
    protected double perenergy;
    Map<EnumFacing, ITile> energyConductorMap = new HashMap<EnumFacing, ITile>();
    List<InfoTile<ITile>> validReceivers = new LinkedList<InfoTile<ITile>>();
    private double perenergy1;
    private double pastEnergy1;
    private double tick1;
    private long id;

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity) {
        this(type, parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int tier) {
        this(type, parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.type = type;
        this.multiSource = false;
        this.sourcePackets = 1;
        this.capacity = capacity;
        this.defaultCapacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.fullEnergy = fullEnergy;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, List<EnumFacing> sinkDirections, List<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.type = type;
        this.multiSource = false;
        this.sourcePackets = 1;
        this.capacity = capacity;
        this.defaultCapacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = new HashSet<EnumFacing>(sinkDirections);
        this.sourceDirections = new HashSet<EnumFacing>(sourceDirections);
        this.fullEnergy = fullEnergy;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
    }

    public static ComponentBaseEnergy asBasicSink(EnergyType type, TileEntityInventory parent, double capacity) {
        return ComponentBaseEnergy.asBasicSink(type, parent, capacity, 1);
    }

    public static ComponentBaseEnergy asBasicSink(EnergyType type, TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBaseEnergy(type, parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static ComponentBaseEnergy asBasicSource(EnergyType type, TileEntityInventory parent, double capacity) {
        return ComponentBaseEnergy.asBasicSource(type, parent, capacity, 1);
    }

    public static ComponentBaseEnergy asBasicSource(EnergyType type, TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBaseEnergy(type, parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    public EnergyType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return super.toString() + this.type.name().toLowerCase();
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        this.storage = nbt.func_74769_h("storage");
        this.capacity = nbt.func_74769_h("capacity");
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74780_a("storage", this.storage);
        ret.func_74780_a("capacity", this.capacity);
        return ret;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.capacity < this.defaultCapacity) {
            this.capacity = this.defaultCapacity;
        }
        if (!this.parent.func_145831_w().field_72995_K) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                this.energyConductorMap.clear();
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.func_145831_w(), EnumTypeEvent.LOAD, this.type, this.delegate));
            }
            this.loaded = true;
        }
    }

    private void createDelegate() {
        if (this.delegate == null) {
            this.delegate = this.sinkDirections.isEmpty() ? new EnergyNetDelegateSource() : (this.sourceDirections.isEmpty() ? new EnergyNetDelegateSink() : new EnergyNetDelegateDual());
            this.delegate.func_145834_a(this.parent.func_145831_w());
            this.delegate.func_174878_a(this.parent.func_174877_v());
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.func_145831_w(), EnumTypeEvent.UNLOAD, this.type, this.delegate));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        if (this.storage > this.capacity) {
            this.storage = capacity;
        }
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFillRatio() {
        return this.storage / this.capacity;
    }

    public double addEnergy(double amount) {
        amount = Math.min(this.capacity - this.storage, amount);
        this.storage += amount;
        return amount;
    }

    @Override
    public void blockBreak() {
        if (this.getType() == EnergyType.RADIATION) {
            new PacketUpdateRadiationValue(new ChunkPos(this.parent.func_174877_v()), (int)this.storage);
        } else if (this.getType() == EnergyType.EXPERIENCE && this.storage > 0.0) {
            double f = 0.7;
            double dx = (double)this.parent.func_145831_w().field_73012_v.nextFloat() * 1.0 + (1.0 - f) * 0.5;
            double dy = (double)this.parent.func_145831_w().field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
            double dz = (double)this.parent.func_145831_w().field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
            int j = EntityXPOrb.func_70527_a((int)((int)this.storage));
            EntityXPOrb entityItem = new EntityXPOrb(this.parent.func_145831_w(), (double)this.parent.func_174877_v().func_177958_n() + dx, (double)this.parent.func_174877_v().func_177956_o() + dy, (double)this.parent.func_174877_v().func_177952_p() + dz, j);
            this.parent.func_145831_w().func_72838_d((Entity)entityItem);
        }
    }

    public Map<EnumFacing, ITile> getConductors() {
        return this.energyConductorMap;
    }

    public void RemoveTile(EnergyType type, ITile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    public List<InfoTile<ITile>> getValidReceivers() {
        return this.validReceivers;
    }

    public void AddTile(EnergyType type, ITile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<ITile>(tile, facing1.func_176734_d()));
        }
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount) {
            this.storage -= amount;
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount);
        if (!simulate) {
            this.storage -= ret;
        }
        return ret;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.sourceTier = tier;
    }

    public long getIdNetwork() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public void setDirections(Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections) {
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            this.energyConductorMap.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.func_145831_w(), EnumTypeEvent.UNLOAD, this.type, this.delegate));
        }
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.energyConductorMap.clear();
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            this.energyConductorMap.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.func_145831_w(), EnumTypeEvent.LOAD, this.type, this.delegate));
        }
    }

    public Set<EnumFacing> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<EnumFacing> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public ITile getDelegate() {
        return this.delegate;
    }

    private double getSourceEnergy() {
        return this.storage;
    }

    public double getFreeEnergy() {
        return this.capacity - this.storage;
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements ISource {
        int hashCodeSource;
        boolean hasHashCode;
        private int hashCode;

        private EnergyNetDelegateSource() {
            this.hasHashCode = false;
        }

        public int getSourceTier() {
            return ComponentBaseEnergy.this.sourceTier;
        }

        @Override
        public boolean emitsTo(IAcceptor receiver, EnumFacing dir) {
            return ComponentBaseEnergy.this.sourceDirections.contains(dir);
        }

        @Override
        public long getIdNetwork() {
            return ComponentBaseEnergy.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            ComponentBaseEnergy.this.setId(id);
        }

        @Override
        public void AddTile(EnergyType type, ITile tile, EnumFacing dir) {
            ComponentBaseEnergy.this.AddTile(type, tile, dir);
        }

        @Override
        public void RemoveTile(EnergyType type, ITile tile, EnumFacing dir) {
            ComponentBaseEnergy.this.RemoveTile(type, tile, dir);
        }

        @Override
        public Map<EnumFacing, ITile> getTiles(EnergyType energyType) {
            return ComponentBaseEnergy.this.energyConductorMap;
        }

        @Override
        public List<InfoTile<ITile>> getValidReceivers(EnergyType energyType) {
            return ComponentBaseEnergy.this.validReceivers;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return ComponentBaseEnergy.this.parent.func_174877_v();
        }

        @Override
        public double canProvideEnergy() {
            assert (!ComponentBaseEnergy.this.sourceDirections.isEmpty());
            return !ComponentBaseEnergy.this.sendingSidabled ? ComponentBaseEnergy.this.getSourceEnergy() : 0.0;
        }

        @Override
        public TileEntity getTile() {
            return ComponentBaseEnergy.this.parent;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= ComponentBaseEnergy.this.storage);
            ComponentBaseEnergy.this.useEnergy(amount);
        }

        @Override
        public double getPerEnergy() {
            return ComponentBaseEnergy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return ComponentBaseEnergy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            ComponentBaseEnergy.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    private class EnergyNetDelegateSink
    extends EnergyNetDelegate
    implements ISink {
        int hashCodeSource;
        boolean hasHashCode;
        List<ISource> systemTicks;
        private int hashCode;

        private EnergyNetDelegateSink() {
            this.hasHashCode = false;
            this.systemTicks = new LinkedList<ISource>();
        }

        public int getSinkTier() {
            return ComponentBaseEnergy.this.sinkTier;
        }

        @Override
        public boolean acceptsFrom(IEmitter emitter, EnumFacing dir) {
            return ComponentBaseEnergy.this.sinkDirections.contains(dir);
        }

        @Override
        public long getIdNetwork() {
            return ComponentBaseEnergy.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public List<ISource> getEnergyTickList() {
            return this.systemTicks;
        }

        @Override
        public void setId(long id) {
            ComponentBaseEnergy.this.setId(id);
        }

        @Override
        public void AddTile(EnergyType type, ITile tile, EnumFacing dir) {
            ComponentBaseEnergy.this.AddTile(type, tile, dir);
        }

        @Override
        public void RemoveTile(EnergyType type, ITile tile, EnumFacing dir) {
            ComponentBaseEnergy.this.RemoveTile(type, tile, dir);
        }

        @Override
        public Map<EnumFacing, ITile> getTiles(EnergyType energyType) {
            return ComponentBaseEnergy.this.energyConductorMap;
        }

        @Override
        public List<InfoTile<ITile>> getValidReceivers(EnergyType energyType) {
            return ComponentBaseEnergy.this.validReceivers;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return ComponentBaseEnergy.this.parent.func_174877_v();
        }

        @Override
        public double getDemanded() {
            assert (!ComponentBaseEnergy.this.sinkDirections.isEmpty());
            return !ComponentBaseEnergy.this.receivingDisabled && ComponentBaseEnergy.this.storage < ComponentBaseEnergy.this.capacity ? ComponentBaseEnergy.this.capacity - ComponentBaseEnergy.this.storage : 0.0;
        }

        @Override
        public TileEntity getTile() {
            return ComponentBaseEnergy.this.parent;
        }

        @Override
        public void receivedEnergy(double amount) {
            ComponentBaseEnergy.this.addEnergy(amount);
        }

        @Override
        public double getPerEnergy() {
            return ComponentBaseEnergy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return ComponentBaseEnergy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            ComponentBaseEnergy.this.perenergy += setEnergy;
        }

        @Override
        public void addTick(double tick) {
            ComponentBaseEnergy.this.tick = tick;
        }

        @Override
        public double getTick() {
            return ComponentBaseEnergy.this.tick;
        }

        @Override
        public boolean isSink() {
            return true;
        }
    }

    private class EnergyNetDelegateDual
    extends EnergyNetDelegate
    implements IDual {
        List<ISource> systemTicks;
        int hashCodeSource;
        boolean hasHashCode;
        private int hashCode;

        private EnergyNetDelegateDual() {
            this.systemTicks = new LinkedList<ISource>();
            this.hasHashCode = false;
        }

        @Override
        public boolean acceptsFrom(IEmitter emitter, EnumFacing dir) {
            return ComponentBaseEnergy.this.sinkDirections.contains(dir);
        }

        @Override
        public boolean emitsTo(IAcceptor receiver, EnumFacing dir) {
            return ComponentBaseEnergy.this.sourceDirections.contains(dir);
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return ComponentBaseEnergy.this.parent.func_174877_v();
        }

        @Override
        public double canProvideEnergy() {
            return !ComponentBaseEnergy.this.sendingSidabled && !ComponentBaseEnergy.this.sourceDirections.isEmpty() ? ComponentBaseEnergy.this.getSourceEnergy() : 0.0;
        }

        public int getSinkTier() {
            return ComponentBaseEnergy.this.sinkTier;
        }

        public int getSourceTier() {
            return ComponentBaseEnergy.this.sourceTier;
        }

        @Override
        public double getDemanded() {
            return !ComponentBaseEnergy.this.receivingDisabled && !ComponentBaseEnergy.this.sinkDirections.isEmpty() && ComponentBaseEnergy.this.storage < ComponentBaseEnergy.this.capacity ? ComponentBaseEnergy.this.capacity - ComponentBaseEnergy.this.storage : 0.0;
        }

        @Override
        public void receivedEnergy(double var2) {
            ComponentBaseEnergy.this.addEnergy(var2);
        }

        @Override
        public double getPerEnergy1() {
            return ComponentBaseEnergy.this.perenergy1;
        }

        @Override
        public double getPastEnergy1() {
            return ComponentBaseEnergy.this.pastEnergy1;
        }

        @Override
        public void setPastEnergy1(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy1 = pastEnergy;
        }

        @Override
        public void addPerEnergy1(double setEnergy) {
            ComponentBaseEnergy componentBaseEnergy = ComponentBaseEnergy.this;
            componentBaseEnergy.perenergy1 = componentBaseEnergy.perenergy1 + setEnergy;
        }

        @Override
        public void addTick1(double tick) {
            ComponentBaseEnergy.this.tick1 = tick;
        }

        @Override
        public double getTick1() {
            return ComponentBaseEnergy.this.tick1;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= ComponentBaseEnergy.this.storage);
            ComponentBaseEnergy.this.useEnergy(amount);
        }

        @Override
        public double getPerEnergy() {
            return ComponentBaseEnergy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return ComponentBaseEnergy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            ComponentBaseEnergy.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return true;
        }

        @Override
        public void addTick(double tick) {
            ComponentBaseEnergy.this.tick = tick;
        }

        @Override
        public double getTick() {
            return ComponentBaseEnergy.this.tick;
        }

        @Override
        public boolean isSink() {
            return true;
        }

        @Override
        public List<ISource> getEnergyTickList() {
            return this.systemTicks;
        }

        @Override
        public long getIdNetwork() {
            return ComponentBaseEnergy.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            ComponentBaseEnergy.this.setId(id);
        }

        @Override
        public void AddTile(EnergyType type, ITile tile, EnumFacing dir) {
            ComponentBaseEnergy.this.AddTile(type, tile, dir);
        }

        @Override
        public void RemoveTile(EnergyType type, ITile tile, EnumFacing dir) {
            ComponentBaseEnergy.this.RemoveTile(type, tile, dir);
        }

        @Override
        public Map<EnumFacing, ITile> getTiles(EnergyType energyType) {
            return ComponentBaseEnergy.this.energyConductorMap;
        }

        @Override
        public List<InfoTile<ITile>> getValidReceivers(EnergyType energyType) {
            return ComponentBaseEnergy.this.validReceivers;
        }

        @Override
        public TileEntity getTile() {
            return ComponentBaseEnergy.this.parent;
        }
    }

    private static abstract class EnergyNetDelegate
    extends TileEntity
    implements ITile {
        private EnergyNetDelegate() {
        }
    }
}

