/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.sytem.EnergyType;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.effects.BiomassParticle;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ComponentBioFuelEnergy
extends ComponentBaseEnergy {
    FluidTank fluidTank;

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity) {
        this(type, parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int tier) {
        this(type, parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier, fullEnergy);
    }

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity, List<EnumFacing> sinkDirections, List<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier, fullEnergy);
    }

    public static ComponentBioFuelEnergy asBasicSink(TileEntityInventory parent, double capacity) {
        return ComponentBioFuelEnergy.asBasicSink(parent, capacity, 1);
    }

    public static ComponentBioFuelEnergy asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBioFuelEnergy(EnergyType.BIOFUEL, parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static ComponentBioFuelEnergy asBasicSource(TileEntityInventory parent, double capacity) {
        return ComponentBioFuelEnergy.asBasicSource(parent, capacity, 1);
    }

    public static ComponentBioFuelEnergy asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBioFuelEnergy(EnergyType.BIOFUEL, parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    public void setFluidTank(FluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    @Override
    public double addEnergy(double amount) {
        super.addEnergy(amount);
        if (this.fluidTank.getFluid() == null && amount >= 1.0) {
            this.fluidTank.fill(new FluidStack(FluidName.fluidbiomass.getInstance(), (int)this.storage), true);
        } else if (this.fluidTank.getFluid() != null) {
            this.fluidTank.getFluid().amount = (int)this.storage;
        }
        return amount;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.parent.getActive() && this.parent.func_145831_w().func_72820_D() % 4L == 0L) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new BiomassParticle(this.parent.func_145831_w(), (double)this.parent.func_174877_v().func_177958_n() + 0.5, this.parent.func_174877_v().func_177956_o() + 1, (double)this.parent.func_174877_v().func_177952_p() + 0.5));
        }
    }

    @Override
    public boolean useEnergy(double amount) {
        super.useEnergy(amount);
        if (this.fluidTank.getFluid() != null) {
            this.fluidTank.getFluid().amount = (int)this.storage;
            if (this.fluidTank.getFluid().amount == 0) {
                this.fluidTank.setFluid(null);
            }
        }
        return true;
    }
}

