/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.List;
import net.minecraftforge.fluids.FluidTank;

public class ComponentFluidProcess
extends AbstractComponent {
    private final FluidHandlerRecipe fluid_handler;
    private final InvSlotFluidByList[] outputsSlot;
    private final InvSlotFluidByList[] inputSlot;
    private final InvSlotRecipes inputSlotA;
    private final InvSlotOutput output1;
    private final boolean needConsumeFluid;
    private final IUpdateTick updateTick;

    public ComponentFluidProcess(TileEntityInventory parent, Fluids fluids, String recipe, boolean hasItem, IUpdateTick updateTick, boolean needOutputSlotForInput, boolean needOutputSlotForOutput, boolean needConsumeFluid) {
        super(parent);
        int i;
        this.fluid_handler = new FluidHandlerRecipe(recipe, fluids);
        List<FluidTank> inputTanks = this.fluid_handler.getInputTank();
        List<FluidTank> outputTanks = this.fluid_handler.getOutputTank();
        this.outputsSlot = new InvSlotFluidByList[outputTanks.size()];
        this.inputSlot = new InvSlotFluidByList[inputTanks.size()];
        for (i = 0; i < inputTanks.size(); ++i) {
            ((Fluids.InternalFluidTank)inputTanks.get(i)).setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(i)));
            this.inputSlot[i] = new InvSlotFluidByList(parent, 1, this.fluid_handler.getFluids(i));
        }
        for (i = 0; i < outputTanks.size(); ++i) {
            ((Fluids.InternalFluidTank)outputTanks.get(i)).setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(i)));
            this.outputsSlot[i] = new InvSlotFluidByList(parent, 1, this.fluid_handler.getOutputFluids(i));
        }
        this.inputSlotA = hasItem ? new InvSlotRecipes(parent, recipe, updateTick) : null;
        this.updateTick = updateTick;
        int size = 0;
        if (needOutputSlotForInput) {
            size += inputTanks.size();
        }
        if (needOutputSlotForOutput) {
            size += outputTanks.size();
        }
        this.output1 = size > 0 ? new InvSlotOutput(parent, size) : null;
        this.needConsumeFluid = needConsumeFluid;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.parent.func_145831_w().field_72995_K) {
            if (this.inputSlotA != null) {
                this.inputSlotA.load();
                this.fluid_handler.load(this.inputSlotA.get());
                this.updateTick.setRecipeOutput(this.getOutput());
            } else {
                this.fluid_handler.load();
            }
        }
    }

    public MachineRecipe getOutput() {
        return this.inputSlotA.process();
    }

    public InvSlotFluidByList[] getInputSlot() {
        return this.inputSlot;
    }

    public InvSlotFluidByList[] getOutputsSlot() {
        return this.outputsSlot;
    }

    public FluidHandlerRecipe getFluidHandler() {
        return this.fluid_handler;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public boolean isServer() {
        return true;
    }
}

