/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.proxy.CommonProxy;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileEntityTesseract;
import com.denfop.tiles.mechanism.TileEntitySafe;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class ComponentPrivate
extends AbstractComponent {
    private final List<String> players = new ArrayList<String>();
    private final List<UUID> playersUUID = new ArrayList<UUID>();
    boolean activate = false;

    public ComponentPrivate(TileEntityInventory parent) {
        super(parent);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand) {
        super.onBlockActivated(player, hand);
        ItemStack stack = player.func_184586_b(hand);
        if (!this.activate && !stack.func_190926_b() && this.players.contains(player.func_70005_c_()) && stack.func_77973_b() == IUItem.module7 && stack.func_77952_i() == 0) {
            this.activate = true;
            for (int m = 0; m < 9; ++m) {
                String name;
                NBTTagCompound nbt = ModUtils.nbt(stack);
                if (nbt.func_74779_i(name = "player_" + m).isEmpty()) continue;
                this.players.add(nbt.func_74779_i(name));
                this.playersUUID.add(player.func_130014_f_().func_72924_a(nbt.func_74779_i(name)).func_110124_au());
            }
            stack.func_190918_g(1);
            return true;
        }
        if (this.activate && !this.getParent().func_145831_w().field_72995_K && !this.players.contains(player.func_70005_c_()) && !player.field_71075_bZ.field_75098_d) {
            CommonProxy.sendPlayerMessage(player, Localization.translate("iu.error"));
            return true;
        }
        return false;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof EntityPlayer) {
            this.players.add(placer.func_70005_c_());
            this.playersUUID.add(placer.func_110124_au());
        }
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        return !this.activate || entity instanceof EntityPlayer && (this.players.contains(entity.func_70005_c_()) || ((EntityPlayer)entity).field_71075_bZ.field_75098_d);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return !this.activate || player != null && (this.players.contains(player.func_70005_c_()) || player.field_71075_bZ.field_75098_d);
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(EntityPlayer player) {
        return !(this.parent instanceof TileEntityTesseract) && !(this.parent instanceof TileEntitySafe) && this.activate && (this.players.contains(player.func_70005_c_()) || player.field_71075_bZ.field_75098_d);
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        this.activate = false;
        String player = this.players.get(0);
        UUID playerUUID = this.playersUUID.get(0);
        this.players.clear();
        this.playersUUID.clear();
        this.players.add(player);
        this.playersUUID.add(playerUUID);
        return new ItemStack(IUItem.module7);
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.activate && !(this.parent instanceof TileEntityTesseract) && !(this.parent instanceof TileEntitySafe)) {
            ret.add(new ItemStack(IUItem.module7));
        }
        return ret;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        int i;
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74768_a("size", this.players.size());
        for (i = 0; i < this.players.size(); ++i) {
            nbt.func_74778_a("player_" + i, this.players.get(i));
        }
        nbt.func_74768_a("size1", this.playersUUID.size());
        for (i = 0; i < this.playersUUID.size(); ++i) {
            nbt.func_186854_a("playerUUID_" + i, this.playersUUID.get(i));
        }
        nbt.func_74757_a("activate", this.activate);
        return nbt;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        int size = nbt.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            this.players.add(nbt.func_74779_i("player_" + i));
        }
        int size1 = nbt.func_74762_e("size1");
        for (int i = 0; i < size1; ++i) {
            this.playersUUID.add(nbt.func_186857_a("playerUUID_" + i));
        }
        this.activate = nbt.func_74767_n("activate");
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        buffer.writeInt(this.players.size());
        buffer.writeInt(this.playersUUID.size());
        buffer.writeBoolean(this.activate);
        this.players.forEach(buffer::writeString);
        this.playersUUID.forEach(arg_0 -> ((CustomPacketBuffer)buffer).func_179252_a(arg_0));
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        buffer.writeInt(this.players.size());
        buffer.writeInt(this.playersUUID.size());
        buffer.writeBoolean(this.activate);
        this.players.forEach(buffer::writeString);
        this.playersUUID.forEach(arg_0 -> ((CustomPacketBuffer)buffer).func_179252_a(arg_0));
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        int i;
        this.players.clear();
        int size = is.readInt();
        int size1 = is.readInt();
        this.activate = is.readBoolean();
        for (i = 0; i < size; ++i) {
            this.players.add(is.readString());
        }
        for (i = 0; i < size1; ++i) {
            this.playersUUID.add(is.func_179253_g());
        }
    }

    public List<UUID> getPlayersUUID() {
        return this.playersUUID;
    }

    public List<String> getPlayers() {
        return this.players;
    }
}

