/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.sytem.EnergyType;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.effects.SteamParticle;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ComponentSteamEnergy
extends ComponentBaseEnergy {
    FluidTank fluidTank;

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity) {
        this(type, parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int tier) {
        this(type, parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier, fullEnergy);
    }

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity, List<EnumFacing> sinkDirections, List<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier, fullEnergy);
    }

    public static ComponentSteamEnergy asBasicSink(TileEntityInventory parent, double capacity) {
        return ComponentSteamEnergy.asBasicSink(parent, capacity, 1);
    }

    public static ComponentSteamEnergy asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentSteamEnergy(EnergyType.STEAM, parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static ComponentSteamEnergy asBasicSource(TileEntityInventory parent, double capacity) {
        return ComponentSteamEnergy.asBasicSource(parent, capacity, 1);
    }

    public static ComponentSteamEnergy asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentSteamEnergy(EnergyType.STEAM, parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        NBTTagCompound nbt1 = nbt.func_74775_l("steam");
        this.addEnergy(nbt1.func_74769_h("energy"));
    }

    @Override
    public List<ItemStack> getAuxDrops(List<ItemStack> ret) {
        if (ret.get(0).func_77969_a(this.getParent().getPickBlock(null, null))) {
            NBTTagCompound nbt = ModUtils.nbt(ret.get(0));
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74780_a("energy", this.storage);
            nbt.func_74782_a("steam", (NBTBase)nbt1);
        }
        return ret;
    }

    public void setFluidTank(FluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    @Override
    public double addEnergy(double amount) {
        super.addEnergy(amount);
        if (this.fluidTank.getFluid() == null && amount >= 1.0) {
            this.fluidTank.fill(new FluidStack(FluidName.fluidsteam.getInstance(), (int)this.storage), true);
        } else if (this.fluidTank.getFluid() != null) {
            this.fluidTank.getFluid().amount = (int)this.storage;
        }
        return amount;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.parent.getActive() && this.parent.func_145831_w().func_72820_D() % 4L == 0L) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new SteamParticle(this.parent.func_145831_w(), this.parent.func_174877_v().func_177958_n(), this.parent.func_174877_v().func_177956_o() + 1, this.parent.func_174877_v().func_177952_p()));
        }
    }

    @Override
    public boolean useEnergy(double amount) {
        super.useEnergy(amount);
        if (this.fluidTank.getFluid() != null) {
            this.fluidTank.getFluid().amount = (int)this.storage;
            if (this.fluidTank.getFluid().amount == 0) {
                this.fluidTank.setFluid(null);
            }
        }
        return true;
    }
}

