/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.blocks.FluidName;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Action;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.PressureComponent;
import com.denfop.componets.TypeLoad;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Timer;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ComponentSteamProcess
extends AbstractComponent {
    protected final double defaultEnergyConsume;
    protected final int defaultOperationLength;
    private final int pressure;
    protected double energyConsume;
    protected int operationLength;
    protected ComponentProgress componentProgress;
    protected InvSlotRecipes invSlotRecipes;
    protected int operationsPerTick;
    protected int tick;
    protected InvSlotOutput outputSlot;
    protected IUpdateTick updateTick;
    protected boolean hasTank = false;
    protected boolean hasAudio = false;
    protected HeatComponent heatComponent;
    ComponentSteamEnergy advEnergy;
    PressureComponent pressureComponent;
    private boolean audoFix;
    private Action action;
    private Timer timer1 = new Timer(0, 0, 0);
    private Timer timer = null;

    public ComponentSteamProcess(TileEntityInventory parent, int operationLength, double energyConsume, int pressure) {
        super(parent);
        this.defaultEnergyConsume = this.energyConsume = energyConsume;
        this.defaultOperationLength = this.operationLength = operationLength;
        this.pressure = pressure;
        this.operationsPerTick = 1;
    }

    public boolean checkHeatRecipe() {
        if (this.heatComponent == null) {
            return true;
        }
        if ((double)this.updateTick.getRecipeOutput().getRecipe().output.metadata.func_74765_d("temperature") <= this.heatComponent.getEnergy()) {
            return true;
        }
        if (!this.heatComponent.need) {
            this.heatComponent.need = true;
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand) {
        FluidStack fluid;
        ItemStack stack = player.func_184586_b(hand);
        if (!(!stack.func_77973_b().equals(IUItem.canister) || (fluid = FluidUtil.getFluidContained((ItemStack)stack)) == null || fluid.getFluid() != FluidName.fluidsteam_oil.getInstance() || fluid.amount < 250 || this.timer1.canWork() && this.timer1.getBar() != 0 || this.timer != null && this.timer.canWork())) {
            this.timer = new Timer(0, 0, 40);
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
            handler.drain(250, true);
            return true;
        }
        return super.onBlockActivated(player, hand);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.componentProgress = (ComponentProgress)this.getParent().getComp("com.denfop.componets.ComponentProgress");
        this.advEnergy = this.getParent().getComp(ComponentSteamEnergy.class);
        this.pressureComponent = this.getParent().getComp(PressureComponent.class);
        this.audoFix = this.getParent() instanceof IAudioFixer;
        this.heatComponent = this.getParent().getComp(HeatComponent.class);
    }

    public void setSlotOutput(InvSlotOutput slotOutput) {
        this.outputSlot = slotOutput;
    }

    public double getDefaultEnergyConsume() {
        return this.defaultEnergyConsume;
    }

    public double getEnergyConsume() {
        return this.energyConsume;
    }

    public int getOperationsPerTick() {
        return this.operationsPerTick;
    }

    public int getDefaultOperationLength() {
        return this.defaultOperationLength;
    }

    public void setHasTank(boolean hasTank) {
        this.hasTank = hasTank;
    }

    public void setHasAudio(boolean hasAudio) {
        this.hasAudio = hasAudio;
    }

    public void setInvSlotRecipes(InvSlotRecipes invSlotRecipes) {
        this.invSlotRecipes = invSlotRecipes;
        this.updateTick = invSlotRecipes.getTile();
    }

    public MachineRecipe getOutput() {
        this.updateTick.setRecipeOutput(this.invSlotRecipes.process());
        return this.updateTick.getRecipeOutput();
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public boolean checkFluidRecipe() {
        return !this.hasTank || this.updateTick.getRecipeOutput().getRecipe().input.getFluid() == null || this.invSlotRecipes.getTank().getFluid() != null && this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null && this.invSlotRecipes.getTank().getFluid().getFluid().equals(this.updateTick.getRecipeOutput().getRecipe().input.getFluid().getFluid()) && this.invSlotRecipes.getTank().getFluidAmount() >= this.updateTick.getRecipeOutput().getRecipe().input.getFluid().amount;
    }

    public void updateRecipe() {
    }

    public boolean checkRecipe() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        double energyConsume = this.energyConsume;
        this.updateRecipe();
        if (this.updateTick.getRecipeOutput() != null && this.advEnergy.canUseEnergy(energyConsume *= 1.0) && !this.invSlotRecipes.isEmpty() && this.outputSlot.canAdd(this.updateTick.getRecipeOutput().getRecipe().getOutput().items) && this.checkHeatRecipe() && this.checkRecipe() && this.pressureComponent.getEnergy() == (double)this.pressure && this.checkFluidRecipe() && this.invSlotRecipes.continue_process(this.updateTick.getRecipeOutput())) {
            if (this.heatComponent != null) {
                this.heatComponent.need = true;
            }
            if (!this.parent.getActive()) {
                this.parent.setActive(true);
            }
            if (this.componentProgress.getProgress() == 0 && this.hasAudio && (double)this.operationLength > (double)this.defaultOperationLength * 0.1 && this.audoFix) {
                ((IAudioFixer)((Object)this.getParent())).initiate(0);
            }
            this.componentProgress.addProgress();
            if (this.timer != null && this.timer.canWork()) {
                this.componentProgress.addProgress();
            }
            if (this.action != null && this.action.needAction(TypeLoad.PROGRESS)) {
                this.action.doAction();
            }
            if (this.componentProgress.getMaxValue() != this.operationLength) {
                this.componentProgress.setMaxValue((short)this.operationLength);
            }
            this.consumeEnergy();
            this.advEnergy.useEnergy(energyConsume);
            if (this.componentProgress.getProgress() >= this.operationLength) {
                this.componentProgress.cancellationProgress();
                this.operateWithMax(this.updateTick.getRecipeOutput());
                if (this.action != null && this.action.needAction(TypeLoad.AFTER_PROGRESS)) {
                    this.action.doAction();
                }
                if (this.hasAudio && this.audoFix) {
                    ((IAudioFixer)((Object)this.getParent())).initiate(2);
                }
            }
        } else {
            if (this.heatComponent != null && this.updateTick.getRecipeOutput() == null) {
                this.heatComponent.need = false;
            }
            if (this.componentProgress == null) {
                this.heatComponent = this.getParent().getComp(HeatComponent.class);
                this.componentProgress = (ComponentProgress)this.getParent().getComp("com.denfop.componets.ComponentProgress");
                this.advEnergy = this.getParent().getComp(ComponentSteamEnergy.class);
                this.pressureComponent = this.getParent().getComp(PressureComponent.class);
                this.audoFix = this.getParent() instanceof IAudioFixer;
            }
            if (this.componentProgress.getProgress() != 0 && this.getParent().getActive() && this.hasAudio && this.audoFix) {
                ((IAudioFixer)((Object)this.getParent())).initiate(1);
            }
            if (this.updateTick.getRecipeOutput() == null) {
                this.componentProgress.cancellationProgress();
            }
            if (this.getParent().getActive()) {
                this.getParent().setActive(false);
            }
        }
        if (this.action != null && this.action.needAction(TypeLoad.ALWAYS)) {
            this.action.doAction();
        }
        if (this.parent.getActive() && this.parent.func_145831_w().func_72820_D() % 20L == 0L) {
            if (this.timer != null && this.timer.canWork()) {
                this.timer.work();
                if (!this.timer.canWork()) {
                    this.timer1 = new Timer(0, 0, 10);
                }
            }
            if (this.timer1.canWork()) {
                this.timer1.work();
            }
        }
    }

    public void consumeEnergy() {
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.invSlotRecipes.consume();
        this.outputSlot.add(processResult);
    }

    public void operateWithMax(MachineRecipe output) {
        if (output.getRecipe() == null) {
            return;
        }
        int size = 64;
        List<Integer> list = this.updateTick.getRecipeOutput().getList();
        if (this.invSlotRecipes.getRecipe().workbench()) {
            size = 1;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                size = Math.min(size, this.invSlotRecipes.get(i).func_190916_E() / list.get(i));
            }
        }
        int maxSize = size;
        int count = this.outputSlot.get().func_190926_b() ? output.getRecipe().output.items.get(0).func_77976_d() : this.outputSlot.get().func_77976_d() - this.outputSlot.get().func_190916_E();
        ItemStack outputStack = this.updateTick.getRecipeOutput().getRecipe().output.items.get(0);
        size = Math.min(size, count /= Math.max(outputStack.func_190916_E(), 1));
        size = Math.min(size, this.updateTick.getRecipeOutput().getRecipe().output.items.get(0).func_77973_b().func_77639_j());
        if (this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null) {
            int size1 = this.invSlotRecipes.getTank().getFluidAmount() / this.updateTick.getRecipeOutput().getRecipe().input.getFluid().amount;
            size = Math.min(size, size1);
        }
        size = Math.min(size, this.operationsPerTick);
        this.invSlotRecipes.consume(size, output);
        this.outputSlot.add(output.getRecipe().getOutput().items, size);
        if (maxSize == size) {
            this.updateTick.setRecipeOutput(null);
        }
    }

    public void operate(MachineRecipe output) {
        if (output.getRecipe() == null) {
            return;
        }
        for (int i = 0; i < this.operationsPerTick; ++i) {
            List<ItemStack> processResult = output.getRecipe().output.items;
            this.operateOnce(processResult);
            if (!this.invSlotRecipes.continue_process(this.updateTick.getRecipeOutput()) || !this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.getOutput();
                break;
            }
            if (this.updateTick.getRecipeOutput() == null) break;
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }
}

