/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.ICoolSink;
import com.denfop.api.cool.ICoolSource;
import com.denfop.api.cool.ICoolTile;
import com.denfop.api.cool.event.CoolTileLoadEvent;
import com.denfop.api.cool.event.CoolTileUnloadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

public class CoolComponent
extends AbstractComponent {
    public final World world;
    public final boolean fullEnergy;
    public double capacity;
    public double storage;
    public int sinkTier;
    public int sourceTier;
    public Set<EnumFacing> sinkDirections;
    public Set<EnumFacing> sourceDirections;
    public List<InvSlot> managedSlots;
    public boolean multiSource = false;
    public int sourcePackets = 1;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public boolean upgrade = false;
    public int meta = 0;
    public boolean allow = false;
    Map<EnumFacing, ICoolTile> energyCoolConductorMap = new HashMap<EnumFacing, ICoolTile>();
    List<InfoTile<ICoolTile>> validColdReceivers = new LinkedList<InfoTile<ICoolTile>>();
    private double coef;

    public CoolComponent(TileEntityInventory parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public CoolComponent(TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int tier) {
        this(parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public CoolComponent(TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.capacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.fullEnergy = fullEnergy;
        this.world = parent.func_145831_w();
        this.coef = 1.0;
    }

    public static CoolComponent asBasicSink(TileEntityInventory parent, double capacity) {
        return CoolComponent.asBasicSink(parent, capacity, 1);
    }

    public static CoolComponent asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new CoolComponent(parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static CoolComponent asBasicSource(TileEntityInventory parent, double capacity) {
        return CoolComponent.asBasicSource(parent, capacity, 1);
    }

    public static CoolComponent asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new CoolComponent(parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        this.storage = nbt.func_74769_h("storage");
        this.upgrade = nbt.func_74767_n("upgrade");
        this.meta = nbt.func_74762_e("meta");
        this.allow = nbt.func_74767_n("allow");
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74780_a("storage", this.storage);
        ret.func_74757_a("upgrade", this.upgrade);
        ret.func_74768_a("meta", this.meta);
        ret.func_74757_a("allow", this.allow);
        return ret;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.storage > this.capacity) {
            this.storage = this.capacity;
        }
        if (!this.parent.func_145831_w().field_72995_K) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                this.energyCoolConductorMap.clear();
                this.validColdReceivers.clear();
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this.delegate, this.parent.func_145831_w()));
            }
            this.loaded = true;
            switch (this.parent.func_145831_w().field_73011_w.getBiomeForCoords(this.parent.func_174877_v()).func_150561_m()) {
                case COLD: {
                    this.coef = 0.5;
                    break;
                }
                case WARM: {
                    this.coef = 1.5;
                    break;
                }
                default: {
                    this.coef = 1.0;
                }
            }
        }
    }

    public void createDelegate() {
        if (this.delegate == null) {
            assert (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty());
            this.delegate = this.sinkDirections.isEmpty() ? new EnergyNetDelegateSource() : new EnergyNetDelegateSink();
            this.delegate.func_145834_a(this.parent.func_145831_w());
            this.delegate.func_174878_a(this.parent.func_174877_v());
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this.delegate, this.parent.func_145831_w()));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeInt(this.meta);
        buffer.writeBoolean(this.upgrade);
        buffer.writeBoolean(this.allow);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
        this.meta = is.readInt();
        this.upgrade = is.readBoolean();
        this.allow = is.readBoolean();
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packet = super.updateComponent();
        packet.writeDouble(this.capacity);
        packet.writeDouble(this.storage);
        packet.writeInt(this.meta);
        packet.writeBoolean(this.upgrade);
        packet.writeBoolean(this.allow);
        return packet;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        if (this.storage > this.capacity) {
            this.storage = this.capacity;
        }
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFillRatio() {
        return this.storage / this.capacity;
    }

    public double addEnergy(double amount) {
        this.storage += amount * this.coef;
        this.storage = Math.min(this.storage, this.capacity);
        this.storage = Math.max(this.storage, 0.0);
        if (this.upgrade) {
            this.storage = 0.0;
        }
        return amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount / this.coef) {
            this.storage -= amount / this.coef;
            if (this.storage <= 0.005) {
                this.storage = 0.0;
            }
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        if (this.storage <= 0.0) {
            this.storage = 0.0;
            return amount;
        }
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount) / this.coef;
        if (!simulate) {
            this.storage -= ret / this.coef;
            if (this.storage <= 0.005) {
                this.storage = 0.0;
            }
        }
        return ret;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.sourceTier = tier;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public void setDirections(Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this.delegate, this.world));
        }
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this.delegate, this.world));
        }
    }

    public Set<EnumFacing> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<EnumFacing> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public ICoolTile getDelegate() {
        return this.delegate;
    }

    private double getSourceEnergy() {
        return this.storage;
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements ICoolSource {
        int hashCodeSource;
        private long id;

        private EnergyNetDelegateSource() {
        }

        public int getSourceTier() {
            return CoolComponent.this.sourceTier;
        }

        @Override
        public boolean emitsCoolTo(ICoolAcceptor receiver, EnumFacing dir) {
            return CoolComponent.this.sourceDirections.contains(dir);
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return CoolComponent.this.parent.func_174877_v();
        }

        @Override
        public long getIdNetwork() {
            return this.id;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        @Override
        public void AddCoolTile(ICoolTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                CoolComponent.this.energyCoolConductorMap.put(dir, tile);
                CoolComponent.this.validColdReceivers.add(new InfoTile<ICoolTile>(tile, dir.func_176734_d()));
            }
        }

        @Override
        public void RemoveCoolTile(ICoolTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                CoolComponent.this.energyCoolConductorMap.remove(dir);
                Iterator<InfoTile<ICoolTile>> iter = CoolComponent.this.validColdReceivers.iterator();
                while (iter.hasNext()) {
                    InfoTile<ICoolTile> tileInfoTile = iter.next();
                    if (tileInfoTile.tileEntity != tile) continue;
                    iter.remove();
                    break;
                }
            }
        }

        @Override
        public Map<EnumFacing, ICoolTile> getCoolTiles() {
            return CoolComponent.this.energyCoolConductorMap;
        }

        @Override
        public List<InfoTile<ICoolTile>> getCoolValidReceivers() {
            return CoolComponent.this.validColdReceivers;
        }

        @Override
        public double getOfferedCool() {
            assert (!CoolComponent.this.sourceDirections.isEmpty());
            return !CoolComponent.this.sendingSidabled ? CoolComponent.this.getSourceEnergy() : 0.0;
        }

        @Override
        public boolean isAllowed() {
            return CoolComponent.this.allow;
        }

        @Override
        public void setAllowed(boolean allowed) {
            CoolComponent.this.allow = allowed;
        }

        @Override
        public TileEntity getTile() {
            return CoolComponent.this.parent;
        }
    }

    private class EnergyNetDelegateSink
    extends EnergyNetDelegate
    implements ICoolSink {
        int hashCodeSource;
        List<ICoolSource> list;
        private long id;

        private EnergyNetDelegateSink() {
            this.list = new LinkedList<ICoolSource>();
        }

        public int getSinkTier() {
            return CoolComponent.this.sinkTier;
        }

        @Override
        public boolean acceptsCoolFrom(ICoolEmitter emitter, EnumFacing dir) {
            return CoolComponent.this.sinkDirections.contains(dir);
        }

        @Override
        public long getIdNetwork() {
            return this.id;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        @Override
        public void AddCoolTile(ICoolTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                CoolComponent.this.energyCoolConductorMap.put(dir, tile);
                CoolComponent.this.validColdReceivers.add(new InfoTile<ICoolTile>(tile, dir.func_176734_d()));
            }
        }

        @Override
        public void RemoveCoolTile(ICoolTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                CoolComponent.this.energyCoolConductorMap.remove(dir);
                Iterator<InfoTile<ICoolTile>> iter = CoolComponent.this.validColdReceivers.iterator();
                while (iter.hasNext()) {
                    InfoTile<ICoolTile> tileInfoTile = iter.next();
                    if (tileInfoTile.tileEntity != tile) continue;
                    iter.remove();
                    break;
                }
            }
        }

        @Override
        public Map<EnumFacing, ICoolTile> getCoolTiles() {
            return CoolComponent.this.energyCoolConductorMap;
        }

        @Override
        public List<InfoTile<ICoolTile>> getCoolValidReceivers() {
            return CoolComponent.this.validColdReceivers;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return CoolComponent.this.parent.func_174877_v();
        }

        @Override
        public double getDemandedCool() {
            if (CoolComponent.this.storage != 0.0) {
                return 64.0;
            }
            return 0.0;
        }

        @Override
        public void receivedCold(double amount) {
            if (amount > 0.0) {
                CoolComponent.this.useEnergy(0.05 * amount / 4.0, false);
            }
        }

        @Override
        public boolean needCooling() {
            return CoolComponent.this.storage > 0.0;
        }

        @Override
        public List<ICoolSource> getEnergyTickList() {
            return this.list;
        }

        @Override
        public TileEntity getTile() {
            return CoolComponent.this.parent;
        }
    }

    private static abstract class EnergyNetDelegate
    extends TileEntity
    implements ICoolTile {
        private EnergyNetDelegate() {
        }
    }
}

