/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IDual;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.IMultiDual;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotCharge;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

public class Energy
extends AbstractComponent {
    public final boolean fullEnergy;
    public final double defaultCapacity;
    public double tick;
    public boolean upgrade;
    public double capacity;
    public double storage;
    public int sinkTier;
    public int sourceTier;
    public int defaultSinkTier;
    public int defaultSourceTier;
    public Set<EnumFacing> sinkDirections;
    public Set<EnumFacing> sourceDirections;
    public List<InvSlot> managedSlots = new ArrayList<InvSlot>();
    public boolean multiSource = false;
    public int sourcePackets = 1;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public boolean limit;
    public double limit_amount = 0.0;
    protected double pastEnergy;
    protected double perenergy;
    protected double pastEnergy1;
    protected double perenergy1;
    Map<BlockPos, IEnergyStorage> energyStorageMap = new HashMap<BlockPos, IEnergyStorage>();
    Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    private ChunkPos chunkPos;
    private long id;

    public Energy(TileEntityInventory parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public Energy(TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int tier) {
        this(parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public Energy(TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.capacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections == null ? Collections.emptySet() : sinkDirections;
        this.sourceDirections = sourceDirections == null ? Collections.emptySet() : sourceDirections;
        this.fullEnergy = fullEnergy;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
        this.defaultSinkTier = sinkTier;
        this.defaultSourceTier = sourceTier;
        this.defaultCapacity = capacity;
    }

    public Energy(TileEntityInventory parent, double capacity, List<EnumFacing> sinkDirections, List<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.capacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections == null ? Collections.emptySet() : new HashSet<EnumFacing>(sinkDirections);
        this.sourceDirections = sourceDirections == null ? Collections.emptySet() : new HashSet<EnumFacing>(sourceDirections);
        this.fullEnergy = fullEnergy;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
        this.defaultSinkTier = sinkTier;
        this.defaultSourceTier = sourceTier;
        this.defaultCapacity = capacity;
    }

    public static Energy asBasicSink(TileEntityInventory parent, double capacity) {
        return Energy.asBasicSink(parent, capacity, 1);
    }

    public static Energy asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new Energy(parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static Energy asBasicSink(TileEntityInventory parent, double capacity, boolean meta) {
        return new Energy(parent, capacity, ModUtils.allFacings, Collections.emptySet(), 14, 14, false);
    }

    public static Energy asBasicSource(TileEntityInventory parent, double capacity) {
        return Energy.asBasicSource(parent, capacity, 1);
    }

    public static Energy asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new Energy(parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public void onNeighborChange(Block srcBlock, BlockPos srcPos) {
    }

    @Override
    public void updateEntityServer() {
        if (!this.managedSlots.isEmpty()) {
            for (InvSlot slot : this.managedSlots) {
                InvSlotCharge charge;
                double energy;
                if (slot instanceof InvSlotDischarge) {
                    InvSlotDischarge discharge = (InvSlotDischarge)slot;
                    if (discharge.isEmpty()) continue;
                    if (discharge.get().func_77973_b() == Items.field_151137_ax) {
                        energy = discharge.dischargeWithRedstone(this.capacity, this.getFreeEnergy());
                        this.addEnergy(energy);
                        continue;
                    }
                    energy = discharge.discharge(this.getFreeEnergy(), false);
                    this.addEnergy(energy);
                    continue;
                }
                if (!(slot instanceof InvSlotCharge) || (charge = (InvSlotCharge)slot).isEmpty()) continue;
                energy = charge.charge(this.storage);
                this.useEnergy(energy);
            }
        }
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.getParent().func_174877_v().func_177958_n() >> 4, this.getParent().func_174877_v().func_177952_p() >> 4);
        }
        return this.chunkPos;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public Energy addManagedSlot(InvSlot slot) {
        if (this.managedSlots == null) {
            this.managedSlots = new ArrayList<InvSlot>(4);
        }
        this.managedSlots.add(slot);
        return this;
    }

    public Map<EnumFacing, IEnergyTile> getConductors() {
        return this.energyConductorMap;
    }

    public void RemoveTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    public void AddTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.func_176734_d()));
        }
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        this.storage = nbt.func_74769_h("storage");
        this.limit_amount = nbt.func_74769_h("limit_amount");
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74780_a("storage", this.storage);
        ret.func_74780_a("limit_amount", this.limit_amount);
        return ret;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (!this.parent.func_145831_w().field_72995_K) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                this.energyConductorMap.clear();
                this.validReceivers.clear();
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.func_145831_w(), this.delegate));
            }
            this.loaded = true;
        }
    }

    public int getComparatorValue() {
        return Math.min((int)(this.storage * 15.0 / this.capacity), 15);
    }

    public void setLimit(boolean limit) {
        this.limit = limit;
    }

    public void createDelegate() {
        if (this.delegate == null) {
            this.delegate = !this.multiSource ? (this.sinkDirections.isEmpty() ? new EnergyNetDelegateSource() : (this.sourceDirections.isEmpty() ? new EnergyNetDelegateSink() : new EnergyNetDelegateDual())) : new EnergyNetDelegateMultiDual();
            this.delegate.func_145834_a(this.parent.func_145831_w());
            this.delegate.func_174878_a(this.parent.func_174877_v());
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.func_145831_w(), this.delegate));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeDouble(this.limit_amount);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeDouble(this.limit_amount);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
        this.limit_amount = is.readDouble();
    }

    public double getDefaultCapacity() {
        return this.defaultCapacity;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        this.storage = Math.min(this.capacity, this.storage);
    }

    public void addCapacity(double capacity) {
        this.capacity += capacity;
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFreeEnergy() {
        return Math.max(0.0, this.capacity - this.storage);
    }

    public double getFillRatio() {
        if (this.storage > this.capacity) {
            this.storage = this.capacity;
        }
        return this.storage / this.capacity;
    }

    public double addEnergy(double amount) {
        amount = Math.min(this.capacity - this.storage, amount);
        this.storage += amount;
        this.storage = Math.min(this.storage, this.capacity);
        return amount;
    }

    public void forceAddEnergy(double amount) {
        this.storage += amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount) {
            this.storage -= amount;
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount);
        if (!simulate) {
            this.storage -= ret;
        }
        return ret;
    }

    @Override
    public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
        InvSlot discharge;
        int tier;
        if (this.getDelegate() instanceof IEnergySink) {
            tier = invSlotUpgrade.getTier(this.defaultSinkTier);
            this.setSinkTier(tier);
            for (InvSlot slot : this.managedSlots) {
                if (!(slot instanceof InvSlotDischarge)) continue;
                discharge = (InvSlotDischarge)slot;
                ((InvSlotDischarge)discharge).setTier(tier);
            }
        }
        if (this.getDelegate() instanceof IEnergySource) {
            tier = invSlotUpgrade.getTier(this.defaultSourceTier);
            this.setSourceTier(tier);
            for (InvSlot slot : this.managedSlots) {
                if (!(slot instanceof InvSlotCharge)) continue;
                discharge = (InvSlotCharge)slot;
                ((InvSlotCharge)discharge).setTier(tier);
            }
        }
        this.setCapacity(invSlotUpgrade.getEnergyStorage(this.defaultCapacity));
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
        for (InvSlot slot : this.managedSlots) {
            if (!(slot instanceof InvSlotDischarge)) continue;
            InvSlotDischarge discharge = (InvSlotDischarge)slot;
            discharge.setTier(tier);
        }
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        for (InvSlot slot : this.managedSlots) {
            if (!(slot instanceof InvSlotCharge)) continue;
            InvSlotCharge discharge = (InvSlotCharge)slot;
            discharge.setTier(tier);
        }
        this.sourceTier = tier;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public Energy setMultiSource(boolean multiSource) {
        this.multiSource = multiSource;
        if (!multiSource) {
            this.sourcePackets = 1;
        }
        return this;
    }

    public void setPacketOutput(int number) {
        if (this.multiSource) {
            this.sourcePackets = number;
        }
    }

    public void setDirections(Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.func_145831_w(), this.delegate));
        }
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.func_145831_w(), this.delegate));
        }
    }

    public long getIdNetwork() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setDirections(List<EnumFacing> sinkDirections, List<EnumFacing> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.func_145831_w(), this.delegate));
        }
        this.sinkDirections = new HashSet<EnumFacing>(sinkDirections);
        this.sourceDirections = new HashSet<EnumFacing>(sourceDirections);
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            this.createDelegate();
        }
        if (this.delegate != null) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            assert (!this.parent.func_145831_w().field_72995_K);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.func_145831_w(), this.delegate));
        }
    }

    public Set<EnumFacing> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<EnumFacing> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public IEnergyTile getDelegate() {
        return this.delegate;
    }

    private double getSourceEnergy() {
        if (!this.limit) {
            return Math.min(this.storage, EnergyNetGlobal.instance.getPowerFromTier(this.sourceTier));
        }
        return Math.min(this.storage, this.limit_amount);
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements IEnergySource {
        int hashCodeSource;
        boolean hasHashCode;
        private int hashCode;

        private EnergyNetDelegateSource() {
            this.hasHashCode = false;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public List<InfoTile<IEnergyTile>> getValidReceivers() {
            return Energy.this.validReceivers;
        }

        @Override
        public void AddTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.AddTile(tile, dir);
        }

        @Override
        public void RemoveTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.RemoveTile(tile, dir);
        }

        @Override
        public Map<EnumFacing, IEnergyTile> getTiles() {
            return Energy.this.energyConductorMap;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return Energy.this.parent.func_174877_v();
        }

        @Override
        public int getSourceTier() {
            return Energy.this.sourceTier;
        }

        @Override
        public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing dir) {
            for (EnumFacing facing1 : Energy.this.sourceDirections) {
                if (facing1.ordinal() != dir.ordinal()) continue;
                return true;
            }
            return false;
        }

        @Override
        public long getIdNetwork() {
            return Energy.this.getIdNetwork();
        }

        @Override
        public void setId(long id) {
            Energy.this.setId(id);
        }

        @Override
        public double canExtractEnergy() {
            return !Energy.this.sendingSidabled ? Energy.this.getSourceEnergy() : 0.0;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= Energy.this.storage);
            Energy.this.storage -= amount;
        }

        @Override
        public double getPerEnergy() {
            return Energy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return Energy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            Energy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            Energy.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return true;
        }

        @Override
        public TileEntity getTileEntity() {
            return this;
        }
    }

    private class EnergyNetDelegateSink
    extends EnergyNetDelegate
    implements IEnergySink {
        boolean hasHashCode;
        int hashCodeSource;
        List<Integer> energyTicks;
        private int hashCode;

        private EnergyNetDelegateSink() {
            this.hasHashCode = false;
            this.energyTicks = new LinkedList<Integer>();
        }

        @Override
        public int getSinkTier() {
            return Energy.this.sinkTier;
        }

        @Override
        public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing dir) {
            for (EnumFacing facing1 : Energy.this.sinkDirections) {
                if (facing1.ordinal() != dir.ordinal()) continue;
                return true;
            }
            return false;
        }

        @Override
        public long getIdNetwork() {
            return Energy.this.getIdNetwork();
        }

        @Override
        public void setId(long id) {
            Energy.this.setId(id);
        }

        @Override
        public List<InfoTile<IEnergyTile>> getValidReceivers() {
            return Energy.this.validReceivers;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void AddTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.AddTile(tile, dir);
        }

        @Override
        public void RemoveTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.RemoveTile(tile, dir);
        }

        @Override
        public Map<EnumFacing, IEnergyTile> getTiles() {
            return Energy.this.energyConductorMap;
        }

        @Override
        public double getDemandedEnergy() {
            return !Energy.this.receivingDisabled ? Energy.this.capacity - Energy.this.storage : 0.0;
        }

        @Override
        public void receiveEnergy(double amount) {
            Energy.this.storage += amount;
        }

        @Override
        public List<Integer> getEnergyTickList() {
            return this.energyTicks;
        }

        @Override
        public double getPerEnergy() {
            return Energy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return Energy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            Energy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            Energy.this.perenergy += setEnergy;
        }

        @Override
        public void addTick(double tick) {
            Energy.this.tick = tick;
        }

        @Override
        public double getTick() {
            return Energy.this.tick;
        }

        @Override
        public boolean isSink() {
            return true;
        }

        @Override
        public TileEntity getTileEntity() {
            return Energy.this.parent;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return Energy.this.parent.func_174877_v();
        }
    }

    private class EnergyNetDelegateMultiDual
    extends EnergyNetDelegate
    implements IMultiDual {
        int hashCodeSource;
        boolean hasHashCode;
        List<Integer> energyTicks;
        private int hashCode;

        private EnergyNetDelegateMultiDual() {
            this.hasHashCode = false;
            this.energyTicks = new ArrayList<Integer>();
        }

        @Override
        public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing dir) {
            for (EnumFacing facing1 : Energy.this.sinkDirections) {
                if (facing1.ordinal() != dir.ordinal()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public long getIdNetwork() {
            return Energy.this.getIdNetwork();
        }

        @Override
        public void setId(long id) {
            Energy.this.setId(id);
        }

        @Override
        public List<InfoTile<IEnergyTile>> getValidReceivers() {
            return Energy.this.validReceivers;
        }

        @Override
        public void AddTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.AddTile(tile, dir);
        }

        @Override
        public void RemoveTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.RemoveTile(tile, dir);
        }

        @Override
        public Map<EnumFacing, IEnergyTile> getTiles() {
            return Energy.this.energyConductorMap;
        }

        @Override
        public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing dir) {
            for (EnumFacing facing1 : Energy.this.sourceDirections) {
                if (facing1.ordinal() != dir.ordinal()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return Energy.this.parent.func_174877_v();
        }

        @Override
        public TileEntity getTileEntity() {
            return Energy.this.parent;
        }

        @Override
        public double getDemandedEnergy() {
            return !Energy.this.receivingDisabled && Energy.this.storage < Energy.this.capacity ? Energy.this.capacity - Energy.this.storage : 0.0;
        }

        @Override
        public double canExtractEnergy() {
            return !Energy.this.sendingSidabled ? Energy.this.getSourceEnergy() : 0.0;
        }

        @Override
        public int getSinkTier() {
            return Energy.this.sinkTier;
        }

        @Override
        public int getSourceTier() {
            return Energy.this.sourceTier;
        }

        @Override
        public void receiveEnergy(double amount) {
            Energy.this.storage += amount;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= Energy.this.storage);
            Energy.this.storage -= amount;
        }

        @Override
        public List<Integer> getEnergyTickList() {
            return this.energyTicks;
        }

        @Override
        public double getPerEnergy() {
            return Energy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return Energy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            Energy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            Energy.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return !Energy.this.sendingSidabled;
        }

        @Override
        public void addTick(double tick) {
            Energy.this.tick = tick;
        }

        @Override
        public double getTick() {
            return Energy.this.tick;
        }

        @Override
        public boolean isSink() {
            return !Energy.this.receivingDisabled;
        }

        @Override
        public double getPerEnergy1() {
            return Energy.this.perenergy1;
        }

        @Override
        public double getPastEnergy1() {
            return Energy.this.pastEnergy1;
        }

        @Override
        public void setPastEnergy1(double pastEnergy) {
            Energy.this.pastEnergy1 = pastEnergy;
        }

        @Override
        public void addPerEnergy1(double setEnergy) {
            Energy.this.perenergy1 += setEnergy;
        }
    }

    private class EnergyNetDelegateDual
    extends EnergyNetDelegate
    implements IDual {
        int hashCodeSource;
        boolean hasHashCode;
        List<Integer> energyTicks;
        private int hashCode;

        private EnergyNetDelegateDual() {
            this.hasHashCode = false;
            this.energyTicks = new LinkedList<Integer>();
        }

        @Override
        public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing dir) {
            for (EnumFacing facing1 : Energy.this.sinkDirections) {
                if (facing1.ordinal() != dir.ordinal()) continue;
                return true;
            }
            return false;
        }

        @Override
        public long getIdNetwork() {
            return Energy.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            Energy.this.setId(id);
        }

        @Override
        public List<InfoTile<IEnergyTile>> getValidReceivers() {
            return Energy.this.validReceivers;
        }

        @Override
        public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing dir) {
            for (EnumFacing facing1 : Energy.this.sourceDirections) {
                if (facing1.ordinal() != dir.ordinal()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return Energy.this.parent.func_174877_v();
        }

        @Override
        public void AddTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.AddTile(tile, dir);
        }

        @Override
        public void RemoveTile(IEnergyTile tile, EnumFacing dir) {
            Energy.this.RemoveTile(tile, dir);
        }

        @Override
        public Map<EnumFacing, IEnergyTile> getTiles() {
            return Energy.this.energyConductorMap;
        }

        @Override
        public TileEntity getTileEntity() {
            return Energy.this.parent;
        }

        @Override
        public double getDemandedEnergy() {
            return !Energy.this.receivingDisabled && Energy.this.storage < Energy.this.capacity ? Energy.this.capacity - Energy.this.storage : 0.0;
        }

        @Override
        public double canExtractEnergy() {
            return !Energy.this.sendingSidabled ? Energy.this.getSourceEnergy() : 0.0;
        }

        @Override
        public int getSinkTier() {
            return Energy.this.sinkTier;
        }

        @Override
        public int getSourceTier() {
            return Energy.this.sourceTier;
        }

        @Override
        public void receiveEnergy(double amount) {
            Energy.this.storage += amount;
        }

        @Override
        public List<Integer> getEnergyTickList() {
            return this.energyTicks;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= Energy.this.storage);
            Energy.this.storage -= amount;
        }

        @Override
        public double getPerEnergy() {
            return Energy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return Energy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            Energy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            Energy.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return !Energy.this.sendingSidabled;
        }

        @Override
        public void addTick(double tick) {
            Energy.this.tick = tick;
        }

        @Override
        public double getTick() {
            return Energy.this.tick;
        }

        @Override
        public boolean isSink() {
            return !Energy.this.receivingDisabled;
        }

        @Override
        public double getPerEnergy1() {
            return Energy.this.perenergy1;
        }

        @Override
        public double getPastEnergy1() {
            return Energy.this.pastEnergy1;
        }

        @Override
        public void setPastEnergy1(double pastEnergy) {
            Energy.this.pastEnergy1 = pastEnergy;
        }

        @Override
        public void addPerEnergy1(double setEnergy) {
            Energy.this.perenergy1 += setEnergy;
        }
    }

    private static abstract class EnergyNetDelegate
    extends TileEntity
    implements IEnergyTile {
        private EnergyNetDelegate() {
        }
    }
}

