/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatSink;
import com.denfop.api.heat.IHeatSource;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

public class HeatComponent
extends AbstractComponent {
    public final World world;
    public final boolean fullEnergy;
    private final double defaultCapacity;
    public double capacity;
    public double storage;
    public int sinkTier;
    public int sourceTier;
    public Set<EnumFacing> sinkDirections;
    public Set<EnumFacing> sourceDirections;
    public List<InvSlot> managedSlots;
    public boolean multiSource = false;
    public int sourcePackets = 1;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public boolean need;
    public boolean auto;
    public boolean allow;
    Random rand = new Random();
    Map<EnumFacing, IHeatTile> energyHeatConductorMap = new HashMap<EnumFacing, IHeatTile>();
    List<InfoTile<IHeatTile>> validHeatReceivers = new LinkedList<InfoTile<IHeatTile>>();
    private double coef;

    public HeatComponent(TileEntityInventory parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public HeatComponent(TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int tier) {
        this(parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public HeatComponent(TileEntityInventory parent, double capacity, Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.capacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.fullEnergy = fullEnergy;
        this.world = parent.func_145831_w();
        this.defaultCapacity = capacity;
        this.need = true;
        this.allow = false;
        this.coef = 0.0;
    }

    public static HeatComponent asBasicSink(TileEntityInventory parent, double capacity) {
        return HeatComponent.asBasicSink(parent, capacity, 1);
    }

    public static HeatComponent asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new HeatComponent(parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static HeatComponent asBasicSource(TileEntityInventory parent, double capacity) {
        return HeatComponent.asBasicSource(parent, capacity, 1);
    }

    public static HeatComponent asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new HeatComponent(parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.reactor_info.heat") + " " + (int)this.storage + "/" + (int)this.capacity);
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        this.storage = nbt.func_74769_h("storage");
        this.capacity = nbt.func_74769_h("capacity");
        this.need = nbt.func_74767_n("need");
        this.allow = nbt.func_74767_n("allow");
        this.auto = nbt.func_74767_n("auto");
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packet = super.updateComponent();
        packet.writeDouble(this.capacity);
        packet.writeDouble(this.storage);
        packet.writeBoolean(this.need);
        packet.writeBoolean(this.allow);
        packet.writeBoolean(this.auto);
        return packet;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74780_a("storage", this.storage);
        ret.func_74780_a("capacity", this.capacity);
        ret.func_74757_a("need", this.need);
        ret.func_74757_a("allow", this.allow);
        ret.func_74757_a("auto", this.auto);
        return ret;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.capacity < this.defaultCapacity) {
            this.capacity = this.defaultCapacity;
        }
        if (!this.parent.func_145831_w().field_72995_K) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                this.validHeatReceivers.clear();
                this.energyHeatConductorMap.clear();
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this.delegate, this.parent.func_145831_w()));
            }
            this.loaded = true;
            switch (this.parent.func_145831_w().field_73011_w.getBiomeForCoords(this.parent.func_174877_v()).func_150561_m()) {
                case COLD: {
                    this.coef = -1.0;
                    break;
                }
                case WARM: {
                    this.coef = 1.0;
                    break;
                }
                default: {
                    this.coef = 0.0;
                }
            }
        }
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(EntityPlayer player) {
        return this.auto;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        this.auto = false;
        return new ItemStack((Item)IUItem.autoheater);
    }

    public void createDelegate() {
        if (this.delegate == null) {
            assert (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty());
            if (this.sinkDirections.isEmpty()) {
                this.delegate = new EnergyNetDelegateSource();
            } else if (this.sourceDirections.isEmpty()) {
                this.delegate = new EnergyNetDelegateSink();
            }
            if (this.delegate == null) {
                return;
            }
            this.delegate.func_145834_a(this.parent.func_145831_w());
            this.delegate.func_174878_a(this.parent.func_174877_v());
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.auto) {
            ret.add(new ItemStack((Item)IUItem.autoheater));
        }
        return ret;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand) {
        super.onBlockActivated(player, hand);
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b().equals(IUItem.autoheater) && !this.auto) {
            this.auto = true;
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this.delegate, this.parent.func_145831_w()));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeBoolean(this.need);
        buffer.writeBoolean(this.allow);
        buffer.writeBoolean(this.auto);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
        this.need = is.readBoolean();
        this.allow = is.readBoolean();
        this.auto = is.readBoolean();
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        if (this.storage > this.capacity) {
            this.storage = this.capacity;
        }
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFillRatio() {
        return this.storage / this.capacity;
    }

    public double addEnergy(double amount) {
        this.storage += amount;
        if (this.coef != 0.0 && this.rand.nextInt(2) == 1) {
            this.storage += 7.0 * this.coef;
        }
        this.storage = Math.min(this.storage, this.capacity);
        this.storage = Math.max(this.storage, 0.0);
        return amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount) {
            this.storage -= amount;
            if (this.rand.nextInt(2) == 1 && this.coef == -1.0) {
                this.storage -= 1.0;
            }
            if (this.storage < 0.0) {
                this.storage = 0.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.auto && this.getEnergy() + 1.0 <= this.getCapacity()) {
            this.addEnergy(2.0);
        }
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount);
        if (!simulate) {
            this.storage -= ret;
            if (this.rand.nextInt(2) == 1 && this.coef == -1.0) {
                this.storage -= 1.0;
            }
            if (this.storage < 0.0) {
                this.storage = 0.0;
            }
        }
        return ret;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.sourceTier = tier;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public void setDirections(Set<EnumFacing> sinkDirections, Set<EnumFacing> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this.delegate, this.world));
        }
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.func_145831_w().field_72995_K);
            this.validHeatReceivers.clear();
            this.energyHeatConductorMap.clear();
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this.delegate, this.world));
        }
    }

    public Set<EnumFacing> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<EnumFacing> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public IHeatTile getDelegate() {
        return this.delegate;
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements IHeatSource {
        int hashCodeSource;
        private long id;

        private EnergyNetDelegateSource() {
        }

        public int getSourceTier() {
            return HeatComponent.this.sourceTier;
        }

        @Override
        public boolean emitsHeatTo(IHeatAcceptor receiver, EnumFacing dir) {
            return HeatComponent.this.sourceDirections.contains(dir);
        }

        @Override
        public double getOfferedHeat() {
            return HeatComponent.this.storage;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return HeatComponent.this.parent.func_174877_v();
        }

        @Override
        public void drawHeat(double amount) {
        }

        @Override
        public long getIdNetwork() {
            return this.id;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        @Override
        public void AddHeatTile(IHeatTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                HeatComponent.this.energyHeatConductorMap.put(dir, tile);
                HeatComponent.this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.func_176734_d()));
            }
        }

        @Override
        public void RemoveHeatTile(IHeatTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                HeatComponent.this.energyHeatConductorMap.remove(dir);
                Iterator<InfoTile<IHeatTile>> iter = HeatComponent.this.validHeatReceivers.iterator();
                while (iter.hasNext()) {
                    InfoTile<IHeatTile> tileInfoTile = iter.next();
                    if (tileInfoTile.tileEntity != tile) continue;
                    iter.remove();
                    break;
                }
            }
        }

        @Override
        public Map<EnumFacing, IHeatTile> getHeatTiles() {
            return HeatComponent.this.energyHeatConductorMap;
        }

        @Override
        public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
            return HeatComponent.this.validHeatReceivers;
        }

        @Override
        public boolean isAllowed() {
            return HeatComponent.this.allow;
        }

        @Override
        public boolean setAllowed(boolean allowed) {
            HeatComponent.this.allow = allowed;
            return HeatComponent.this.allow;
        }

        @Override
        public TileEntity getTile() {
            return HeatComponent.this.parent;
        }
    }

    private class EnergyNetDelegateSink
    extends EnergyNetDelegate
    implements IHeatSink {
        List<IHeatSource> list;
        int hashCodeSource;
        private long id;

        private EnergyNetDelegateSink() {
            this.list = new LinkedList<IHeatSource>();
        }

        public int getSinkTier() {
            return HeatComponent.this.sinkTier;
        }

        @Override
        public boolean acceptsHeatFrom(IHeatEmitter emitter, EnumFacing dir) {
            return HeatComponent.this.sinkDirections.contains(dir);
        }

        @Override
        public List<IHeatSource> getEnergyTickList() {
            return this.list;
        }

        @Override
        @NotNull
        public BlockPos getBlockPos() {
            return HeatComponent.this.parent.func_174877_v();
        }

        @Override
        public double getDemandedHeat() {
            return HeatComponent.this.capacity;
        }

        @Override
        public long getIdNetwork() {
            return this.id;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        @Override
        public void AddHeatTile(IHeatTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                HeatComponent.this.energyHeatConductorMap.put(dir, tile);
                HeatComponent.this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.func_176734_d()));
            }
        }

        @Override
        public void RemoveHeatTile(IHeatTile tile, EnumFacing dir) {
            if (!this.func_145831_w().field_72995_K) {
                HeatComponent.this.energyHeatConductorMap.remove(dir);
                Iterator<InfoTile<IHeatTile>> iter = HeatComponent.this.validHeatReceivers.iterator();
                while (iter.hasNext()) {
                    InfoTile<IHeatTile> tileInfoTile = iter.next();
                    if (tileInfoTile.tileEntity != tile) continue;
                    iter.remove();
                    break;
                }
            }
        }

        @Override
        public Map<EnumFacing, IHeatTile> getHeatTiles() {
            return HeatComponent.this.energyHeatConductorMap;
        }

        @Override
        public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
            return HeatComponent.this.validHeatReceivers;
        }

        @Override
        public void receivedHeat(double amount) {
            this.setHeatStored(amount);
        }

        @Override
        public boolean needTemperature() {
            return HeatComponent.this.need;
        }

        public void setHeatStored(double amount) {
            if (HeatComponent.this.storage < amount) {
                HeatComponent.this.storage = amount;
            }
        }

        @Override
        public TileEntity getTile() {
            return HeatComponent.this.parent;
        }
    }

    private static abstract class EnergyNetDelegate
    extends TileEntity
    implements IHeatTile {
        private EnergyNetDelegate() {
        }
    }
}

