/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IDual;
import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergySource;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Connect;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityBlock;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class WirelessComponent
extends AbstractComponent {
    boolean hasUpdate = false;
    List<Connect> connectList = new LinkedList<Connect>();
    IEnergySource energySource;
    private boolean isDual;

    public WirelessComponent(TileEntityBlock parent) {
        super(parent);
    }

    public void setUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setEnergySource(IEnergySource energySource) {
        this.energySource = energySource;
        this.isDual = this.energySource instanceof IDual;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        this.hasUpdate = is.readBoolean();
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeBoolean(this.hasUpdate);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packetBuffer = super.updateComponent();
        packetBuffer.writeBoolean(this.hasUpdate);
        return packetBuffer;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.hasUpdate && this.energySource != null && this.energySource.isSource()) {
            if (this.energySource.canExtractEnergy() == 0.0) {
                return;
            }
            for (Connect connect : this.connectList) {
                if (this.energySource.canExtractEnergy() == 0.0) break;
                if (connect.getTile() == null) {
                    connect.setTile(EnergyNetGlobal.instance.getTile(this.getParent().func_145831_w(), connect.getPos()));
                }
                if (this.isDual && connect.isDual() || connect.getTile() == null || !(connect.getTile() instanceof IEnergySink)) continue;
                IEnergySink sink = (IEnergySink)connect.getTile();
                double demanded = sink.getDemandedEnergy();
                demanded = Math.min(demanded, this.energySource.canExtractEnergy());
                sink.receiveEnergy(demanded);
                this.energySource.extractEnergy(demanded);
            }
        }
    }

    public void addConnect(BlockPos pos) {
        this.connectList.add(new Connect(pos, this.getParent().func_145831_w()));
    }

    public void removeConnect(BlockPos pos) {
        this.connectList.removeIf(connect -> connect.getPos().equals((Object)pos));
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbtTagCompound = super.writeToNbt();
        NBTTagList nbtTagList = new NBTTagList();
        for (Connect connect : this.connectList) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("x", connect.getPos().func_177958_n());
            nbt.func_74768_a("y", connect.getPos().func_177956_o());
            nbt.func_74768_a("z", connect.getPos().func_177952_p());
            nbtTagList.func_74742_a((NBTBase)nbt);
        }
        nbtTagCompound.func_74782_a("connect", (NBTBase)nbtTagList);
        return nbtTagCompound;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        NBTTagList contentList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < contentList.func_74745_c(); ++i) {
            NBTTagCompound connectNbt = contentList.func_150305_b(i);
            Connect connect = new Connect(new BlockPos(connectNbt.func_74762_e("x"), connectNbt.func_74762_e("y"), connectNbt.func_74762_e("z")));
            this.connectList.add(connect);
        }
        if (!this.connectList.isEmpty()) {
            this.setUpdate(true);
        }
    }

    public void removeAll() {
        this.connectList.clear();
    }
}

