/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.container;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.componets.AbstractComponent;
import com.denfop.container.SlotInvSlot;
import com.denfop.container.SlotVirtual;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemStackInventory;
import com.denfop.network.packet.PacketUpdateFieldContainerItemStack;
import com.denfop.network.packet.PacketUpdateFieldContainerTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerBase<T extends IAdvInventory>
extends Container {
    public final T base;

    public ContainerBase(T base1) {
        this.base = base1;
    }

    protected static boolean isValidTargetSlot(Slot slot, ItemStack stack, boolean allowEmpty, boolean requireInputOnly) {
        if (!slot.func_75214_a(stack)) {
            return false;
        }
        if (!allowEmpty && !slot.func_75216_d()) {
            return false;
        }
        if (!requireInputOnly) {
            return true;
        }
        return slot instanceof SlotInvSlot && ((SlotInvSlot)slot).invSlot.canInput();
    }

    public SlotInvSlot findClassSlot(Class<? extends InvSlot> invSlotClass) {
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).invSlot.getClass().equals(invSlotClass)) continue;
            return (SlotInvSlot)slot;
        }
        return null;
    }

    public List<SlotInvSlot> getSlots() {
        ArrayList<SlotInvSlot> list = new ArrayList<SlotInvSlot>();
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotInvSlot)) continue;
            list.add((SlotInvSlot)slot);
        }
        return list;
    }

    public List<SlotInvSlot> findClassSlots(Class<? extends InvSlot> invSlotClass) {
        ArrayList<SlotInvSlot> list = new ArrayList<SlotInvSlot>();
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).invSlot.getClass().equals(invSlotClass)) continue;
            list.add((SlotInvSlot)slot);
        }
        return list;
    }

    protected void addPlayerInventorySlots(EntityPlayer player, int height) {
        if (player != null) {
            this.addPlayerInventorySlots(player, 178, height);
        }
    }

    protected void addPlayerInventorySlots(EntityPlayer player, int width, int height) {
        if (player != null) {
            int col;
            int xStart = (width - 162) / 2;
            for (col = 0; col < 3; ++col) {
                for (int col1 = 0; col1 < 9; ++col1) {
                    this.func_75146_a(new Slot((IInventory)player.field_71071_by, col1 + col * 9 + 9, xStart + col1 * 18, height + -82 + col * 18));
                }
            }
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col, xStart + col * 18, height + -24));
            }
        }
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int dragType, @NotNull ClickType clickType, @NotNull EntityPlayer player) {
        if (slotId < 0) {
            return super.func_184996_a(slotId, dragType, clickType, player);
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (!(slot instanceof SlotVirtual)) {
            if (slot instanceof SlotInvSlot) {
                SlotInvSlot slot1 = (SlotInvSlot)slot;
                if (!slot1.invSlot.canShift() && clickType == ClickType.QUICK_MOVE) {
                    return ItemStack.field_190927_a;
                }
            }
            return super.func_184996_a(slotId, dragType, clickType, player);
        }
        ((SlotVirtual)slot).slotClick(slotId, dragType, clickType, player);
        return ItemStack.field_190927_a;
    }

    @NotNull
    public final ItemStack func_82846_b(@NotNull EntityPlayer player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.func_75216_d()) {
            ItemStack sourceItemStack = sourceSlot.func_75211_c();
            int oldSourceItemStackSize = ModUtils.getSize(sourceItemStack);
            ItemStack resultStack = sourceSlot.field_75224_c == player.field_71071_by ? this.handlePlayerSlotShiftClick(player, sourceItemStack) : this.handleGUISlotShiftClick(player, sourceItemStack);
            if (ModUtils.isEmpty(resultStack) || ModUtils.getSize(resultStack) != oldSourceItemStackSize) {
                sourceSlot.func_75215_d(resultStack);
                sourceSlot.func_190901_a(player, sourceItemStack);
                if (!player.func_130014_f_().field_72995_K) {
                    this.func_75142_b();
                }
            }
        }
        return ModUtils.emptyStack;
    }

    protected ItemStack handlePlayerSlotShiftClick(EntityPlayer player, ItemStack sourceItemStack) {
        for (int run = 0; run < 4 && !ModUtils.isEmpty(sourceItemStack); ++run) {
            Slot targetSlot;
            Iterator iterator = this.field_75151_b.iterator();
            while (iterator.hasNext() && ((targetSlot = (Slot)iterator.next()) instanceof SlotVirtual || targetSlot.field_75224_c == player.field_71071_by || !ContainerBase.isValidTargetSlot(targetSlot, sourceItemStack, run % 2 == 1, run < 2) || !ModUtils.isEmpty(sourceItemStack = this.transfer(sourceItemStack, targetSlot)))) {
            }
        }
        return sourceItemStack;
    }

    protected ItemStack handleGUISlotShiftClick(EntityPlayer player, ItemStack sourceItemStack) {
        for (int run = 0; run < 2 && !ModUtils.isEmpty(sourceItemStack); ++run) {
            Slot targetSlot;
            ListIterator it = this.field_75151_b.listIterator(this.field_75151_b.size());
            while (it.hasPrevious() && ((targetSlot = (Slot)it.previous()) instanceof SlotVirtual || targetSlot.field_75224_c != player.field_71071_by || !ContainerBase.isValidTargetSlot(targetSlot, sourceItemStack, run == 1, false) || !ModUtils.isEmpty(sourceItemStack = this.transfer(sourceItemStack, targetSlot)))) {
            }
        }
        return sourceItemStack;
    }

    public boolean func_75145_c(@NotNull EntityPlayer entityplayer) {
        return this.base.func_70300_a(entityplayer);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.base instanceof ItemStackInventory) {
            for (IContainerListener crafter : this.field_75149_d) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                new PacketUpdateFieldContainerItemStack((ItemStackInventory)this.base, (EntityPlayerMP)crafter);
            }
        }
        if (this.base instanceof TileEntity) {
            for (IContainerListener crafter : this.field_75149_d) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                new PacketUpdateFieldContainerTile((TileEntityBlock)((Object)this.base), (EntityPlayerMP)crafter);
            }
            if (this.base instanceof TileEntityInventory) {
                for (AbstractComponent component : ((TileEntityInventory)this.base).getComponentList()) {
                    for (IContainerListener var5 : this.field_75149_d) {
                        if (!(var5 instanceof EntityPlayerMP)) continue;
                        component.onContainerUpdate((EntityPlayerMP)var5);
                    }
                }
            }
        }
    }

    protected final ItemStack transfer(ItemStack stack, Slot dst) {
        int amount = this.getTransferAmount(stack, dst);
        if (amount > 0) {
            ItemStack dstStack = dst.func_75211_c();
            if (ModUtils.isEmpty(dstStack)) {
                dst.func_75215_d(ModUtils.setSize(stack, amount));
            } else {
                dst.func_75215_d(ModUtils.incSize(dstStack, amount));
            }
            stack = ModUtils.decSize(stack, amount);
        }
        return stack;
    }

    private int getTransferAmount(ItemStack stack, Slot dst) {
        int amount = Math.min(dst.field_75224_c.func_70297_j_(), dst.func_75219_a());
        amount = Math.min(amount, stack.func_77985_e() ? stack.func_77976_d() : 1);
        ItemStack dstStack = dst.func_75211_c();
        if (!ModUtils.isEmpty(dstStack)) {
            if (!ModUtils.checkItemEqualityStrict(stack, dstStack)) {
                return 0;
            }
            amount -= ModUtils.getSize(dstStack);
        }
        amount = Math.min(amount, ModUtils.getSize(stack));
        return amount;
    }
}

