/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.container;

import com.denfop.api.inv.VirtualSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class SlotInfo
extends InvSlot
implements VirtualSlot {
    List<FluidStack> fluidStackList;
    private List<ItemStack> listBlack;
    private List<ItemStack> listWhite;
    private boolean fluid;

    public SlotInfo(TileEntityInventory multiCable, int size, boolean fluid) {
        super(multiCable, null, size);
        this.fluid = fluid;
        this.fluidStackList = new ArrayList<Object>(Collections.nCopies(this.size(), null));
        this.listBlack = new ArrayList<ItemStack>();
        this.listWhite = new ArrayList<ItemStack>();
    }

    public List<ItemStack> getListBlack() {
        return this.listBlack;
    }

    public List<ItemStack> getListWhite() {
        return this.listWhite;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        this.fluid = nbt.func_74767_n("fluid");
        if (this.fluid) {
            this.fluidStackList = new ArrayList<Object>(Collections.nCopies(this.size(), null));
            for (int i = 0; i < this.size(); ++i) {
                Block block;
                if (this.get(i).func_190926_b() || (block = Block.func_149634_a((Item)this.get(i).func_77973_b())) == Blocks.field_150350_a || !(block instanceof IFluidBlock)) continue;
                this.fluidStackList.set(i, new FluidStack(((IFluidBlock)block).getFluid(), 1));
            }
        }
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound nbt) {
        nbt = super.writeToNbt(nbt);
        nbt.func_74757_a("fluid", this.isFluid());
        return nbt;
    }

    @Override
    public List<FluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    @Override
    public void setFluidList(List<FluidStack> fluidStackList) {
        this.fluidStackList = fluidStackList;
    }

    @Override
    public boolean isFluid() {
        return this.fluid;
    }

    public void setFluid(boolean fluid) {
        this.fluid = fluid;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        return true;
    }

    @Override
    public void put(int index, ItemStack stack) {
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
        }
        this.contents.set(index, (Object)stack);
        this.listBlack.clear();
        this.listWhite.clear();
        this.listBlack = new LinkedList<ItemStack>();
        this.listWhite = new LinkedList<ItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.contents.get(i);
            if (itemStack.func_190926_b()) continue;
            if (i < 9) {
                this.listBlack.add(itemStack);
                continue;
            }
            this.listWhite.add(itemStack);
        }
        this.listBlack = new ArrayList<ItemStack>(this.listBlack);
        this.listWhite = new ArrayList<ItemStack>(this.listWhite);
        this.onChanged();
    }

    @Override
    protected void putFromNBT(int index, ItemStack content) {
        this.contents.set(index, (Object)content);
        this.listBlack.clear();
        this.listWhite.clear();
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.contents.get(i);
            if (itemStack.func_190926_b()) continue;
            if (index < 9) {
                this.listBlack.add(itemStack);
                continue;
            }
            this.listWhite.add(itemStack);
        }
    }

    @Override
    public ItemStack get(int index) {
        return (ItemStack)this.contents.get(index);
    }

    @Override
    public ItemStack get() {
        return this.get(0);
    }
}

