/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.cool;

import com.denfop.api.cool.ICoolNet;
import com.denfop.api.cool.ICoolTile;
import com.denfop.cool.CoolNetLocal;
import com.denfop.cool.EventHandler;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CoolNetGlobal
implements ICoolNet {
    private static Map<World, CoolNetLocal> worldToEnergyNetMap = new WeakHashMap<World, CoolNetLocal>();

    public static CoolNetGlobal initialize() {
        new EventHandler();
        return new CoolNetGlobal();
    }

    public static void onWorldUnload(World world) {
        CoolNetLocal local = worldToEnergyNetMap.remove(world);
        if (local != null) {
            local.onUnload();
        }
    }

    public static CoolNetLocal getForWorld(World world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new CoolNetLocal());
        }
        return worldToEnergyNetMap.get(world);
    }

    public static void onTickEnd(World world) {
        CoolNetLocal energyNet = CoolNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public ICoolTile getSubTile(World var1, BlockPos var2) {
        CoolNetLocal local = CoolNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }
}

