/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.entity;

import com.denfop.IUPotion;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityNuclearBombPrimed
extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityNuclearBombPrimed.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Random RANDOM = new Random();
    @Nullable
    private EntityLivingBase tntPlacedBy;
    private int fuse = 80;

    public EntityNuclearBombPrimed(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityNuclearBombPrimed(World worldIn, double x, double y, double z, EntityLivingBase igniter) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        float f = (float)(Math.random() * (Math.PI * 2));
        this.field_70159_w = -Math.sin(f) * (double)0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -Math.cos(f) * (double)0.02f;
        this.setFuse(80);
        this.tntPlacedBy = igniter;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)80);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            } else {
                BlockPos explosionPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                int explosionRadius = 10;
                this.createRadiationParticles(explosionPos, 10);
                this.createExplosionFlash(explosionPos, 10);
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void explode() {
        float explosionRadius = 20.0f;
        boolean causeFire = true;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, explosionRadius, causeFire);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, 1.0f);
        BlockPos explosionPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73011_w.getDimension() == 0) {
            int radiationValue = 5000;
            new PacketUpdateRadiationValue(this.field_70170_p.func_175726_f(explosionPos).func_76632_l(), radiationValue);
            this.spreadRadiation(explosionPos, radiationValue);
            this.affectNearbyPlayers(explosionPos, 30.0);
        }
    }

    private void createExplosionFlash(BlockPos center, int radius) {
        for (int i = 0; i < radius * 20; ++i) {
            double x = (double)center.func_177958_n() + RANDOM.nextDouble() * (double)radius * 2.0 - (double)radius;
            double y = (double)center.func_177956_o() + RANDOM.nextDouble() * (double)radius / 2.0;
            double z = (double)center.func_177952_p() + RANDOM.nextDouble() * (double)radius * 2.0 - (double)radius;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB_AMBIENT, x, y, z, 1.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, x, y, z, 1.0, 0.0, 0.0, new int[0]);
        }
    }

    private void createRadiationParticles(BlockPos center, int radius) {
        for (int i = 0; i < radius * 50; ++i) {
            double x = (double)center.func_177958_n() + RANDOM.nextDouble() * (double)radius * 2.0 - (double)radius;
            double y = (double)center.func_177956_o() + RANDOM.nextDouble() * (double)radius;
            double z = (double)center.func_177952_p() + RANDOM.nextDouble() * (double)radius * 2.0 - (double)radius;
            this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 1.0, 0.0, 0.0, new int[0]);
        }
    }

    private void spreadRadiation(BlockPos explosionPos, int initialRadiation) {
        int radius = 3;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos chunkCenter = explosionPos.func_177982_a(x * 16, 0, z * 16);
                int radiationLevel = (int)((double)initialRadiation / (1.0 + Math.sqrt(x * x + z * z)));
                new PacketUpdateRadiationValue(this.field_70170_p.func_175726_f(chunkCenter).func_76632_l(), radiationLevel);
            }
        }
    }

    private void affectNearbyPlayers(BlockPos explosionPos, double radius) {
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(radius));
        for (EntityPlayer player : players) {
            if (this.hasRadiationSuit(player)) continue;
            player.func_70690_d(new PotionEffect((Potion)IUPotion.radiation, 200, 0));
        }
    }

    private boolean hasRadiationSuit(EntityPlayer player) {
        return IHazmatLike.hasCompleteHazmat((EntityLivingBase)player, EnumLevelRadiation.LOW);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short)this.getFuse());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
    }

    @Nullable
    public EntityLivingBase getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }
}

