/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.Localization;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventUpdate {
    private boolean playerNotified = false;
    private int delay = 80;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        EntityPlayer player = event.player;
        if (!this.playerNotified) {
            this.playerNotified = true;
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.sendModCheckMessage(player);
        }
    }

    private void sendModCheckMessage(EntityPlayer player) {
        if (IUCore.proxy.isSimulating()) {
            String modVersion = "3.3.0.45";
            boolean hasPowerUtilities = Loader.isModLoaded((String)"powerutils");
            boolean hasSimplyQuarry = Loader.isModLoaded((String)"simplyquarries");
            boolean hasQuantumGenerators = Loader.isModLoaded((String)"quantum_generators");
            boolean hasJEI = Loader.isModLoaded((String)"jei");
            boolean hasTopAddons = Loader.isModLoaded((String)"topaddons");
            String message = TextFormatting.DARK_GRAY + "================\n" + TextFormatting.GREEN + Localization.translate("iu.mod.name") + " " + modVersion + "\n" + TextFormatting.WHITE + Localization.translate("iu.addons.installed") + "\n" + this.formatAddonStatus("Power Utilities", hasPowerUtilities) + "\n" + this.formatAddonStatus("Simply Quarry", hasSimplyQuarry) + "\n" + this.formatAddonStatus("Quantum Generators", hasQuantumGenerators) + "\n\n" + TextFormatting.YELLOW + Localization.translate("iu.addons.required") + "\n" + this.formatAddonStatus("JEI", hasJEI) + "\n" + this.formatAddonStatus("Top Addons", hasTopAddons) + "\n" + TextFormatting.DARK_GRAY + "================";
            IUCore.proxy.messagePlayer(player, message, new Object[0]);
            this.sendDiscordLink(player);
        }
    }

    private String formatAddonStatus(String addonName, boolean isInstalled) {
        return " " + addonName + ": " + (isInstalled ? TextFormatting.GREEN + "[\u2611]" : TextFormatting.RED + "[\u274c]");
    }

    private void sendDiscordLink(EntityPlayer player) {
        TextComponentString discordMessage = new TextComponentString(TextFormatting.AQUA + Localization.translate("iu.discord.question") + " " + TextFormatting.UNDERLINE + "[" + Localization.translate("iu.discord.click") + "]");
        discordMessage.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/nFHcxqVx"));
        player.func_145747_a((ITextComponent)discordMessage);
    }
}

