/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IItemSoon;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.api.space.upgrades.info.SpaceUpgradeItemInform;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.blocks.BlockIUFluid;
import com.denfop.blocks.FluidName;
import com.denfop.container.ContainerBags;
import com.denfop.container.ContainerLeadBox;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.ItemAdvJetpack;
import com.denfop.items.armour.special.EnumCapability;
import com.denfop.items.armour.special.ItemSpecialArmor;
import com.denfop.items.bags.ItemEnergyBags;
import com.denfop.items.bags.ItemLeadBox;
import com.denfop.items.block.ItemBlockIU;
import com.denfop.items.modules.EnumBaseType;
import com.denfop.items.modules.EnumModule;
import com.denfop.items.modules.ItemBaseModules;
import com.denfop.items.modules.ItemEntityModule;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.resource.ItemNuclearResource;
import com.denfop.network.WorldData;
import com.denfop.network.packet.PacketColorPickerAllLoggIn;
import com.denfop.network.packet.PacketRadiationUpdateValue;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.lightning_rod.IController;
import com.denfop.tiles.lightning_rod.TileEntityLightningRodController;
import com.denfop.tiles.mechanism.TileEntityPalletGenerator;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.utils.CapturedMobUtils;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class IUEventHandler {
    public static List<EntityItem> entityItemList = new LinkedList<EntityItem>();
    final TextFormatting[] name = new TextFormatting[]{TextFormatting.DARK_PURPLE, TextFormatting.YELLOW, TextFormatting.BLUE, TextFormatting.RED, TextFormatting.GRAY, TextFormatting.GREEN, TextFormatting.DARK_AQUA, TextFormatting.AQUA};
    final String[] mattertype = new String[]{"matter.name", "sun_matter.name", "aqua_matter.name", "nether_matter.name", "night_matter.name", "earth_matter.name", "end_matter.name", "aer_matter.name"};
    Tuple<ItemStack, BaseMachineRecipe> tupleRecipe;
    Tuple<ItemStack, BaseMachineRecipe> tupleReplicatorRecipe;
    private ItemStack dust1;
    private boolean reg;
    private ItemStack ingot1;

    public static boolean getUpgradeItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof IUpgradeItem;
    }

    @SubscribeEvent
    public void onWorldTick1(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            if (!world.func_72911_I() || world.field_72995_K || world.func_72820_D() % 20L != 0L) {
                return;
            }
            if (WorldBaseGen.random.nextInt(100) < 2) {
                for (Map.Entry<BlockPos, IController> entry : TileEntityLightningRodController.controllerMap.entrySet()) {
                    IController controller = entry.getValue();
                    if (!controller.isFull() || controller.getTimer().isCanWork()) continue;
                    BlockPos antennaPos = controller.getBlockAntennaPos();
                    EntityLightningBolt lightning = new EntityLightningBolt(world, (double)antennaPos.func_177958_n(), (double)antennaPos.func_177956_o(), (double)antennaPos.func_177952_p(), true);
                    world.func_72942_c((Entity)lightning);
                    controller.getTimer().setCanWork(true);
                    controller.getTimer().resetTime();
                    controller.getEnergy().addEnergy(500000.0);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            NBTTagCompound nbt = player.getEntityData();
            nbt.func_74780_a("radiation", 0.0);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            if (world.func_72820_D() % 20L != 0L) {
                return;
            }
            if (!this.reg) {
                this.dust1 = new ItemStack((Item)IUItem.iudust, 1, 55);
                this.reg = true;
                this.ingot1 = new ItemStack(IUItem.iuingot, 1, 13);
            }
            for (Entity entity : new ArrayList(world.field_72996_f)) {
                EntityItem entityItem;
                if (!(entity instanceof EntityItem)) continue;
                EntityItem itemEntity = (EntityItem)entity;
                if (itemEntity.field_70128_L) continue;
                ItemStack stack = itemEntity.func_92059_d();
                if (world.func_180495_p(itemEntity.func_180425_c()).func_177230_c() != Blocks.field_150355_j || (entityItem = this.checkAndTransform(world, itemEntity)) == null) continue;
                entityItemList.add(entityItem);
            }
            entityItemList.forEach(arg_0 -> ((World)world).func_72838_d(arg_0));
        }
    }

    private EntityItem checkAndTransform(World world, EntityItem entityItem) {
        List nearbyItems = world.func_72872_a(EntityItem.class, new AxisAlignedBB(entityItem.field_70165_t - 1.0, entityItem.field_70163_u - 1.0, entityItem.field_70161_v - 1.0, entityItem.field_70165_t + 1.0, entityItem.field_70163_u + 1.0, entityItem.field_70161_v + 1.0));
        int redstoneNeeded = 4;
        int poloniumNeeded = 1;
        int electrumNeeded = 1;
        LinkedList<Object> redstoneItems = new LinkedList<Object>();
        LinkedList<Object> poloniumItems = new LinkedList<Object>();
        LinkedList<Object> electrumItems = new LinkedList<Object>();
        for (Object item : nearbyItems) {
            if (((EntityItem)item).field_70128_L) continue;
            ItemStack stack = item.func_92059_d();
            if (stack.func_77973_b() == Items.field_151137_ax && redstoneNeeded > 0) {
                redstoneItems.add(item);
                redstoneNeeded -= stack.func_190916_E();
                continue;
            }
            if (stack.func_77969_a(this.dust1) && poloniumNeeded > 0) {
                poloniumItems.add(item);
                poloniumNeeded -= stack.func_190916_E();
                continue;
            }
            if (!stack.func_77969_a(this.ingot1) || electrumNeeded <= 0) continue;
            electrumItems.add(item);
            electrumNeeded -= stack.func_190916_E();
        }
        if (redstoneNeeded <= 0 && poloniumNeeded <= 0 && electrumNeeded <= 0) {
            int remainingRedstone = 4;
            for (Object item : redstoneItems) {
                ItemStack stack = item.func_92059_d();
                if (stack.func_190916_E() <= remainingRedstone) {
                    remainingRedstone -= stack.func_190916_E();
                    item.func_70106_y();
                    continue;
                }
                stack.func_190918_g(remainingRedstone);
                break;
            }
            int remainingPolonium = 1;
            for (Object item : poloniumItems) {
                ItemStack itemStack = item.func_92059_d();
                if (itemStack.func_190916_E() <= remainingPolonium) {
                    remainingPolonium -= itemStack.func_190916_E();
                    item.func_70106_y();
                    continue;
                }
                itemStack.func_190918_g(remainingPolonium);
                break;
            }
            int remainingElectrum = 1;
            for (EntityItem entityItem2 : electrumItems) {
                ItemStack stack = entityItem2.func_92059_d();
                if (stack.func_190916_E() <= remainingElectrum) {
                    remainingElectrum -= stack.func_190916_E();
                    entityItem2.func_70106_y();
                    continue;
                }
                stack.func_190918_g(remainingElectrum);
                break;
            }
            ItemStack chargedRedstone = new ItemStack((Item)IUItem.charged_redstone);
            return new EntityItem(world, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, chargedRedstone);
        }
        return null;
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150352_o) {
            if (event.getHarvester() == null || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)event.getHarvester().func_184586_b(EnumHand.MAIN_HAND)) <= 0) {
                event.getDrops().clear();
                event.getDrops().add(new ItemStack((Item)IUItem.rawMetals, Math.min(4, 1 + event.getWorld().field_73012_v.nextInt(Math.min(4, Math.max(1, event.getFortuneLevel())))), 17));
                event.setDropChance((float)(1 + event.getFortuneLevel()));
            }
        } else if (event.getState().func_177230_c() == Blocks.field_150366_p && (event.getHarvester() == null || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)event.getHarvester().func_184586_b(EnumHand.MAIN_HAND)) <= 0)) {
            event.getDrops().clear();
            event.getDrops().add(new ItemStack((Item)IUItem.rawMetals, Math.min(4, 1 + event.getWorld().field_73012_v.nextInt(Math.min(4, Math.max(1, event.getFortuneLevel())))), 18));
            event.setDropChance((float)(1 + event.getFortuneLevel()));
        }
    }

    @SubscribeEvent
    public void onCropGrowPre1(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos pos;
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos().func_177977_b());
        if (state.func_177230_c() == IUItem.humus && world.field_73012_v.nextFloat() < 0.5f) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onCropGrowPre(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos pos = event.getPos();
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkLevel pollution = PollutionManager.pollutionManager.getChunkLevelSoil(chunkPos);
        if (pollution != null && pollution.getLevelPollution().ordinal() >= 4) {
            event.setResult(Event.Result.DENY);
        } else if (pollution != null && pollution.getLevelPollution().ordinal() >= 1) {
            if (pollution.getLevelPollution().ordinal() == 1) {
                if (WorldBaseGen.random.nextInt(100) < 25) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (pollution.getLevelPollution().ordinal() == 2) {
                if (WorldBaseGen.random.nextInt(100) < 50) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (WorldBaseGen.random.nextInt(100) < 75) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void loginPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        RadiationSystem.rad_system.update(event.player);
    }

    @SubscribeEvent
    public void workCutters(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile;
        if (event.getWorld().field_72995_K) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == IUItem.cutter) {
            TileEntity tile2 = event.getWorld().func_175625_s(event.getPos());
            if (tile2 instanceof TileEntityMultiCable) {
                TileEntityMultiCable cable = (TileEntityMultiCable)tile2;
                ItemStack drop = cable.getPickBlock(event.getEntityPlayer(), null);
                if (!drop.func_190926_b()) {
                    ModUtils.dropAsEntity(event.getWorld(), event.getPos(), drop);
                }
                cable.removeConductor();
            }
        } else if (!stack.func_190926_b() && (tile = event.getWorld().func_175625_s(event.getPos())) instanceof TileEntityBlock && event.getEntityPlayer() != null && event.getEntityPlayer().func_70093_af()) {
            ((TileEntityBlock)tile).onSneakingActivated(event.getEntityPlayer(), event.getHand(), event.getFace(), (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c);
        }
    }

    @SubscribeEvent
    public void initiatePlayer(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        new PacketColorPickerAllLoggIn();
        new PacketRadiationUpdateValue(event.player, event.player.getEntityData().func_74769_h("radiation"));
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        WorldData.onWorldUnload(event.getWorld());
    }

    @SubscribeEvent
    public void bag_pickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        try {
            ItemStack stack2;
            Item bags;
            ItemStack stack;
            int i;
            InventoryPlayer inventory;
            boolean isContainerBox;
            boolean isContainerBags = !(player.field_71070_bA instanceof ContainerBags);
            boolean bl = isContainerBox = !(player.field_71070_bA instanceof ContainerLeadBox);
            if (isContainerBags) {
                inventory = player.field_71071_by;
                for (i = 0; i < inventory.field_70462_a.size(); ++i) {
                    stack = (ItemStack)inventory.field_70462_a.get(i);
                    if (!(stack.func_77973_b() instanceof ItemEnergyBags) || !UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BAGS, stack)) continue;
                    bags = (ItemEnergyBags)stack.func_77973_b();
                    stack2 = event.getItem().func_92059_d();
                    if (event.getItem().field_70128_L || stack2.func_77973_b() instanceof ItemEnergyBags || !bags.canInsert(player, stack, stack2)) continue;
                    ItemStack stack1 = stack2.func_77946_l();
                    stack1.func_190920_e(Math.min(stack1.func_190916_E(), stack1.field_77994_a));
                    bags.insert(player, stack, stack1);
                    event.getItem().func_92058_a(stack1);
                    if (stack1.func_190926_b()) {
                        event.getItem().func_70106_y();
                        event.setCanceled(true);
                    }
                    return;
                }
            }
            if (isContainerBox) {
                inventory = player.field_71071_by;
                for (i = 0; i < inventory.field_70462_a.size(); ++i) {
                    stack = (ItemStack)inventory.field_70462_a.get(i);
                    if (!(stack.func_77973_b() instanceof ItemLeadBox)) continue;
                    bags = (ItemLeadBox)stack.func_77973_b();
                    stack2 = event.getItem().func_92059_d();
                    if (event.getItem().field_70128_L || stack2.func_77973_b() instanceof ItemLeadBox || !bags.canInsert(player, stack, stack2)) continue;
                    ItemStack stack1 = stack2.func_77946_l();
                    stack1.func_190920_e(Math.min(stack1.func_190916_E(), stack1.field_77994_a));
                    bags.insert(player, stack, stack1);
                    event.getItem().func_92058_a(stack1);
                    if (stack1.func_190926_b()) {
                        event.getItem().func_70106_y();
                        event.setCanceled(true);
                    }
                    return;
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void setFly(EntityPlayer player, boolean fly, ItemStack stack) {
        player.field_71075_bZ.field_75100_b = fly;
        player.field_71075_bZ.field_75101_c = fly;
        player.getEntityData().func_74757_a("isFlyActive", fly);
        if (player.func_130014_f_().field_72995_K && !fly) {
            player.field_71075_bZ.func_75092_a(0.05f);
            player.field_70143_R = 0.0f;
        } else {
            boolean edit = player.getEntityData().func_74767_n("edit_fly");
            if (!edit) {
                int flyspeed;
                int n = flyspeed = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLYSPEED, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FLYSPEED, (ItemStack)stack).number : 0;
                if (player.func_130014_f_().field_72995_K) {
                    player.field_71075_bZ.func_75092_a((float)((double)0.1f + 0.05 * (double)flyspeed));
                }
            } else if (player.func_130014_f_().field_72995_K) {
                player.field_71075_bZ.func_75092_a(player.getEntityData().func_74760_g("fly_speed"));
            }
        }
    }

    public boolean canFly(ItemStack stack) {
        return stack.func_77973_b() == IUItem.spectral_chestplate || stack.func_77973_b() instanceof ItemSpecialArmor && (((ItemSpecialArmor)stack.func_77973_b()).getListCapability().contains((Object)EnumCapability.FLY) || ((ItemSpecialArmor)stack.func_77973_b()).getListCapability().contains((Object)EnumCapability.JETPACK_FLY)) || stack.func_77973_b() instanceof ItemAdvJetpack && UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, stack);
    }

    @SubscribeEvent
    public void FlyUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer) || event.getEntityLiving().func_130014_f_().field_73011_w.getWorldTime() % 2L != 0L) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        NBTTagCompound nbtData = player.getEntityData();
        if (!player.field_71075_bZ.field_75098_d) {
            if (!((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_190926_b()) {
                if (this.canFly((ItemStack)player.field_71071_by.field_70460_b.get(2))) {
                    NBTTagCompound nbtData1 = ModUtils.nbt((ItemStack)player.field_71071_by.field_70460_b.get(2));
                    boolean jetpack = nbtData1.func_74767_n("jetpack");
                    if (!jetpack) {
                        if (nbtData.func_74767_n("isFlyActive")) {
                            nbtData.func_74757_a("hasFly", true);
                            this.setFly(player, false, (ItemStack)player.field_71071_by.field_70460_b.get(2));
                        }
                    } else if (!player.field_70122_E) {
                        if (nbtData1.func_74767_n("canFly")) {
                            this.setFly(player, true, (ItemStack)player.field_71071_by.field_70460_b.get(2));
                            nbtData1.func_74757_a("canFly", false);
                            nbtData.func_74757_a("canjump", false);
                        }
                    } else if (nbtData.func_74767_n("isFlyActive")) {
                        this.setFly(player, false, (ItemStack)player.field_71071_by.field_70460_b.get(2));
                    }
                } else if (!((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_190926_b() && nbtData.func_74767_n("isFlyActive")) {
                    this.setFly(player, false, (ItemStack)player.field_71071_by.field_70460_b.get(2));
                }
            } else if (nbtData.func_74767_n("isFlyActive")) {
                this.setFly(player, false, (ItemStack)player.field_71071_by.field_70460_b.get(2));
            }
        } else if (nbtData.func_74767_n("isFlyActive")) {
            this.setFly(player, false, (ItemStack)player.field_71071_by.field_70460_b.get(2));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addInformItem(ItemTooltipEvent event) {
        List<String> list;
        Object iUpgradeItem;
        ItemBlockIU itemBlockIU;
        CapturedMobUtils capturedMobUtils;
        NBTTagCompound nBTTagCompound;
        int n;
        Object block;
        IBlockState iBlockState;
        List<String> list2;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (item instanceof IItemSoon) {
            event.getToolTip().add(((IItemSoon)item).getDescription());
        }
        if (item == IUItem.charged_redstone) {
            event.getToolTip().add(Localization.translate("charged_redstone.info"));
        }
        if (event.getItemStack().func_77973_b() instanceof ItemBlock && !(list2 = ModUtils.getInformationFromOre(iBlockState = (block = (ItemBlock)event.getItemStack().func_77973_b()).func_179223_d().func_176203_a(event.getItemStack().func_77952_i()))).isEmpty()) {
            event.getToolTip().add(Localization.translate("veins_ores.info1"));
            event.getToolTip().add(Localization.translate("veins_ores.info"));
            event.getToolTip().addAll(list2);
        }
        if (item instanceof IRadioactiveItemType || item instanceof ItemNuclearResource) {
            event.getToolTip().add(Localization.translate("iu.radiation.warning"));
            event.getToolTip().add(Localization.translate("iu.radioprotector.info"));
        }
        if (item.equals((Object)IUItem.tank.item)) {
            switch (stack.func_77952_i()) {
                case 1: {
                    event.getToolTip().add(Localization.translate("iu.storage_fluid") + 160 + " B");
                    break;
                }
                case 2: {
                    event.getToolTip().add(Localization.translate("iu.storage_fluid") + 480 + " B");
                    break;
                }
                case 3: {
                    event.getToolTip().add(Localization.translate("iu.storage_fluid") + 2560 + " B");
                    break;
                }
                case 0: {
                    event.getToolTip().add(Localization.translate("iu.storage_fluid") + 40 + " B");
                }
            }
        }
        for (Map.Entry entry : TileEntityPalletGenerator.integerMap.entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(stack)) continue;
            event.getToolTip().add(Localization.translate("iu.pellets.info") + entry.getValue());
            event.getToolTip().add(Localization.translate("iu.pellets.info1"));
        }
        if (item.equals(IUItem.module_quickly)) {
            event.getToolTip().add(Localization.translate("iu.info.module.speed"));
        }
        if (item.equals(IUItem.module_stack)) {
            event.getToolTip().add(Localization.translate("iu.info.module.stack"));
        }
        if (item.equals(IUItem.module_storage)) {
            event.getToolTip().add(Localization.translate("iu.info.module.sorting"));
        }
        if (item.equals(IUItem.crafting_elements) && stack.func_77952_i() >= 206 && stack.func_77952_i() <= 216) {
            int meta = stack.func_77952_i() - 205;
            event.getToolTip().add(Localization.translate("iu.limiter.info9") + EnergyNetGlobal.instance.getPowerFromTier(meta) + " EF");
        }
        int meta = stack.func_77952_i();
        if ((item.equals(IUItem.basecircuit) && (meta == 9 || meta == 10 || meta == 11 || meta == 21) || item.equals(IUItem.crafting_elements) && (meta == 272 || meta == 273)) && (n = (nBTTagCompound = ModUtils.nbt(stack)).func_74762_e("level")) != 0) {
            event.getToolTip().add(Localization.translate("circuit.level") + " " + n);
        }
        if (item.equals(IUItem.module7) && stack.func_77952_i() == 9) {
            event.getToolTip().add(Localization.translate("module.wireless"));
        }
        if (item.equals(IUItem.upgrade_speed_creation) || item.equals(IUItem.autoheater) || item.equals(IUItem.coolupgrade) || item.equals(IUItem.module_quickly) || item.equals(IUItem.module_stack) || item.equals(IUItem.module_storage) || item.equals(IUItem.module7) && (stack.func_77952_i() == 4 || stack.func_77952_i() == 10)) {
            event.getToolTip().add(Localization.translate("module.wireless"));
        }
        if ((item.equals(IUItem.entitymodules) || stack.func_77952_i() == 4) && (capturedMobUtils = CapturedMobUtils.create(stack)) != null) {
            Entity entity = Objects.requireNonNull(capturedMobUtils).getEntity(event.getEntity().func_130014_f_(), true);
            event.getToolTip().add(Objects.requireNonNull(entity).func_70005_c_());
        }
        if (item instanceof ItemBlockIU && (itemBlockIU = (ItemBlockIU)item).func_179223_d() instanceof BlockIUFluid) {
            BlockIUFluid blockIUFluid = (BlockIUFluid)itemBlockIU.func_179223_d();
            if (blockIUFluid.getFluid() == FluidName.fluidgas.getInstance()) {
                event.getToolTip().add(Localization.translate("find.gas_vein"));
            }
            if (blockIUFluid.getFluid() == FluidName.fluidneft.getInstance()) {
                event.getToolTip().add(Localization.translate("find.oil_vein"));
            }
        }
        if (item.equals(IUItem.module_quickly) || item.equals(IUItem.module_stack) || item.equals(IUItem.module_storage)) {
            event.getToolTip().add(Localization.translate("using_kit"));
            if (!Keyboard.isKeyDown((int)42)) {
                event.getToolTip().add(ListInformationUtils.mechanism_info.get(ListInformationUtils.index));
            } else {
                for (String string : ListInformationUtils.mechanism_info) {
                    event.getToolTip().add(string);
                }
            }
        }
        if (item.equals(IUItem.coolupgrade)) {
            event.getToolTip().add(Localization.translate("using_kit"));
            List<String> list3 = ListInformationUtils.integerListMap.get(stack.func_77952_i());
            if (!Keyboard.isKeyDown((int)42)) {
                event.getToolTip().add(list3.get(ListInformationUtils.index % list3.size()));
            } else {
                for (Object name2 : list3) {
                    event.getToolTip().add(name2);
                }
            }
        }
        if (item.equals(IUItem.autoheater)) {
            event.getToolTip().add(Localization.translate("using_kit"));
            if (!Keyboard.isKeyDown((int)42)) {
                event.getToolTip().add(ListInformationUtils.mechanism_info2.get(ListInformationUtils.index2));
            } else {
                for (String string : ListInformationUtils.mechanism_info2) {
                    event.getToolTip().add(string);
                }
            }
        }
        if (item.equals(IUItem.upgrade_speed_creation)) {
            event.getToolTip().add(Localization.translate("using_kit"));
            if (!Keyboard.isKeyDown((int)42)) {
                event.getToolTip().add(new ArrayList<String>(ListInformationUtils.mechanism_info1.values()).get(ListInformationUtils.index1));
            } else {
                for (String string : ListInformationUtils.mechanism_info1.values()) {
                    event.getToolTip().add(string);
                }
            }
        }
        if (stack.func_77973_b().equals(IUItem.analyzermodule)) {
            event.getToolTip().add(Localization.translate("iu.analyzermodule"));
        }
        if (stack.func_77973_b().equals(IUItem.quarrymodule)) {
            event.getToolTip().add(Localization.translate("iu.quarrymodule"));
        }
        if (stack.func_77973_b().equals(IUItem.expmodule)) {
            event.getToolTip().add(Localization.translate("iu.expierence_module.info"));
        }
        if (stack.func_77973_b() instanceof ItemEntityModule) {
            meta = stack.func_77952_i();
            if (meta == 0) {
                event.getToolTip().add(Localization.translate("iu.entitymodule"));
            }
            if (meta == 1) {
                event.getToolTip().add(Localization.translate("iu.entitymodule1"));
            }
        }
        if (stack.func_77973_b() instanceof ItemBaseModules) {
            EnumModule enumModule = EnumModule.getFromID(stack.func_77952_i());
            if (enumModule.type.equals((Object)EnumBaseType.PHASE)) {
                event.getToolTip().add(Localization.translate("iu.phasemodule"));
            }
            if (enumModule.type.equals((Object)EnumBaseType.MOON_LINSE)) {
                event.getToolTip().add(Localization.translate("iu.moonlinse"));
            }
        }
        if (IUEventHandler.getUpgradeItem(stack) && UpgradeSystem.system.hasInMap(stack)) {
            List<UpgradeItemInform> list4 = UpgradeSystem.system.getInformation(stack);
            int n2 = UpgradeSystem.system.getRemaining(stack);
            if (!list4.isEmpty()) {
                for (Object upgrade : list4) {
                    event.getToolTip().add(((UpgradeItemInform)upgrade).getName());
                }
            }
            if (n2 != 0) {
                event.getToolTip().add(Localization.translate("free_slot") + n2 + Localization.translate("free_slot1"));
                if (Keyboard.isKeyDown((int)42)) {
                    event.getToolTip().add(Localization.translate("iu.can_upgrade_item"));
                    iUpgradeItem = (IUpgradeItem)stack.func_77973_b();
                    list = UpgradeSystem.system.getAvailableUpgrade((IUpgradeItem)iUpgradeItem, stack);
                    event.getToolTip().addAll(list);
                }
            } else {
                event.getToolTip().add(Localization.translate("not_free_slot"));
            }
        }
        if (stack.func_77973_b() instanceof IRoversItem && SpaceUpgradeSystem.system.hasInMap(stack)) {
            List<SpaceUpgradeItemInform> list5 = SpaceUpgradeSystem.system.getInformation(stack);
            int n3 = SpaceUpgradeSystem.system.getRemaining(stack);
            if (!list5.isEmpty()) {
                for (Object upgrade : list5) {
                    event.getToolTip().add(((SpaceUpgradeItemInform)upgrade).getName());
                }
            }
            if (n3 != 0) {
                event.getToolTip().add(Localization.translate("free_slot") + n3 + Localization.translate("free_slot1"));
                if (Keyboard.isKeyDown((int)42)) {
                    event.getToolTip().add(Localization.translate("iu.can_upgrade_item"));
                    iUpgradeItem = (IRoversItem)stack.func_77973_b();
                    list = SpaceUpgradeSystem.system.getAvailableUpgrade((IRoversItem)iUpgradeItem, stack);
                    event.getToolTip().addAll(list);
                }
            } else {
                event.getToolTip().add(Localization.translate("not_free_slot"));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemTooltipEvent event) {
        RecipeOutput output1;
        ItemStack stack = event.getItemStack();
        if (this.tupleRecipe == null) {
            for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.machineRecipe) {
                if (!entry.getKey().func_77969_a(stack)) continue;
                this.tupleRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                if (!Keyboard.isKeyDown((int)42)) {
                    event.getToolTip().add(Localization.translate("press.lshift"));
                }
                if (!Keyboard.isKeyDown((int)42)) break;
                event.getToolTip().add(Localization.translate("clonning"));
                output1 = entry.getValue().output;
                for (int i = 0; i < this.name.length; ++i) {
                    if (output1.metadata.func_74769_h("quantitysolid_" + i) == 0.0) continue;
                    event.getToolTip().add(this.name[i] + Localization.translate(this.mattertype[i]) + ": " + output1.metadata.func_74769_h("quantitysolid_" + i) + Localization.translate("matternumber"));
                }
            }
            if (this.tupleRecipe == null) {
                this.tupleRecipe = new Tuple((Object)stack, null);
            }
        } else if (((ItemStack)this.tupleRecipe.func_76341_a()).func_77969_a(stack)) {
            if (this.tupleRecipe.func_76340_b() != null) {
                if (!Keyboard.isKeyDown((int)42)) {
                    event.getToolTip().add(Localization.translate("press.lshift"));
                }
                if (Keyboard.isKeyDown((int)42)) {
                    event.getToolTip().add(Localization.translate("clonning"));
                    RecipeOutput output12 = ((BaseMachineRecipe)this.tupleRecipe.func_76340_b()).output;
                    for (int i = 0; i < this.name.length; ++i) {
                        if (output12.metadata.func_74769_h("quantitysolid_" + i) == 0.0) continue;
                        event.getToolTip().add(this.name[i] + Localization.translate(this.mattertype[i]) + ": " + output12.metadata.func_74769_h("quantitysolid_" + i) + Localization.translate("matternumber"));
                    }
                }
            }
        } else {
            boolean find = false;
            for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.machineRecipe) {
                if (!entry.getKey().func_77969_a(stack)) continue;
                this.tupleRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                find = true;
                if (!Keyboard.isKeyDown((int)42)) {
                    event.getToolTip().add(Localization.translate("press.lshift"));
                }
                if (!Keyboard.isKeyDown((int)42)) break;
                event.getToolTip().add(Localization.translate("clonning"));
                RecipeOutput output13 = entry.getValue().output;
                for (int i = 0; i < this.name.length; ++i) {
                    if (output13.metadata.func_74769_h("quantitysolid_" + i) == 0.0) continue;
                    event.getToolTip().add(this.name[i] + Localization.translate(this.mattertype[i]) + ": " + output13.metadata.func_74769_h("quantitysolid_" + i) + Localization.translate("matternumber"));
                }
            }
            if (!find) {
                this.tupleRecipe = new Tuple((Object)stack, null);
            }
        }
        if (this.tupleReplicatorRecipe == null) {
            for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.fluidMatterRecipe) {
                if (!entry.getKey().func_77969_a(stack)) continue;
                if (!Keyboard.isKeyDown((int)42) && !event.getToolTip().contains(Localization.translate("press.lshift"))) {
                    event.getToolTip().add(Localization.translate("press.lshift"));
                }
                this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                if (!Keyboard.isKeyDown((int)42)) break;
                output1 = entry.getValue().output;
                double matter = output1.metadata.func_74769_h("matter");
                String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                event.getToolTip().add(Localization.translate("iu.replicator_using_matter") + TextFormatting.DARK_PURPLE + usingMatter);
                break;
            }
            if (this.tupleReplicatorRecipe == null) {
                this.tupleReplicatorRecipe = new Tuple((Object)stack, null);
            }
        } else if (((ItemStack)this.tupleReplicatorRecipe.func_76341_a()).func_77969_a(stack)) {
            if (this.tupleReplicatorRecipe.func_76340_b() != null) {
                if (!Keyboard.isKeyDown((int)42) && !event.getToolTip().contains(Localization.translate("press.lshift"))) {
                    event.getToolTip().add(Localization.translate("press.lshift"));
                }
                if (Keyboard.isKeyDown((int)42)) {
                    RecipeOutput output14 = ((BaseMachineRecipe)this.tupleReplicatorRecipe.func_76340_b()).output;
                    double matter = output14.metadata.func_74769_h("matter");
                    String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                    event.getToolTip().add(Localization.translate("iu.replicator_using_matter") + TextFormatting.DARK_PURPLE + usingMatter);
                }
            }
        } else {
            this.tupleReplicatorRecipe = null;
            for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.fluidMatterRecipe) {
                if (!entry.getKey().func_77969_a(stack)) continue;
                if (!Keyboard.isKeyDown((int)42) && !event.getToolTip().contains(Localization.translate("press.lshift"))) {
                    event.getToolTip().add(Localization.translate("press.lshift"));
                }
                this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                if (!Keyboard.isKeyDown((int)42)) break;
                output1 = entry.getValue().output;
                double matter = output1.metadata.func_74769_h("matter");
                String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                event.getToolTip().add(Localization.translate("iu.replicator_using_matter") + TextFormatting.DARK_PURPLE + usingMatter);
                break;
            }
            if (this.tupleReplicatorRecipe == null) {
                this.tupleReplicatorRecipe = new Tuple((Object)stack, null);
            }
        }
    }
}

