/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUItem;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockApatite;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import com.denfop.blocks.BlockOre;
import com.denfop.blocks.BlockOres2;
import com.denfop.blocks.BlockOres3;
import com.denfop.blocks.BlockPreciousOre;
import com.denfop.blocks.BlockThoriumOre;
import com.denfop.blocks.BlocksRadiationOre;
import com.denfop.events.ClientTickHandler;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.energy.instruments.EnumOperations;
import com.denfop.items.energy.instruments.ItemEnergyInstruments;
import com.denfop.utils.ModUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TickHandler {
    final int latitudeSegments = 8;
    final int longitudeSegments = 8;
    double[] sinLat = new double[9];
    double[] cosLat = new double[9];
    double[] sinLng = new double[9];
    double[] cosLng = new double[9];
    boolean write = false;
    double[][] x1 = new double[8][8];
    double[][] x2 = new double[8][8];
    double[][] x3 = new double[8][8];
    double[][] x4 = new double[8][8];
    double[][] y1 = new double[8][8];
    double[][] y2 = new double[8][8];
    double[][] y3 = new double[8][8];
    double[][] y4 = new double[8][8];
    double[][] z1 = new double[8][8];
    double[][] z2 = new double[8][8];
    double[][] z3 = new double[8][8];
    double[][] z4 = new double[8][8];
    Set<UpgradableProperty> set = EnumSet.of(UpgradableProperty.FluidExtract, UpgradableProperty.FluidInput, UpgradableProperty.ItemInput, UpgradableProperty.ItemExtract);

    public TickHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        new GlobalRenderManager();
    }

    public int getOreColor(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150366_p) {
            return ModUtils.convertRGBcolorToInt(156, 156, 156);
        }
        if (block == Blocks.field_150352_o) {
            return -10496;
        }
        if (block == Blocks.field_150482_ag) {
            return -16711681;
        }
        if (block == Blocks.field_150369_x) {
            return ModUtils.convertRGBcolorToInt(30, 50, 173);
        }
        if (block == Blocks.field_150450_ax || block == Blocks.field_150439_ay) {
            return ModUtils.convertRGBcolorToInt(173, 30, 30);
        }
        if (block == Blocks.field_150365_q) {
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block == Blocks.field_150412_bA) {
            return ModUtils.convertRGBcolorToInt(0, 232, 0);
        }
        if (block == Blocks.field_150449_bY) {
            return ModUtils.convertRGBcolorToInt(223, 223, 223);
        }
        if (block == IUItem.toriyore) {
            return ModUtils.convertRGBcolorToInt(134, 134, 139);
        }
        if (block instanceof BlockClassicOre) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(255, 144, 0);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(223, 223, 223);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(168, 176, 150);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(89, 158, 73);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlocksRadiationOre) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(120, 152, 183);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(97, 109, 88);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 166, 148);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockPreciousOre) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(251, 140, 119);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(38, 60, 143);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(204, 180, 47);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(221, 221, 221);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOre) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(119, 210, 202);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(108, 74, 108);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(142, 240, 216);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(199, 199, 199);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(0, 166, 226);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(170, 145, 160);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(145, 143, 88);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(104, 152, 237);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(71, 71, 71);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(83, 174, 85);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(184, 87, 145);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(211, 211, 211);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(186, 186, 186);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(235, 193, 207);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(234, 234, 234);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(138, 85, 34);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockHeavyOre) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(137, 131, 149);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(249, 175, 44);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 215, 206);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(211, 202, 110);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(212, 175, 55);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(250, 246, 241);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(70, 145, 15);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(230, 107, 0);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(139, 0, 0);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(55, 135, 135);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(170, 123, 44);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(109, 206, 167);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 110, 110);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(198, 147, 64);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(100, 76, 136);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(135, 84, 64);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockMineral) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(12, 166, 166);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(55, 117, 104);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(113, 97, 81);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(99, 51, 4);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(117, 88, 86);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(118, 28, 17);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(123, 76, 10);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(126, 101, 36);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(30, 126, 56);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(112, 129, 30);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(39, 64, 63);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 25, 24);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres3) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(191, 212, 65);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(253, 242, 80);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(37, 145, 133);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(255, 180, 0);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(252, 187, 89);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(212, 231, 255);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(222, 101, 98);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(118, 84, 192);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(125, 122, 160);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(61, 148, 224);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(230, 105, 17);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(84, 194, 246);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(168, 90, 41);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(121, 229, 71);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(255, 225, 136);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(194, 189, 56);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres2) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(190, 207, 214);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(194, 194, 194);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(62, 69, 71);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(165, 236, 244);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(141, 174, 83);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(177, 100, 197);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(212, 212, 212);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockApatite) {
            int meta = block.func_176201_c(state);
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(48, 86, 16);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(134, 95, 11);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        ChunkPos chunkPos;
        EntityPlayerSP player;
        World world;
        int tier;
        if (event.getEntityLiving() instanceof EntityPlayerSP && (tier = this.getRadiationTier(world = player.field_70170_p, chunkPos = new ChunkPos((player = (EntityPlayerSP)event.getEntityLiving()).func_180425_c()))) > 1) {
            this.showRadiationEffects(player, world, chunkPos, tier);
        }
    }

    private int getRadiationTier(World world, ChunkPos chunkPos) {
        Radiation rad = RadiationSystem.rad_system.getMap().get(chunkPos);
        return rad == null ? 0 : rad.getLevel().ordinal();
    }

    private void showRadiationEffects(EntityPlayerSP player, World world, ChunkPos chunkPos, int tier) {
        ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
        int particleCount = MathHelper.func_76125_a((int)(tier * 30), (int)30, (int)120);
        double minX = chunkPos.func_180334_c();
        double maxX = chunkPos.func_180332_e() + 1;
        double minZ = chunkPos.func_180333_d();
        double maxZ = chunkPos.func_180330_f() + 1;
        for (int i = 0; i < particleCount; ++i) {
            double z;
            double x;
            double y = player.field_70163_u + world.field_73012_v.nextDouble() * 16.0;
            switch (world.field_73012_v.nextInt(4)) {
                case 0: {
                    x = minX;
                    z = minZ + world.field_73012_v.nextDouble() * 16.0;
                    break;
                }
                case 1: {
                    x = maxX;
                    z = minZ + world.field_73012_v.nextDouble() * 16.0;
                    break;
                }
                case 2: {
                    x = minX + world.field_73012_v.nextDouble() * 16.0;
                    z = minZ;
                    break;
                }
                default: {
                    x = minX + world.field_73012_v.nextDouble() * 16.0;
                    z = maxZ;
                }
            }
            EnumParticleTypes particleType = world.field_73012_v.nextBoolean() ? EnumParticleTypes.PORTAL : EnumParticleTypes.SMOKE_NORMAL;
            Particle particle = particleManager.func_178927_a(particleType.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[0]);
            if (particle == null) continue;
            if (particleType == EnumParticleTypes.PORTAL) {
                particle.func_70538_b(0.0f, 1.0f - (float)tier * 0.2f, 0.0f);
                particle.func_82338_g(0.5f + world.field_73012_v.nextFloat() * 0.5f);
            } else {
                particle.func_70538_b(0.1f, 0.9f - (float)tier * 0.15f, 0.1f);
                particle.func_82338_g(0.7f + world.field_73012_v.nextFloat() * 0.3f);
                particle.field_187129_i = (world.field_73012_v.nextDouble() - 0.5) * 0.05;
                particle.field_187130_j = (world.field_73012_v.nextDouble() - 0.5) * 0.05;
                particle.field_187131_k = (world.field_73012_v.nextDouble() - 0.5) * 0.05;
            }
            particleManager.func_78873_a(particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderOres(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || mc.field_71441_e == null) {
            return;
        }
        if (!(player.func_184614_ca().func_77973_b() instanceof ItemEnergyInstruments)) {
            return;
        }
        if (!this.write) {
            this.writeData();
        }
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        RayTraceResult ray = mc.field_71476_x;
        if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        ItemEnergyInstruments instruments = (ItemEnergyInstruments)player.func_184614_ca().func_77973_b();
        int toolMode = instruments.readToolMode(stack);
        EnumOperations operations = instruments.getOperations().get(toolMode);
        if (operations != EnumOperations.ORE) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        x = ray.func_178782_a().func_177958_n();
        y = ray.func_178782_a().func_177956_o();
        z = ray.func_178782_a().func_177952_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int xPos = (int)(x - 5.0);
        while ((double)xPos <= x + 5.0) {
            int yPos = (int)(y - 5.0);
            while ((double)yPos <= y + 5.0) {
                int zPos = (int)(z - 5.0);
                while ((double)zPos <= z + 5.0) {
                    BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                    IBlockState state = player.func_130014_f_().func_180495_p(currentPos);
                    if (this.isOre(state)) {
                        int color = this.getOreColor(state);
                        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)0.5f);
                        this.drawCircle(buffer, currentPos, tessellator);
                    }
                    ++zPos;
                }
                ++yPos;
            }
            ++xPos;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private void writeData() {
        int i;
        this.write = true;
        for (i = 0; i <= 8; ++i) {
            double lat = Math.PI * (-0.5 + (double)i / 8.0);
            this.sinLat[i] = Math.sin(lat);
            this.cosLat[i] = Math.cos(lat);
        }
        for (int j = 0; j <= 8; ++j) {
            double lng = Math.PI * 2 * (double)j / 8.0;
            this.sinLng[j] = Math.sin(lng);
            this.cosLng[j] = Math.cos(lng);
        }
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.x1[i][j] = this.cosLng[j] * this.cosLat[i];
                this.y1[i][j] = this.sinLat[i];
                this.z1[i][j] = this.sinLng[j] * this.cosLat[i];
                this.x2[i][j] = this.cosLng[j] * this.cosLat[i + 1];
                this.y2[i][j] = this.sinLat[i + 1];
                this.z2[i][j] = this.sinLng[j] * this.cosLat[i + 1];
                this.x3[i][j] = this.cosLng[j + 1] * this.cosLat[i + 1];
                this.y3[i][j] = this.sinLat[i + 1];
                this.z3[i][j] = this.sinLng[j + 1] * this.cosLat[i + 1];
                this.x4[i][j] = this.cosLng[j + 1] * this.cosLat[i];
                this.y4[i][j] = this.sinLat[i];
                this.z4[i][j] = this.sinLng[j + 1] * this.cosLat[i];
            }
        }
    }

    private boolean isOre(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150366_p || state.func_177230_c() instanceof BlocksRadiationOre || state.func_177230_c() instanceof BlockThoriumOre || state.func_177230_c() == Blocks.field_150352_o || state.func_177230_c() == Blocks.field_150365_q || state.func_177230_c() == Blocks.field_150450_ax || state.func_177230_c() == Blocks.field_150439_ay || state.func_177230_c() == Blocks.field_150412_bA || state.func_177230_c() == Blocks.field_150449_bY || state.func_177230_c() == Blocks.field_150369_x || state.func_177230_c() instanceof BlockClassicOre || state.func_177230_c() instanceof BlockPreciousOre || state.func_177230_c() == Blocks.field_150482_ag || state.func_177230_c() instanceof BlockHeavyOre || state.func_177230_c() instanceof BlockMineral || state.func_177230_c() instanceof BlockOre || state.func_177230_c() instanceof BlockOres2 || state.func_177230_c() instanceof BlockOres3 || state.func_177230_c() instanceof BlockApatite;
    }

    private void drawCircle(BufferBuilder buffer, BlockPos pos, Tessellator tessellator) {
        double radius = 0.25;
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        buffer.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                double x1 = this.x1[i][j];
                double y1 = this.y1[i][j];
                double z1 = this.z1[i][j];
                double x2 = this.x2[i][j];
                double y2 = this.y2[i][j];
                double z2 = this.z2[i][j];
                double x3 = this.x3[i][j];
                double y3 = this.y3[i][j];
                double z3 = this.z3[i][j];
                double x4 = this.x4[i][j];
                double y4 = this.y4[i][j];
                double z4 = this.z4[i][j];
                buffer.func_181662_b(x + x1 * radius, y + y1 * radius, z + z1 * radius).func_181675_d();
                buffer.func_181662_b(x + x2 * radius, y + y2 * radius, z + z2 * radius).func_181675_d();
                buffer.func_181662_b(x + x3 * radius, y + y3 * radius, z + z3 * radius).func_181675_d();
                buffer.func_181662_b(x + x3 * radius, y + y3 * radius, z + z3 * radius).func_181675_d();
                buffer.func_181662_b(x + x4 * radius, y + y4 * radius, z + z4 * radius).func_181675_d();
                buffer.func_181662_b(x + x1 * radius, y + y1 * radius, z + z1 * radius).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || mc.field_71441_e == null) {
            return;
        }
        if (!(player.func_184614_ca().func_77973_b() instanceof ItemEnergyInstruments)) {
            return;
        }
        RayTraceResult ray = mc.field_71476_x;
        if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        ItemEnergyInstruments instruments = (ItemEnergyInstruments)player.func_184614_ca().func_77973_b();
        ItemStack stack = player.func_184614_ca();
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
        int toolMode = instruments.readToolMode(stack);
        EnumOperations operations = instruments.getOperations().get(toolMode);
        int aoe = 0;
        int dig_depth = 0;
        switch (operations) {
            case BIGHOLES: {
                aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                ++aoe;
                dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                if (list == null || list.size() < 5) break;
                dig_depth += list.get(4).intValue();
                break;
            }
            case MEGAHOLES: {
                aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                aoe += 2;
                dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                if (list == null || list.size() < 5) break;
                dig_depth += list.get(4).intValue();
                break;
            }
            case ULTRAHOLES: {
                aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                aoe += 3;
                dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                if (list == null || list.size() < 5) break;
                dig_depth += list.get(4).intValue();
                break;
            }
        }
        BlockPos pos = ray.func_178782_a();
        int xRange = aoe;
        int yRange = aoe;
        int zRange = aoe;
        switch (ray.field_178784_b.ordinal()) {
            case 0: 
            case 1: {
                yRange = dig_depth;
                break;
            }
            case 2: 
            case 3: {
                zRange = dig_depth;
                break;
            }
            case 4: 
            case 5: {
                xRange = dig_depth;
            }
        }
        int Yy = yRange > 0 ? yRange - 1 : 0;
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        x = pos.func_177958_n();
        y = pos.func_177956_o();
        z = pos.func_177952_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        Vec3d lookVec = player.func_70676_i(1.0f);
        int xPos = (int)(x - (double)xRange);
        while ((double)xPos <= x + (double)xRange) {
            int yPos = (int)(y - (double)yRange + (double)Yy);
            while ((double)yPos <= y + (double)yRange + (double)Yy) {
                int zPos = (int)(z - (double)zRange);
                while ((double)zPos <= z + (double)zRange) {
                    Vec3d blockVec;
                    BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                    IBlockState state = player.func_130014_f_().func_180495_p(currentPos);
                    if (state.func_185904_a() != Material.field_151579_a && !(lookVec.func_72430_b(blockVec = new Vec3d((double)currentPos.func_177958_n() + 0.5 - player.field_70165_t, (double)currentPos.func_177956_o() + 0.5 - player.field_70163_u, (double)currentPos.func_177952_p() + 0.5 - player.field_70161_v)) <= 0.0)) {
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                    }
                    ++zPos;
                }
                ++yPos;
            }
            ++xPos;
        }
        tessellator.func_78381_a();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTileSide(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || mc.field_71441_e == null) {
            return;
        }
        if (!(player.func_184614_ca().func_77973_b() instanceof IUpgradeItem)) {
            return;
        }
        IUpgradeItem upgradeItem = (IUpgradeItem)player.func_184614_ca().func_77973_b();
        if (!upgradeItem.isSuitableFor(player.func_184614_ca(), this.set)) {
            return;
        }
        RayTraceResult ray = mc.field_71476_x;
        if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        EnumFacing facing = InvSlotUpgrade.getDirection(player.func_184614_ca());
        TileEntity tile = player.func_130014_f_().func_175625_s(ray.func_178782_a());
        if (!(tile instanceof IUpgradableBlock)) {
            return;
        }
        if (facing != null) {
            BlockPos pos = ray.func_178782_a().func_177972_a(facing);
            boolean xRange = false;
            boolean yRange = false;
            boolean zRange = false;
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            x = pos.func_177958_n();
            y = pos.func_177956_o();
            z = pos.func_177952_p();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            Vec3d lookVec = player.func_70676_i(1.0f);
            int xPos = (int)(x - (double)xRange);
            while ((double)xPos <= x + (double)xRange) {
                int yPos = (int)(y - (double)yRange);
                while ((double)yPos <= y + (double)yRange) {
                    int zPos = (int)(z - (double)zRange);
                    while ((double)zPos <= z + (double)zRange) {
                        BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                        Vec3d blockVec = new Vec3d((double)currentPos.func_177958_n() + 0.5 - player.field_70165_t, (double)currentPos.func_177956_o() + 0.5 - player.field_70163_u, (double)currentPos.func_177952_p() + 0.5 - player.field_70161_v);
                        if (!(lookVec.func_72430_b(blockVec) <= 0.0)) {
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                        }
                        ++zPos;
                    }
                    ++yPos;
                }
                ++xPos;
            }
            tessellator.func_78381_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        } else {
            for (EnumFacing facing1 : EnumFacing.field_82609_l) {
                BlockPos pos = ray.func_178782_a().func_177972_a(facing1);
                boolean xRange = false;
                boolean yRange = false;
                boolean zRange = false;
                double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
                x = pos.func_177958_n();
                y = pos.func_177956_o();
                z = pos.func_177952_p();
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_179097_i();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
                Vec3d lookVec = player.func_70676_i(1.0f);
                int xPos = (int)(x - (double)xRange);
                while ((double)xPos <= x + (double)xRange) {
                    int yPos = (int)(y - (double)yRange);
                    while ((double)yPos <= y + (double)yRange) {
                        int zPos = (int)(z - (double)zRange);
                        while ((double)zPos <= z + (double)zRange) {
                            BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                            Vec3d blockVec = new Vec3d((double)currentPos.func_177958_n() + 0.5 - player.field_70165_t, (double)currentPos.func_177956_o() + 0.5 - player.field_70163_u, (double)currentPos.func_177952_p() + 0.5 - player.field_70161_v);
                            if (!(lookVec.func_72430_b(blockVec) <= 0.0)) {
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p()).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)(currentPos.func_177958_n() + 1), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                                buffer.func_181662_b((double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)(currentPos.func_177952_p() + 1)).func_181675_d();
                            }
                            ++zPos;
                        }
                        ++yPos;
                    }
                    ++xPos;
                }
                tessellator.func_78381_a();
                GlStateManager.func_179126_j();
                GlStateManager.func_179084_k();
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            ClientTickHandler.onTickRender1();
        }
    }
}

