/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.api.gasvein.GasVein;
import com.denfop.api.gasvein.GasVeinSystem;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.items.relocator.Point;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.tiles.quarry_earth.TileEntityEarthQuarryController;
import com.denfop.world.GenData;
import com.denfop.world.WorldGenGas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class WorldSavedDataIU
extends WorldSavedData {
    public int col;
    World world;
    private NBTTagCompound tagCompound = new NBTTagCompound();

    public WorldSavedDataIU() {
        super("industrialupgrade");
    }

    public WorldSavedDataIU(String name) {
        super(name);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void func_76184_a(@Nonnull NBTTagCompound compound) {
        int i;
        SpaceNet.instance.getFakeSpaceSystem().unload();
        if (compound.func_74764_b("fakePlayers")) {
            NBTTagList fakePlayersList = compound.func_150295_c("fakePlayers", 10);
            for (i = 0; i < fakePlayersList.func_74745_c(); ++i) {
                NBTTagCompound nbt = fakePlayersList.func_150305_b(i);
                UUID name = nbt.func_186857_a("name");
                NBTTagList fakesBody = nbt.func_150295_c("fakesBody", 10);
                NBTTagList dataBody = nbt.func_150295_c("dataBody", 10);
                HashMap<IBody, Data> map = new HashMap<IBody, Data>();
                for (int ii = 0; ii < dataBody.func_74745_c(); ++ii) {
                    NBTTagCompound nbt1 = dataBody.func_150305_b(ii);
                    Data data = new Data(nbt1.func_74775_l("data"));
                    map.put(data.getBody(), data);
                }
                SpaceNet.instance.getFakeSpaceSystem().addDataBody(name, map);
                LinkedList<IFakeBody> fakeBodies = new LinkedList<IFakeBody>();
                for (int ii = 0; ii < fakesBody.func_74745_c(); ++ii) {
                    IFakeBody fakePlanet;
                    NBTTagCompound nbt1 = fakesBody.func_150305_b(ii);
                    byte id = nbt1.func_74771_c("id");
                    if (id == 0) {
                        fakePlanet = new FakePlanet(nbt1);
                        fakeBodies.add(fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().addFakePlanet((FakePlanet)fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakePlanet)fakePlanet).getPlayer()).put(((FakePlanet)fakePlanet).getPlanet(), ((FakePlanet)fakePlanet).getSpaceOperation());
                    }
                    if (id == 1) {
                        fakePlanet = new FakeSatellite(nbt1);
                        fakeBodies.add(fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().addFakeSatellite((FakeSatellite)fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakeSatellite)fakePlanet).getPlayer()).put(((FakeSatellite)fakePlanet).getSatellite(), ((FakeSatellite)fakePlanet).getSpaceOperation());
                    }
                    if (id != 2) continue;
                    fakePlanet = new FakeAsteroid(nbt1);
                    fakeBodies.add(fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().addFakeAsteroid((FakeAsteroid)fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakeAsteroid)fakePlanet).getPlayer()).put(((FakeAsteroid)fakePlanet).getAsteroid(), ((FakeAsteroid)fakePlanet).getSpaceOperation());
                }
                SpaceNet.instance.getFakeSpaceSystem().getBodyMap().put(name, new ArrayList(fakeBodies));
            }
        }
        VeinSystem.system.unload();
        if (compound.func_74764_b("veins")) {
            NBTTagList veinsList = compound.func_150295_c("veins", 10);
            for (i = 0; i < veinsList.func_74745_c(); ++i) {
                NBTTagCompound veinTag = veinsList.func_150305_b(i);
                VeinSystem.system.addVein(veinTag);
            }
        }
        SpaceNet.instance.getColonieNet().unload();
        if (compound.func_74764_b("colonies")) {
            NBTTagList coloniesList = compound.func_150295_c("colonies", 10);
            for (i = 0; i < coloniesList.func_74745_c(); ++i) {
                NBTTagCompound colonyTag = coloniesList.func_150305_b(i);
                SpaceNet.instance.getColonieNet().addColony(colonyTag);
            }
        }
        RadiationSystem.rad_system.clear();
        if (compound.func_74764_b("radiations")) {
            NBTTagList radiationsList = compound.func_150295_c("radiations", 10);
            for (i = 0; i < radiationsList.func_74745_c(); ++i) {
                NBTTagCompound radiationTag = radiationsList.func_150305_b(i);
                RadiationSystem.rad_system.addRadiation(radiationTag);
            }
        }
        IUCore.mapStreakInfo.clear();
        if (compound.func_74764_b("streaks")) {
            NBTTagList streaksList = compound.func_150295_c("streaks", 10);
            for (i = 0; i < streaksList.func_74745_c(); ++i) {
                NBTTagCompound streakTag = streaksList.func_150305_b(i);
                String nick = streakTag.func_74779_i("nick");
                PlayerStreakInfo streakInfo = new PlayerStreakInfo(streakTag.func_74775_l("streak"));
                IUCore.mapStreakInfo.putIfAbsent(nick, streakInfo);
            }
        }
        if (compound.func_74764_b("pollution")) {
            NBTTagCompound pollutionTag = compound.func_74775_l("pollution");
            PollutionManager.pollutionManager.loadData(pollutionTag);
        }
        TileEntityEarthQuarryController.chunkPos.clear();
        if (compound.func_74764_b("earth_quarry")) {
            NBTTagList earthQuarryList = compound.func_150295_c("earth_quarry", 10);
            for (i = 0; i < earthQuarryList.func_74745_c(); ++i) {
                NBTTagCompound chunkTag = earthQuarryList.func_150305_b(i);
                int x = chunkTag.func_74762_e("x");
                int z = chunkTag.func_74762_e("z");
                TileEntityEarthQuarryController.chunkPos.add(new ChunkPos(x, z));
            }
        }
        WorldGenGas.gasMap.clear();
        if (compound.func_74764_b("gen_gas")) {
            NBTTagList gasMapList = compound.func_150295_c("gen_gas", 10);
            for (i = 0; i < gasMapList.func_74745_c(); ++i) {
                NBTTagCompound gasTag = gasMapList.func_150305_b(i);
                int x = gasTag.func_74762_e("x");
                int z = gasTag.func_74762_e("z");
                NBTTagCompound dataTag = gasTag.func_74775_l("data");
                WorldGenGas.gasMap.put(new ChunkPos(x, z), new GenData(dataTag));
            }
        }
        PrimitiveHandler.getMapPrimitives().clear();
        if (compound.func_74764_b("primitive")) {
            NBTTagList primitiveList = compound.func_150295_c("primitive", 10);
            for (i = 0; i < primitiveList.func_74745_c(); ++i) {
                NBTTagCompound primitiveCompound = primitiveList.func_150305_b(i);
                NBTTagList playersList = primitiveCompound.func_150295_c("listPlayers", 10);
                HashMap<UUID, Double> playerMap = new HashMap<UUID, Double>();
                for (int j = 0; j < playersList.func_74745_c(); ++j) {
                    NBTTagCompound playerCompound = playersList.func_150305_b(j);
                    UUID playerUUID = playerCompound.func_186857_a("uuid");
                    double value = playerCompound.func_74769_h("value");
                    playerMap.put(playerUUID, value);
                }
                EnumPrimitive primitiveType = EnumPrimitive.values()[primitiveCompound.func_74762_e("id")];
                PrimitiveHandler.getMapPrimitives().put(primitiveType, playerMap);
            }
        }
        GasVeinSystem.system.unload();
        if (compound.func_74764_b("gasvein")) {
            NBTTagList gasVeinsList = compound.func_150295_c("gasvein", 10);
            for (i = 0; i < gasVeinsList.func_74745_c(); ++i) {
                NBTTagCompound gasVeinTag = gasVeinsList.func_150305_b(i);
                GasVeinSystem.system.addVein(gasVeinTag);
            }
        }
        RelocatorNetwork.instance.onUnload();
        if (compound.func_74764_b("relocator")) {
            NBTTagCompound tag8 = compound.func_74775_l("relocator");
            NBTTagList nbtTagList = tag8.func_150295_c("worldUUID", 10);
            for (int i2 = 0; i2 < nbtTagList.func_74745_c(); ++i2) {
                NBTTagCompound tag9 = nbtTagList.func_150305_b(i2);
                int id = tag9.func_74762_e("id");
                NBTTagList nbtTagList1 = tag9.func_150295_c("listUUID", 10);
                HashMap uuidMap = new HashMap();
                for (int j = 0; j < nbtTagList1.func_74745_c(); ++j) {
                    NBTTagCompound tag10 = nbtTagList1.func_150305_b(j);
                    if (tag10.func_74764_b("listPoint")) {
                        UUID uuid = tag10.func_186857_a("uuid");
                        NBTTagList nbtTagList2 = tag10.func_150295_c("listPoint", 10);
                        LinkedList<Point> points = new LinkedList<Point>();
                        for (int k = 0; k < nbtTagList2.func_74745_c(); ++k) {
                            NBTTagCompound pointTag = nbtTagList2.func_150305_b(k);
                            Point point = new Point(pointTag);
                            points.add(point);
                        }
                        uuidMap.put(uuid, points);
                    }
                    RelocatorNetwork.instance.getWorldDataPoints().put(id, uuidMap);
                }
            }
        } else {
            compound.func_74782_a("relocator", (NBTBase)new NBTTagCompound());
        }
        HashMap<UUID, Map<String, List<String>>> mapData = new HashMap<UUID, Map<String, List<String>>>();
        GuideBookCore.uuidGuideMap.clear();
        if (compound.func_74764_b("guide_book")) {
            NBTTagCompound data = compound.func_74775_l("guide_book");
            NBTTagList list = data.func_150295_c("list", 10);
            for (int i3 = 0; i3 < list.func_74745_c(); ++i3) {
                NBTTagCompound data1 = list.func_150305_b(i3);
                UUID uuid = data1.func_186857_a("uuid");
                HashMap mapQuest = new HashMap();
                NBTTagList list1 = data1.func_150295_c("list", 10);
                for (int j = 0; j < list1.func_74745_c(); ++j) {
                    NBTTagCompound data2 = list1.func_150305_b(j);
                    String tab = data2.func_74779_i("tab");
                    NBTTagList list2 = data2.func_150295_c("list", 8);
                    ArrayList<String> names = new ArrayList<String>();
                    for (int k = 0; k < list2.func_74745_c(); ++k) {
                        names.add(list2.func_150307_f(k));
                    }
                    mapQuest.put(tab, names);
                }
                mapData.put(uuid, mapQuest);
            }
        }
        GuideBookCore.uuidGuideMap = mapData;
    }

    public NBTTagCompound getTagCompound() {
        return this.tagCompound;
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        compound = new NBTTagCompound();
        NBTTagList fakePlayersList = new NBTTagList();
        for (UUID uUID : SpaceNet.instance.getFakeSpaceSystem().getBodyMap().keySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_186854_a("name", uUID);
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(uUID);
            Map<IBody, Data> map = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uUID);
            NBTTagList nBTTagList = new NBTTagList();
            for (IFakeBody iFakeBody : list) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                if (iFakeBody instanceof IFakePlanet) {
                    nBTTagCompound2.func_74774_a("id", (byte)0);
                }
                if (iFakeBody instanceof IFakeSatellite) {
                    nBTTagCompound2.func_74774_a("id", (byte)1);
                }
                if (iFakeBody instanceof IFakeAsteroid) {
                    nBTTagCompound2.func_74774_a("id", (byte)2);
                }
                iFakeBody.writeNBTTagCompound(nBTTagCompound2);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
            }
            nBTTagCompound.func_74782_a("fakesBody", (NBTBase)nBTTagList);
            NBTTagList nBTTagList2 = new NBTTagList();
            for (Map.Entry<IBody, Data> entry : map.entrySet()) {
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                nBTTagCompound3.func_74782_a("data", (NBTBase)entry.getValue().writeNBT());
                nBTTagList2.func_74742_a((NBTBase)nBTTagCompound3);
            }
            nBTTagCompound.func_74782_a("dataBody", (NBTBase)nBTTagList2);
            fakePlayersList.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("fakePlayers", (NBTBase)fakePlayersList);
        NBTTagList veinsList = new NBTTagList();
        for (Vein vein : VeinSystem.system.getVeinsList()) {
            veinsList.func_74742_a((NBTBase)vein.writeTag());
        }
        compound.func_74782_a("veins", (NBTBase)veinsList);
        NBTTagList nBTTagList = new NBTTagList();
        for (UUID uUID : SpaceNet.instance.getColonieNet().getList()) {
            nBTTagList.func_74742_a((NBTBase)SpaceNet.instance.getColonieNet().writeNBT(new NBTTagCompound(), uUID));
        }
        compound.func_74782_a("colonies", (NBTBase)nBTTagList);
        NBTTagList nBTTagList3 = new NBTTagList();
        for (Radiation radiation : RadiationSystem.rad_system.radiationList) {
            nBTTagList3.func_74742_a((NBTBase)radiation.writeCompound());
        }
        compound.func_74782_a("radiations", (NBTBase)nBTTagList3);
        NBTTagList nBTTagList4 = new NBTTagList();
        for (Map.Entry<EnumPrimitive, Map<UUID, Double>> entry : PrimitiveHandler.getMapPrimitives().entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagList nBTTagList5 = new NBTTagList();
            for (Map.Entry<UUID, Double> entry2 : entry.getValue().entrySet()) {
                NBTTagCompound player = new NBTTagCompound();
                player.func_186854_a("uuid", entry2.getKey());
                player.func_74780_a("value", entry2.getValue().doubleValue());
                nBTTagList5.func_74742_a((NBTBase)player);
            }
            nBTTagCompound.func_74782_a("listPlayers", (NBTBase)nBTTagList5);
            nBTTagCompound.func_74768_a("id", entry.getKey().ordinal());
            nBTTagList4.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("primitive", (NBTBase)nBTTagList4);
        NBTTagList nBTTagList6 = new NBTTagList();
        for (Map.Entry<String, PlayerStreakInfo> entry : IUCore.mapStreakInfo.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("nick", entry.getKey());
            nBTTagCompound.func_74782_a("streak", (NBTBase)entry.getValue().writeNBT());
            nBTTagList6.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("streaks", (NBTBase)nBTTagList6);
        compound.func_74782_a("pollution", (NBTBase)PollutionManager.pollutionManager.writeCompound());
        NBTTagList nBTTagList7 = new NBTTagList();
        for (ChunkPos chunkPos : TileEntityEarthQuarryController.chunkPos) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("x", chunkPos.field_77276_a);
            nBTTagCompound.func_74768_a("z", chunkPos.field_77275_b);
            nBTTagList7.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("earth_quarry", (NBTBase)nBTTagList7);
        NBTTagList nBTTagList8 = new NBTTagList();
        for (Map.Entry<ChunkPos, GenData> entry : WorldGenGas.gasMap.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("x", entry.getKey().field_77276_a);
            nBTTagCompound.func_74768_a("z", entry.getKey().field_77275_b);
            nBTTagCompound.func_74782_a("data", (NBTBase)entry.getValue().writeNBT());
            nBTTagList8.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a("gen_gas", (NBTBase)nBTTagList8);
        NBTTagList nBTTagList9 = new NBTTagList();
        for (GasVein gasVein : GasVeinSystem.system.getVeinsList()) {
            nBTTagList9.func_74742_a((NBTBase)gasVein.writeTag());
        }
        compound.func_74782_a("gasvein", (NBTBase)nBTTagList9);
        Map<Integer, Map<UUID, List<Point>>> map = RelocatorNetwork.instance.getWorldDataPoints();
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagList worldListTag = new NBTTagList();
        for (Map.Entry<Integer, Map<UUID, List<Point>>> worldEntry : map.entrySet()) {
            NBTTagCompound worldTag = new NBTTagCompound();
            worldTag.func_74768_a("id", worldEntry.getKey().intValue());
            NBTTagList uuidListTag = new NBTTagList();
            for (Map.Entry<UUID, List<Point>> uuidEntry : worldEntry.getValue().entrySet()) {
                NBTTagCompound uuidTag = new NBTTagCompound();
                uuidTag.func_186854_a("uuid", uuidEntry.getKey());
                NBTTagList pointsListTag = new NBTTagList();
                for (Point point : uuidEntry.getValue()) {
                    pointsListTag.func_74742_a((NBTBase)point.writeToNBT(new NBTTagCompound()));
                }
                uuidTag.func_74782_a("listPoint", (NBTBase)pointsListTag);
                uuidListTag.func_74742_a((NBTBase)uuidTag);
            }
            worldTag.func_74782_a("listUUID", (NBTBase)uuidListTag);
            worldListTag.func_74742_a((NBTBase)worldTag);
        }
        nBTTagCompound.func_74782_a("worldUUID", (NBTBase)worldListTag);
        Map<UUID, Map<String, List<String>>> mapData = GuideBookCore.uuidGuideMap;
        if (!mapData.isEmpty()) {
            NBTTagCompound data = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (Map.Entry<UUID, Map<String, List<String>>> entry : mapData.entrySet()) {
                NBTTagCompound data1 = new NBTTagCompound();
                data1.func_186854_a("uuid", entry.getKey());
                NBTTagList list1 = new NBTTagList();
                Map<String, List<String>> mapQuest = entry.getValue();
                for (Map.Entry entry3 : mapQuest.entrySet()) {
                    NBTTagCompound data2 = new NBTTagCompound();
                    data2.func_74778_a("tab", (String)entry3.getKey());
                    NBTTagList list2 = new NBTTagList();
                    ((List)entry3.getValue()).forEach(name -> list2.func_74742_a((NBTBase)new NBTTagString(name)));
                    data2.func_74782_a("list", (NBTBase)list2);
                    list1.func_74742_a((NBTBase)data2);
                }
                data1.func_74782_a("list", (NBTBase)list1);
                list.func_74742_a((NBTBase)data1);
            }
            data.func_74782_a("list", (NBTBase)list);
            compound.func_74782_a("guide_book", (NBTBase)data);
        }
        compound.func_74782_a("relocator", (NBTBase)nBTTagCompound);
        this.tagCompound = compound;
        return compound;
    }
}

