/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events.client;

import com.denfop.gui.GuiIU;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GlobalRenderManager {
    public static long tick = 0L;
    public static Map<Integer, Map<BlockPos, Function>> globalRenders = new HashMap<Integer, Map<BlockPos, Function>>();

    public GlobalRenderManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addRender(World world, BlockPos pos, Function globalRender) {
        Map map = globalRenders.computeIfAbsent(world.field_73011_w.getDimension(), k -> new HashMap());
        if (!map.containsKey(pos)) {
            map.put(pos, globalRender);
        }
    }

    public static void removeRender(World world, BlockPos pos) {
        Map map = globalRenders.computeIfAbsent(world.field_73011_w.getDimension(), k -> new HashMap());
        map.remove(pos);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        ((Map)globalRenders.getOrDefault(event.getWorld().field_73011_w.getDimension(), new HashMap())).clear();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.func_130014_f_().field_72995_K && tick != event.player.func_130014_f_().func_72820_D()) {
            tick = event.player.func_130014_f_().func_72820_D();
            GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
            if (guiScreen instanceof GuiIU) {
                for (double ticks = 4.0; ticks > 0.0; ticks -= 1.0) {
                    ((GuiIU)guiScreen).updateTickInterface();
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || mc.field_71441_e == null) {
            return;
        }
        try {
            for (Map.Entry<Integer, Map<BlockPos, Function>> entry : globalRenders.entrySet()) {
                if (entry.getKey().intValue() != mc.field_71439_g.func_130014_f_().field_73011_w.getDimension()) continue;
                for (Function function : entry.getValue().values()) {
                    double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                    double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                    double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
                    if (mc.field_71441_e.func_72820_D() % 24000L > 13000L) {
                        GlStateManager.func_179145_e();
                    }
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    function.apply(0);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179121_F();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

