/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events.client;

import com.denfop.IUItem;
import com.denfop.api.space.EnumRing;
import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.IStar;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumRoversLevel;
import com.denfop.tiles.mechanism.TileEntityHologramSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SolarSystemRenderer {
    public static final ResourceLocation SATURN_RING_TEXTURE = new ResourceLocation("industrialupgrade", "textures/planet/saturn_ring.png");
    public static final ResourceLocation ASTEROID_TEXTURE = new ResourceLocation("industrialupgrade", "textures/planet/asteroid.png");
    static Map<IBody, Map<IBody, Float[]>> trajectories = new HashMap<IBody, Map<IBody, Float[]>>();
    static Random random = new Random(42L);
    boolean writeData = false;
    IStar star;
    List<IPlanet> planets;
    List<ISatellite> satellites = new ArrayList<ISatellite>();
    private Minecraft minecraft = Minecraft.func_71410_x();
    private float time;
    private List<IAsteroid> asteroids;

    public static void renderParabolicTrajectory(float time, IBody planets, IBody planets1, float progress, ItemStack item) {
        float currentAngle;
        IAsteroid asteroid;
        float x1 = (float)planets.getRotationTimeX(time);
        float z1 = (float)planets.getRotationTimeZ(time);
        float x2 = (float)planets1.getRotationTimeX(time);
        float z2 = (float)planets1.getRotationTimeZ(time);
        if (planets instanceof IAsteroid) {
            asteroid = (IAsteroid)planets;
            currentAngle = asteroid.getMiniAsteroid().get(0).getY() + asteroid.getMiniAsteroid().get(0).getRotationSpeed() * time;
            x1 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.cos(currentAngle);
            z1 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.sin(currentAngle);
        }
        if (planets1 instanceof IAsteroid) {
            asteroid = (IAsteroid)planets1;
            currentAngle = asteroid.getMiniAsteroid().get(0).getY() + asteroid.getMiniAsteroid().get(0).getRotationSpeed() * time;
            x2 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.cos(currentAngle);
            z2 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.sin(currentAngle);
        }
        float y1 = 0.5f;
        float y2 = 0.5f;
        float centerY = -0.2f;
        int steps = 400;
        float finalX = x1;
        float finalZ = z1;
        float finalX1 = x2;
        float finalZ1 = z2;
        Float[] trajectory = SolarSystemRenderer.calculateTrajectory(finalX, y1, finalZ, finalX1, y2, finalZ1, centerY, steps);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        GlStateManager.func_187441_d((float)2.0f);
        for (int i = 0; i < steps; ++i) {
            float x = trajectory[i * 3].floatValue();
            float y = trajectory[i * 3 + 1].floatValue();
            float z = trajectory[i * 3 + 2].floatValue();
            boolean color = false;
            if (progress * (float)steps >= (float)i) {
                color = true;
            }
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(0.0f, (float)color, 0.0f, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static Float[] calculateTrajectory(float x1, float y1, float z1, float x2, float y2, float z2, float centerY, int steps) {
        float centerX = (x1 + x2) / 2.0f;
        float centerZ = (z1 + z2) / 2.0f;
        float a = (centerY - y1) / ((centerX - x1) * (centerX - x1));
        a = Math.max(a, -0.5f);
        Float[] trajectory = new Float[steps * 3];
        for (int i = 0; i < steps; ++i) {
            float t = (float)i / (float)(steps - 1);
            float x = x1 + t * (x2 - x1);
            float z = z1 + t * (z2 - z1);
            float y = a * (x - x1) * (x - x2) + y1;
            trajectory[i * 3] = Float.valueOf(x);
            trajectory[i * 3 + 1] = Float.valueOf(y);
            trajectory[i * 3 + 2] = Float.valueOf(z);
        }
        return trajectory;
    }

    private static void renderItemOnTrajectory(float[] trajectory, float progress, ItemStack item) {
        int steps = trajectory.length / 3;
        int index = (int)(progress * (float)(steps - 1));
        float x = trajectory[index * 3];
        float y = trajectory[index * 3 + 1];
        float z = trajectory[index * 3 + 2];
        int nextIndex = Math.min(index + 1, steps - 1);
        float nextX = trajectory[nextIndex * 3];
        float nextY = trajectory[nextIndex * 3 + 1];
        float nextZ = trajectory[nextIndex * 3 + 2];
        float vX = nextX - x;
        float vY = nextY - y;
        float vZ = nextZ - z;
        EnumRoversLevel level = ((IRoversItem)item.func_77973_b()).getLevel();
        switch (level) {
            case ONE: {
                item = new ItemStack((Item)IUItem.rocket);
                break;
            }
            case TWO: {
                item = new ItemStack((Item)IUItem.adv_rocket);
                break;
            }
            case THREE: {
                item = new ItemStack((Item)IUItem.imp_rocket);
                break;
            }
            case FOUR: {
                item = new ItemStack((Item)IUItem.per_rocket);
            }
        }
        double yaw = Math.toDegrees(Math.atan2(vZ, vX));
        double pitch = Math.toDegrees(Math.atan2(vY, Math.sqrt(vX * vX + vZ * vZ)));
        double roll = 0.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(item, null, null);
        float newPitch = (float)pitch - 22.5f;
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(item, model);
        GlStateManager.func_179121_F();
    }

    private void renderPlanet(float radius, ResourceLocation texture, float x, float y, float z, float rotation, float rotationAngle) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotationAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.renderCube(buffer, radius);
        GlStateManager.func_179121_F();
    }

    private void renderRings(float radius, ResourceLocation texture, float x, float y, float z, boolean isSaturn) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        this.minecraft.func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        if (!isSaturn) {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
        buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        this.renderRing(buffer, radius);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void renderCube(BufferBuilder buffer, float radius) {
        float halfSize = radius / 2.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179140_f();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-halfSize), (double)(-halfSize), (double)(-halfSize)).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)(-halfSize), (double)(-halfSize)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)halfSize, (double)(-halfSize)).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)halfSize, (double)(-halfSize)).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)(-halfSize), (double)halfSize).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)(-halfSize), (double)halfSize).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)halfSize, (double)halfSize).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)halfSize, (double)halfSize).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)(-halfSize), (double)halfSize).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)(-halfSize), (double)(-halfSize)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)halfSize, (double)(-halfSize)).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)halfSize, (double)halfSize).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)(-halfSize), (double)halfSize).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)(-halfSize), (double)(-halfSize)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)halfSize, (double)(-halfSize)).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)halfSize, (double)halfSize).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)halfSize, (double)(-halfSize)).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)halfSize, (double)(-halfSize)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)halfSize, (double)halfSize).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)halfSize, (double)halfSize).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)(-halfSize), (double)(-halfSize)).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)(-halfSize), (double)(-halfSize)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)halfSize, (double)(-halfSize), (double)halfSize).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-halfSize), (double)(-halfSize), (double)halfSize).func_187315_a(0.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void renderRing(BufferBuilder buffer, float innerRadius) {
        double outerRadius = (double)innerRadius / 0.9;
        int segments = 64;
        for (int i = 0; i < 64; ++i) {
            float theta = (float)((double)i * Math.PI * 2.0 / 64.0);
            float xOuter = (float)(outerRadius * Math.cos(theta));
            float zOuter = (float)(outerRadius * Math.sin(theta));
            buffer.func_181662_b((double)xOuter, 0.0, (double)zOuter).func_187315_a((double)((float)i / 64.0f), 0.0).func_181675_d();
            float xInner = (float)((double)innerRadius * Math.cos(theta));
            float zInner = (float)((double)innerRadius * Math.sin(theta));
            buffer.func_181662_b((double)xInner, 0.0, (double)zInner).func_187315_a((double)((float)i / 64.0f), 1.0).func_181675_d();
        }
    }

    public void writeDataInfo() {
        this.star = SpaceInit.solarSystem.getStarList().get(0);
        this.planets = this.star.getPlanetList();
        this.planets.forEach(planets -> this.satellites.addAll(planets.getSatelliteList()));
        this.asteroids = this.star.getAsteroidList();
        this.writeData = true;
        this.time = (float)(75.0 * random.nextDouble());
    }

    public void render(TileEntityHologramSpace te) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)te.func_174877_v().func_177958_n() + 0.5f), (float)(te.func_174877_v().func_177956_o() + 1), (float)((float)te.func_174877_v().func_177952_p() + 0.5f));
        if (!Minecraft.func_71410_x().func_147113_T()) {
            this.time += 2.5E-4f;
        }
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.writeData) {
            this.writeDataInfo();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (IFakeBody fakeBody : te.fakeBodyList) {
            if (fakeBody.getTimerTo().canWork()) {
                SolarSystemRenderer.renderParabolicTrajectory(this.time, SpaceInit.earth, fakeBody.getBody(), (float)fakeBody.getTimerTo().getProgressBar(), fakeBody.getRover().getItemStack());
                continue;
            }
            SolarSystemRenderer.renderParabolicTrajectory(this.time, fakeBody.getBody(), SpaceInit.earth, (float)fakeBody.getTimerFrom().getProgressBar(), fakeBody.getRover().getItemStack());
        }
        this.renderPlanet((float)this.star.getSize(), this.star.getLocation(), (float)this.star.getRotationTimeX(this.time), 0.5f, (float)this.star.getRotationTimeZ(this.time), (float)this.star.getRotation(this.time), this.star.getRotationAngle());
        this.planets.forEach(planets -> {
            this.renderPlanet((float)planets.getSize(), planets.getLocation(), (float)planets.getRotationTimeX(this.time), 0.5f, (float)planets.getRotationTimeZ(this.time), (float)planets.getRotation(this.time), planets.getRotationAngle());
            if (planets.getRing() != null) {
                this.renderRings((float)planets.getSize(), SATURN_RING_TEXTURE, (float)planets.getRotationTimeX(this.time), 0.5f, (float)planets.getRotationTimeZ(this.time), planets.getRing() == EnumRing.HORIZONTAL);
            }
        });
        this.satellites.forEach(planets -> this.renderPlanet((float)planets.getSize(), planets.getLocation(), (float)planets.getRotationTimeX(this.time), 0.5f, (float)planets.getRotationTimeZ(this.time), (float)planets.getRotation(this.time), planets.getRotationAngle()));
        float deltaTime = this.time;
        this.asteroids.forEach(asteroids -> asteroids.getMiniAsteroid().forEach(miniAsteroid -> {
            float currentAngle = miniAsteroid.getY() + miniAsteroid.getRotationSpeed() * deltaTime;
            float x = miniAsteroid.getX() * (float)Math.cos(currentAngle);
            float z = miniAsteroid.getX() * (float)Math.sin(currentAngle);
            this.renderAsteroid(miniAsteroid.getSize(), x, 0.5f, z, miniAsteroid.getRotationSpeed());
        }));
        GlStateManager.func_179121_F();
    }

    private void renderAsteroid(float size, float x, float y, float z, float rotationSpeed) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_179114_b((float)rotationSpeed, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderPlanet(size, ASTEROID_TEXTURE, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        GlStateManager.func_179121_F();
    }
}

