/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.container.ContainerEFReader;
import com.denfop.gui.GuiIU;
import com.denfop.gui.IGuiUpdate;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GUIEFReader
extends GuiIU<ContainerEFReader>
implements IGuiUpdate {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/guitooleumeter.png");
    private final String name;
    private final ItemStack itemStack;
    private double min = Double.MAX_VALUE;
    private double max = 0.0;
    private double average = 0.0;
    private double col = 0.0;
    private double energySink = 0.0;
    private double energySource = 0.0;
    private long tick = 0L;
    private byte mode = 0;

    public GUIEFReader(ContainerEFReader container, ItemStack itemStack1) {
        super(container);
        this.componentList.clear();
        this.name = itemStack1.func_82833_r();
        this.itemStack = itemStack1;
        this.field_147000_g = 121;
        this.field_146999_f = 188;
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.field_146289_q.func_78276_b(this.name, (this.field_146999_f - this.field_146289_q.func_78256_a(this.name)) / 2, 6, 0);
        this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.mode") + " Sink", (169 + this.field_146289_q.func_78256_a(Localization.translate("itemToolMEter.mode") + " Sink")) / 2, 18, ModUtils.convertRGBcolorToInt(13, 229, 34));
        this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.mode") + " Source", (169 + this.field_146289_q.func_78256_a(Localization.translate("itemToolMEter.mode") + " Sink")) / 2, 78, ModUtils.convertRGBcolorToInt(13, 229, 34));
        if (this.mode == 0) {
            this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.mode.EnergyIn") + ":", 12, 18, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(ModUtils.getString(this.energySink) + " EF/t", 12, 28, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.avg") + " " + ModUtils.getString(this.average / (double)this.tick) + " EF/t", 8, 38, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.max/min") + ": ", 12, 48, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(ModUtils.getString(this.max) + "/" + ModUtils.getString(this.min), 12, 58, ModUtils.convertRGBcolorToInt(13, 229, 34));
        }
        if (this.mode == 1) {
            this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.mode.EnergyOut") + ":", 12, 18, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(ModUtils.getString(this.energySource) + " EF/t", 12, 28, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.avg") + " " + ModUtils.getString(this.average / (double)this.tick) + " EF/t", 8, 38, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.max/min") + ": ", 12, 48, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(ModUtils.getString(this.max) + "/" + ModUtils.getString(this.min), 12, 58, ModUtils.convertRGBcolorToInt(13, 229, 34));
        }
        this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.cycle", ModUtils.getString((double)this.tick / 40.0)), 12, 78, ModUtils.convertRGBcolorToInt(13, 229, 34));
        this.field_146289_q.func_78276_b(Localization.translate("itemToolMEter.mode.reset"), 38, 101, ModUtils.convertRGBcolorToInt(0, 0, 0));
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.mode == 0) {
            this.func_73729_b(this.field_147003_i + 130, this.field_147009_r + 34, 198, 35, 19, 17);
        } else {
            this.func_73729_b(this.field_147003_i + 130, this.field_147009_r + 54, 198, 55, 19, 17);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = mouseX - xMin;
        int y = mouseY - yMin;
        if (x >= 130 && y >= 34 && x <= 149 && y <= 51) {
            this.mode = 0;
            this.average = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = 0.0;
            this.tick = 0L;
            this.col = 0.0;
        }
        if (x >= 130 && y >= 54 && x <= 149 && y <= 71) {
            this.mode = 1;
            this.average = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = 0.0;
            this.tick = 0L;
            this.col = 0.0;
        }
        if (x >= 18 && y >= 96 && x <= 82 && y <= 113) {
            this.average = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = 0.0;
            this.tick = 0L;
            this.col = 0.0;
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }

    @Override
    public void readField(String string, CustomPacketBuffer packetBuffer) {
        packetBuffer.readByte();
        if (string.equals("energySink")) {
            this.energySink = packetBuffer.readDouble();
        }
        if (string.equals("energySource")) {
            this.energySource = packetBuffer.readDouble();
        }
        if (this.mode == 0) {
            if (this.min > this.energySink) {
                this.min = this.energySink;
            }
            if (this.max < this.energySink) {
                this.max = this.energySink;
            }
            this.average += this.energySink;
        }
        if (this.mode == 1) {
            if (this.min > this.energySource) {
                this.min = this.energySource;
            }
            if (this.max < this.energySource) {
                this.max = this.energySource;
            }
            this.average += this.energySource;
        }
        ++this.tick;
    }
}

