/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerAdvCokeOven;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.adv_cokeoven.TileCokeOvenMain;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAdvCokeOven
extends GuiIU<ContainerAdvCokeOven> {
    public final ContainerAdvCokeOven container;
    public boolean highlightedMinus = false;
    public boolean highlightedPlus = false;

    public GuiAdvCokeOven(ContainerAdvCokeOven container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.field_147000_g = 182;
        this.addComponent(new GuiComponent(this, 155, 44, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.addElement((GuiElement<?>)new AdvArea(this, 108, 23, 150, 36).withTooltip("+1"));
        this.addElement((GuiElement<?>)new AdvArea(this, 34, 23, 47, 36).withTooltip("-1"));
        this.addElement(new AdvArea(this, 63, 76, 118, 89){

            @Override
            protected List<String> getToolTip() {
                if (((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).heat == null) {
                    return Collections.singletonList("0/0 \u00b0C");
                }
                HeatComponent component = ((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).heat;
                ArrayList<String> stringList = new ArrayList<String>();
                stringList.add(ModUtils.getString(component.getEnergy()) + "\u00b0C/" + ModUtils.getString(component.getCapacity()) + "\u00b0C");
                if (component.need) {
                    stringList.add(Localization.translate("iu.need_heat"));
                }
                return stringList;
            }
        });
        this.addElement(new AdvArea(this, 50, 25, 105, 34){

            @Override
            protected List<String> getToolTip() {
                String temp = ModUtils.getString((double)((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).bar * 100000.0) + " Pa";
                return Collections.singletonList(temp);
            }
        });
        this.addElement(new AdvArea(this, 88, 46, 125, 57){

            @Override
            protected List<String> getToolTip() {
                return Collections.singletonList(Localization.translate("gui.MolecularTransformer.progress") + ": " + (int)(Math.min(((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).getProgress() / 2340.0, 1.0) * 100.0) + "%");
            }
        });
        this.addElement(new TankGauge(this, 6, 18, 20, 55, (IFluidTank)((TileCokeOvenMain)this.container.base).tank, TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                if (((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank == null) {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                } else {
                    FluidStack fs = ((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank.getFluid();
                    if (fs != null && fs.amount > 0) {
                        Fluid fluid = fs.getFluid();
                        if (fluid != null) {
                            ret.add(fluid.getLocalizedName(fs) + ": " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                        } else {
                            ret.add("invalid fluid stack");
                        }
                    } else {
                        ret.add(Localization.translate("iu.generic.text.empty"));
                    }
                }
                return ret;
            }

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                if (((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank == null) {
                    return;
                }
                FluidStack fs = ((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank.getFluid();
                if (fs != null && fs.amount > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 4;
                        fluidY += 4;
                        fluidWidth = 12;
                        fluidHeight = 47;
                    }
                    TextureAtlasSprite sprite = (fluid = fs.getFluid()) != null ? 4.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
                    int color = fluid != null ? fluid.getColor(fs) : -1;
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.amount / (double)this.tank.getCapacity(), 0.0, 1.0);
                    4.bindBlockTexture();
                    this.gui.drawSprite(fluidX, (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    if (this.getStyle().withGauge) {
                        4.bindCommonTexture();
                        int gaugeX = this.x;
                        int gaugeY = this.y;
                        if (!this.getStyle().withBorder) {
                            gaugeX -= 4;
                            gaugeY -= 4;
                        }
                        this.gui.drawTexturedRect(gaugeX, gaugeY, 20.0, 55.0, 38.0, 100.0, this.getStyle().mirrorGauge);
                    }
                }
            }
        });
        this.addElement(new TankGauge(this, 129, 18, 20, 55, (IFluidTank)((TileCokeOvenMain)this.container.base).tank1, TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                if (((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank1 == null) {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                } else {
                    FluidStack fs = ((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank1.getFluid();
                    if (fs != null && fs.amount > 0) {
                        Fluid fluid = fs.getFluid();
                        if (fluid != null) {
                            ret.add(fluid.getLocalizedName(fs) + ": " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                        } else {
                            ret.add("invalid fluid stack");
                        }
                    } else {
                        ret.add(Localization.translate("iu.generic.text.empty"));
                    }
                }
                return ret;
            }

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                if (((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank1 == null) {
                    return;
                }
                FluidStack fs = ((TileCokeOvenMain)GuiAdvCokeOven.this.container.base).tank1.getFluid();
                if (fs != null && fs.amount > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 4;
                        fluidY += 4;
                        fluidWidth = 12;
                        fluidHeight = 47;
                    }
                    TextureAtlasSprite sprite = (fluid = fs.getFluid()) != null ? 5.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
                    int color = fluid != null ? fluid.getColor(fs) : -1;
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.amount / (double)this.tank.getCapacity(), 0.0, 1.0);
                    5.bindBlockTexture();
                    this.gui.drawSprite(fluidX, (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    if (this.getStyle().withGauge) {
                        5.bindCommonTexture();
                        int gaugeX = this.x;
                        int gaugeY = this.y;
                        if (!this.getStyle().withBorder) {
                            gaugeX -= 4;
                            gaugeY -= 4;
                        }
                        this.gui.drawTexturedRect(gaugeX, gaugeY, 20.0, 55.0, 38.0, 100.0, this.getStyle().mirrorGauge);
                    }
                }
            }
        });
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.coke_oven_recipe.info"));
            List<String> compatibleUpgrades = ListInformationUtils.coke_oven;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.highlightedMinus = false;
        this.highlightedPlus = false;
        if (par1 >= 34 && par2 >= 23 && par1 <= 47 && par2 <= 36) {
            this.highlightedMinus = true;
        }
        if (par1 >= 108 && par2 >= 23 && par1 <= 121 && par2 <= 36) {
            this.highlightedPlus = true;
        }
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 34 && x <= 47 && y >= 23 && y <= 36) {
            new PacketUpdateServerTile((TileEntity)this.container.base, 1.0);
        }
        if (x >= 108 && x <= 121 && y >= 23 && y <= 36) {
            new PacketUpdateServerTile((TileEntity)this.container.base, 0.0);
        }
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(((TileCokeOvenMain)this.container.base).func_70005_c_());
        this.drawXCenteredString(this.field_146999_f / 2 + 20, 6, name, 0x404040, false);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        int progress = (int)(38.0 * ((TileCokeOvenMain)this.container.base).getProgress() / 2340.0);
        int xoffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yoffset = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        if (this.highlightedMinus) {
            this.func_73729_b(xoffset + 34, yoffset + 23, 192, 3, 14, 14);
        }
        if (this.highlightedPlus) {
            this.func_73729_b(xoffset + 108, yoffset + 23, 177, 3, 14, 14);
        }
        if (progress > 0) {
            this.func_73729_b(xoffset + 88, yoffset + 46, 177, 19, progress, 11);
        }
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.func_73729_b(xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        int bar = (int)(Math.min((double)((TileCokeOvenMain)this.container.base).bar * 1.0, 5.0) / 5.0 * 50.0);
        if (bar > 0) {
            this.func_73729_b(this.field_147003_i + 53, this.field_147009_r + 28, 181, 53, bar, 5);
        }
        if (((TileCokeOvenMain)this.container.base).heat != null) {
            progress = (int)(50.0 * ((TileCokeOvenMain)this.container.base).heat.getFillRatio());
            this.func_73729_b(this.field_147003_i + 66, this.field_147009_r + 79, 180, 34, progress, 8);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guicokeoven.png");
    }
}

