/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ImageInterface;
import com.denfop.api.gui.ImageScreen;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.EnumTypeComponentSlot;
import com.denfop.container.ContainerAgriculturalAnalyzer;
import com.denfop.gui.GuiIU;
import com.denfop.items.crop.ItemStackAgriculturalAnalyzer;
import com.denfop.utils.Timer;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAgriculturalAnalyzer
extends GuiIU<ContainerAgriculturalAnalyzer> {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    private final String name;
    private int prevText;
    private float scaled;
    private int textIndex;

    public GuiAgriculturalAnalyzer(ContainerAgriculturalAnalyzer container, ItemStack itemStack1) {
        super(container);
        this.name = Localization.translate(itemStack1.func_77977_a() + ".name");
        this.field_147000_g = 232;
        this.componentList.clear();
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.DEFAULT)));
        this.componentList.add(this.slots);
        this.addElement(new ImageInterface(this, 0, 0, this.field_146999_f, this.field_147000_g));
        this.addElement(new ImageScreen(this, 30, 20, this.field_146999_f - 36, 124));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.crop.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 16; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.crop.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 160, mouseY - 10, text);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.field_146289_q.func_78276_b(this.name, (this.field_146999_f - this.field_146289_q.func_78256_a(this.name)) / 2 - 10, 11, 0);
        if (((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).genome != null) {
            String text = this.getInformationFromCrop();
            int canvasX = 34;
            int canvasY = 24;
            int canvasWidth = this.field_146999_f - 42;
            int canvasHeight = 116;
            float scale = (float)(2.0 / (double)new ScaledResolution(this.field_146297_k).func_78325_e());
            if (this.prevText != text.length()) {
                this.scaled = -1.0f;
                this.prevText = text.length();
            }
            if (this.scaled == -1.0f) {
                this.scaled = scale = this.adjustTextScale(text, canvasWidth, canvasHeight, scale, 0.8f);
            } else {
                scale = this.scaled;
            }
            if (((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).player.func_130014_f_().func_72820_D() % 2L == 0L && this.textIndex < text.length()) {
                ++this.textIndex;
            }
            if (this.textIndex > text.length()) {
                this.textIndex = text.length();
            }
            String visibleText = text.substring(0, this.textIndex);
            this.drawTextInCanvas(visibleText, canvasX, canvasY, canvasWidth, canvasHeight, scale * 1.39f);
        }
    }

    private String getInformationFromCrop() {
        ICrop crop = ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).crop;
        return Localization.translate("iu.crop_analyzer.name") + Localization.translate("crop." + crop.getName()) + "\n" + Localization.translate("iu.crop_analyzer.grow_time") + new Timer(crop.getMaxTick() / 20).getDisplay() + "\n" + Localization.translate("iu.crop_analyzer.yield") + crop.getYield() + "\n" + Localization.translate("iu.crop_analyzer.drop") + crop.getDrops().get(0).func_82833_r() + "\n" + Localization.translate("iu.crop_analyzer.soil") + crop.getSoil().getStack().func_82833_r() + "\n" + Localization.translate("iu.crop_analyzer.daytime") + (crop.isSun() ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.crop_analyzer.nighttime") + (crop.isNight() ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.crop_analyzer.grow_speed") + crop.getGrowthSpeed() + "t \n" + Localization.translate("iu.crop_analyzer.min_light_level") + crop.getLightLevel() + "\n" + Localization.translate("iu.crop_analyzer.max_soil_pollution") + crop.getSoilRequirements().name() + "\n" + Localization.translate("iu.crop_analyzer.max_air_pollution") + crop.getAirRequirements().name() + "\n" + Localization.translate("iu.crop_analyzer.max_radiation_pollution") + crop.getRadiationRequirements().name() + "\n" + Localization.translate("iu.crop_analyzer.chance_weed") + (100 - crop.getChanceWeed()) + "%\n" + Localization.translate("iu.crop_analyzer.pest_resistance") + crop.getPestResistance() + "%\n" + Localization.translate("iu.crop_analyzer.ignore_soil") + (crop.isIgnoreSoil() ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.crop_analyzer.weather_resistance") + (crop.getWeatherResistance() == 0 ? Localization.translate("iu.space_no") : (crop.getWeatherResistance() == 1 ? Localization.translate("iu.space_rain") : Localization.translate("iu.space_thunder"))) + "\n" + Localization.translate("iu.crop_analyzer.percent_genome_adaptive") + Math.max(5, crop.getGenomeAdaptive()) + "%\n" + Localization.translate("iu.crop_analyzer.percent_genome_resistance") + Math.max(5, crop.getGenomeResistance()) + "%\n" + Localization.translate("iu.crop_analyzer.water_requirement") + (crop.getWaterRequirement() == 0 ? Localization.translate("iu.space_no") : crop.getWaterRequirement() + " blocks") + "\n" + Localization.translate("iu.crop_analyzer.biomes") + crop.getBiomes().stream().map(Biome::func_185359_l).collect(Collectors.joining(", "));
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int slots = ((ContainerAgriculturalAnalyzer)this.container).inventorySize;
        slots /= 9;
        for (int col = 0; col < slots; ++col) {
            for (int col1 = 0; col1 < 9; ++col1) {
                this.func_73729_b(this.field_147003_i + 7 + col1 * 18, this.field_147009_r + 23 + col * 18, 176, 0, 18, 18);
            }
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

