/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.gui.GuiSlider;
import com.denfop.network.packet.PacketColorPicker;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.render.streak.RGB;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import org.lwjgl.opengl.GL11;

public class GuiColorPicker
extends GuiScreen
implements GuiPageButtonList.GuiResponder,
GuiSlider.FormatHelper {
    protected final EntityPlayer player;
    protected final int xSize = 176;
    protected final int ySize = 196;
    private final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/Color.png");
    private PlayerStreakInfo colorPicker;

    public GuiColorPicker(EntityPlayer player) {
        this.player = player;
        this.colorPicker = IUCore.mapStreakInfo.get(this.player.func_70005_c_());
    }

    public void func_73866_w_() {
        this.colorPicker = IUCore.mapStreakInfo.get(this.player.func_70005_c_());
        if (this.colorPicker == null) {
            this.colorPicker = new PlayerStreakInfo(new RGB(0, 0, 0), false, true, true);
            IUCore.mapStreakInfo.put(this.player.func_70005_c_(), this.colorPicker);
            new PacketColorPicker(this.colorPicker, this.player.func_70005_c_());
        }
        this.field_146292_n.add(new GuiSlider(this, 0, (this.field_146294_l - this.xSize) / 2 + 10, (this.field_146295_m - this.ySize) / 2 + 80, Localization.translate("iu.red"), 0.0f, 255.0f, this.colorPicker.getRgb().getRed(), this));
        this.field_146292_n.add(new GuiSlider(this, 1, (this.field_146294_l - this.xSize) / 2 + 10, (this.field_146295_m - this.ySize) / 2 + 110, Localization.translate("iu.green"), 0.0f, 255.0f, this.colorPicker.getRgb().getGreen(), this));
        this.field_146292_n.add(new GuiSlider(this, 2, (this.field_146294_l - this.xSize) / 2 + 10, (this.field_146295_m - this.ySize) / 2 + 140, Localization.translate("iu.blue"), 0.0f, 255.0f, this.colorPicker.getRgb().getBlue(), this));
        this.field_146292_n.add(new GuiCheckBox(3, (this.field_146294_l - this.xSize) / 2 + 10, (this.field_146295_m - this.ySize) / 2 + 155, Localization.translate("iu.rgb"), this.colorPicker.isRainbow()));
        this.field_146292_n.add(new GuiCheckBox(4, (this.field_146294_l - this.xSize) / 2 + 10, (this.field_146295_m - this.ySize) / 2 + 165, Localization.translate("iu.renderstreak"), this.colorPicker.isRender()));
        this.field_146292_n.add(new GuiCheckBox(5, (this.field_146294_l - this.xSize) / 2 + 10, (this.field_146295_m - this.ySize) / 2 + 175, Localization.translate("iu.renderstreakplayers"), this.colorPicker.isRenderPlayer()));
    }

    public void func_73876_c() {
        super.func_73876_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
        this.drawGuiContainerBackgroundLayer();
    }

    public void drawTexturedModalRect1(int x, int y, int textureX, int textureY, int width, int height) {
        double[] name = new double[3];
        for (int i = 0; i < 3; ++i) {
            if (!(this.field_146292_n.get(i) instanceof GuiSlider)) continue;
            GuiSlider slider = (GuiSlider)((Object)this.field_146292_n.get(i));
            name[i] = slider.getSliderValue();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GL11.glColor4f((float)((float)name[0] / 255.0f), (float)((float)name[1] / 255.0f), (float)((float)name[2] / 255.0f), (float)1.0f);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawGuiContainerBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = (this.field_146294_l - this.xSize) / 2;
        int yOffset = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        this.drawTexturedModalRect1(xOffset, yOffset, 15, 1, 180, 60);
    }

    protected void func_146284_a(@Nonnull GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (this.player != null) {
            if (guibutton instanceof GuiSlider) {
                GuiSlider slider = (GuiSlider)guibutton;
                switch (guibutton.field_146127_k) {
                    case 0: {
                        this.colorPicker.getRgb().setRed((short)slider.getSliderValue());
                        break;
                    }
                    case 1: {
                        this.colorPicker.getRgb().setGreen((short)slider.getSliderValue());
                        break;
                    }
                    case 2: {
                        this.colorPicker.getRgb().setBlue((short)slider.getSliderValue());
                    }
                }
            }
            if (guibutton instanceof GuiCheckBox) {
                GuiCheckBox checkbox = (GuiCheckBox)guibutton;
                if (checkbox.field_146127_k == 3) {
                    this.colorPicker.setRainbow(checkbox.isChecked());
                }
                if (checkbox.field_146127_k == 4) {
                    this.colorPicker.setRender(checkbox.isChecked());
                }
                if (checkbox.field_146127_k == 5) {
                    this.colorPicker.setRenderPlayer(checkbox.isChecked());
                }
            }
            new PacketColorPicker(this.colorPicker, this.player.func_70005_c_());
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
        switch (id) {
            case 0: {
                this.colorPicker.getRgb().setRed((short)value);
                break;
            }
            case 1: {
                this.colorPicker.getRgb().setGreen((short)value);
                break;
            }
            case 2: {
                this.colorPicker.getRgb().setBlue((short)value);
            }
        }
        new PacketColorPicker(this.colorPicker, this.player.func_70005_c_());
    }

    public void func_175319_a(int id, @Nonnull String value) {
    }

    @Override
    @Nonnull
    public String getText(int id, @Nonnull String name, float value) {
        switch (id) {
            case 0: {
                return Localization.translate("iu.red") + (int)value;
            }
            case 1: {
                return Localization.translate("iu.green") + (int)value;
            }
            case 2: {
                return Localization.translate("iu.blue") + (int)value;
            }
        }
        return "";
    }
}

