/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.GuiVerticalSliderList;
import com.denfop.api.gui.MouseButton;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.container.ContainerBase;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;

public abstract class GuiCore<T extends ContainerBase<? extends IInventory>>
extends GuiContainer {
    public final T container;
    protected final List<GuiElement<?>> elements;
    protected final Queue<Tooltip> queuedTooltips = new ArrayDeque<Tooltip>();

    public GuiCore(T container) {
        this(container, 176, 166);
    }

    public GuiCore(T container, int ySize) {
        this(container, 176, ySize);
    }

    public GuiCore(T container, int xSize, int ySize) {
        super(container);
        this.elements = new ArrayList();
        this.container = container;
        this.field_147000_g = ySize;
        this.field_146999_f = xSize;
    }

    private static List<ItemStack> getCompatibleUpgrades(IUpgradableBlock block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<UpgradableProperty> properties = block.getUpgradableProperties();
        for (ItemStack stack : UpgradeRegistry.getUpgrades()) {
            IUpgradeItem item = (IUpgradeItem)stack.func_77973_b();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public T getContainer() {
        return this.container;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void func_146977_a(Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && !this.field_147004_w;
        ItemStack itemstack1 = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && this.field_147004_w && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(slotIn) && !itemstack1.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && this.field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a((Set)this.field_147008_s, (int)this.field_146987_F, (ItemStack)itemstack, (int)(slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E()));
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.field_147008_s.remove(slotIn);
                this.func_146980_g();
            }
        }
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(slotIn.getBackgroundLocation());
            this.func_175175_a(i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                GuiCore.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, itemstack, i, j);
            this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, i, j, s);
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected void func_146980_g() {
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!itemstack.func_190926_b() && this.field_147007_t) {
            if (this.field_146987_F == 2) {
                this.field_146996_I = itemstack.func_77976_d();
            } else {
                this.field_146996_I = itemstack.func_190916_E();
                for (Slot slot : this.field_147008_s) {
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    ItemStack itemstack2 = slot.func_75211_c();
                    int i = itemstack2.func_190926_b() ? 0 : itemstack2.func_190916_E();
                    Container.func_94525_a((Set)this.field_147008_s, (int)this.field_146987_F, (ItemStack)itemstack1, (int)i);
                    int j = Math.min(itemstack1.func_77976_d(), slot.func_178170_b(itemstack1));
                    if (itemstack1.func_190916_E() > j) {
                        itemstack1.func_190920_e(j);
                    }
                    this.field_146996_I -= itemstack1.func_190916_E() - i;
                }
            }
        }
    }

    public void updateTickInterface() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundAndTitle(partialTicks, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
        if (((ContainerBase)((Object)this.container)).base instanceof IUpgradableBlock) {
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
            this.drawTexturedRect(3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
        }
        for (GuiElement<?> element : this.elements) {
            element.drawBackground(mouseX, mouseY);
        }
    }

    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(((ContainerBase)((Object)this.container)).base.func_70005_c_());
        int textWidth = this.field_146289_q.func_78256_a(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int centerX = this.field_147003_i + this.field_146999_f / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.field_147009_r + 6) / scale);
        this.field_146289_q.func_78276_b(name, textX, textY, 0x404040);
        GlStateManager.func_179121_F();
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        this.drawForegroundLayer(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        this.flushTooltips();
    }

    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (((ContainerBase)((Object)this.container)).base instanceof IUpgradableBlock) {
            this.handleUpgradeTooltip(mouseX, mouseY);
        }
        for (GuiElement<?> element : this.elements) {
            element.drawForeground(mouseX, mouseY);
        }
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack stack : GuiCore.getCompatibleUpgrades((IUpgradableBlock)((ContainerBase)((Object)this.container)).base)) {
                text.add(stack.func_82833_r());
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        int scrollDelta = Mouse.getEventDWheel();
        ScrollDirection direction = scrollDelta != 0 ? (scrollDelta < 0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        for (GuiElement<?> element : this.elements) {
            if (!element.contains(mouseX, mouseY)) continue;
            element.onMouseScroll(mouseX, mouseY, direction);
        }
        List listButton = this.field_146292_n;
        for (GuiButton button : listButton) {
            if (!(button instanceof GuiVerticalSliderList)) continue;
            GuiVerticalSliderList slider = (GuiVerticalSliderList)button;
            if (direction == ScrollDirection.stopped) continue;
            slider.handleMouseWheel(direction, mouseX + this.field_147003_i, mouseY + this.field_147009_r);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean handled = false;
        MouseButton button = MouseButton.get(mouseButton);
        if (button != null) {
            mouseX -= this.field_147003_i;
            mouseY -= this.field_147009_r;
            for (GuiElement<?> element : this.elements) {
                handled |= element.onMouseClick(mouseX, mouseY, button, element.contains(mouseX, mouseY));
            }
            if (!handled) {
                mouseX += this.field_147003_i;
                mouseY += this.field_147009_r;
            } else {
                this.mouseHandled = true;
            }
        }
        if (!handled) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        boolean handled = false;
        MouseButton button = MouseButton.get(clickedMouseButton);
        if (button != null) {
            mouseX -= this.field_147003_i;
            mouseY -= this.field_147009_r;
            for (GuiElement<?> element : this.elements) {
                handled |= element.onMouseDrag(mouseX, mouseY, button, timeSinceLastClick, element.contains(mouseX, mouseY));
            }
            if (!handled) {
                mouseX += this.field_147003_i;
                mouseY += this.field_147009_r;
            } else {
                this.mouseHandled = true;
            }
        }
        if (!handled) {
            super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        boolean handled = false;
        MouseButton button = MouseButton.get(state);
        if (button != null) {
            mouseX -= this.field_147003_i;
            mouseY -= this.field_147009_r;
            for (GuiElement<?> element : this.elements) {
                handled |= element.onMouseRelease(mouseX, mouseY, button, element.contains(mouseX, mouseY));
            }
            if (!handled) {
                mouseX += this.field_147003_i;
                mouseY += this.field_147009_r;
            } else {
                this.mouseHandled = true;
            }
        }
        if (!handled) {
            super.func_146286_b(mouseX, mouseY, state);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void drawTexturedRect(double x, double y, double width, double height, double texX, double texY) {
        this.drawTexturedRect(x, y, width, height, texX, texY, false);
    }

    public void drawTexturedRect(double x, double y, double width, double height, double texX, double texY, boolean mirrorX) {
        this.drawTexturedRect(x, y, width, height, texX / 256.0, texY / 256.0, (texX + width) / 256.0, (texY + height) / 256.0, mirrorX);
    }

    public void drawTexturedRect(double x, double y, double width, double height, double uS, double vS, double uE, double vE, boolean mirrorX) {
        double xE = (x += (double)this.field_147003_i) + width;
        double yE = (y += (double)this.field_147009_r) + height;
        if (mirrorX) {
            double tmp = uS;
            uS = uE;
            uE = tmp;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b(x, y, (double)this.field_73735_i).func_187315_a(uS, vS).func_181675_d();
        worldrenderer.func_181662_b(x, yE, (double)this.field_73735_i).func_187315_a(uS, vE).func_181675_d();
        worldrenderer.func_181662_b(xE, yE, (double)this.field_73735_i).func_187315_a(uE, vE).func_181675_d();
        worldrenderer.func_181662_b(xE, y, (double)this.field_73735_i).func_187315_a(uE, vS).func_181675_d();
        tessellator.func_78381_a();
    }

    /*
     * Unable to fully structure code
     */
    public void drawSprite(double x, double y, double width, double height, TextureAtlasSprite sprite, int color, double scale, boolean fixRight, boolean fixBottom) {
        if (sprite == null) {
            sprite = this.field_146297_k.func_147117_R().func_174944_f();
        }
        x += (double)this.field_147003_i;
        y += (double)this.field_147009_r;
        scale *= 16.0;
        spriteUS = sprite.func_94209_e();
        spriteVS = sprite.func_94206_g();
        spriteWidth = (double)sprite.func_94212_f() - spriteUS;
        spriteHeight = (double)sprite.func_94210_h() - spriteVS;
        a = color >>> 24 & 255;
        r = color >>> 16 & 255;
        g = color >>> 8 & 255;
        b = color & 255;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator = Tessellator.func_178181_a();
        buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (xS = x; xS < x + width; xS += maxWidth) {
            if (xS != x || !fixRight) ** GOTO lbl-1000
            maxWidth = width % scale;
            if (v0 > 0.0) {
                uS = spriteUS + spriteWidth * (1.0 - maxWidth / scale);
            } else lbl-1000:
            // 2 sources

            {
                maxWidth = scale;
                uS = spriteUS;
            }
            xE = Math.min(xS + maxWidth, x + width);
            uE = uS + (xE - xS) / scale * spriteWidth;
            for (yS = y; yS < y + height; yS += maxHeight) {
                if (yS != y || !fixBottom) ** GOTO lbl-1000
                maxHeight = height % scale;
                if (v1 > 0.0) {
                    vS = spriteVS + spriteHeight * (1.0 - maxHeight / scale);
                } else lbl-1000:
                // 2 sources

                {
                    maxHeight = scale;
                    vS = spriteVS;
                }
                yE = Math.min(yS + maxHeight, y + height);
                vE = vS + (yE - yS) / scale * spriteHeight;
                buffer.func_181662_b(xS, yS, (double)this.field_73735_i).func_187315_a(uS, vS).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(xS, yE, (double)this.field_73735_i).func_187315_a(uS, vE).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(xE, yE, (double)this.field_73735_i).func_187315_a(uE, vE).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(xE, yS, (double)this.field_73735_i).func_187315_a(uE, vS).func_181669_b(r, g, b, a).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    public void drawItem(int x, int y, ItemStack stack) {
        this.field_146296_j.func_175042_a(stack, this.field_147003_i + x, this.field_147009_r + y);
    }

    public void drawItemStack(int x, int y, ItemStack stack) {
        this.drawItem(x, y, stack);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, this.field_147003_i + x, this.field_147009_r + y, null);
    }

    public void drawColoredRect(int x, int y, int width, int height, int color) {
        GuiCore.func_73734_a((int)(x += this.field_147003_i), (int)(y += this.field_147009_r), (int)(x + width), (int)(y + height), (int)color);
    }

    public int drawString(int x, int y, String text, int color, boolean shadow) {
        return this.field_146289_q.func_175065_a(text, (float)(this.field_147003_i + x), (float)(this.field_147009_r + y), color, shadow) - this.field_147003_i;
    }

    public void drawXCenteredString(int x, int y, String text, int color, boolean shadow) {
        this.drawCenteredString(x, y, text, color, shadow, true, false);
    }

    public void drawCenteredString(int x, int y, String text, int color, boolean shadow, boolean centerX, boolean centerY) {
        if (centerX) {
            x -= this.getStringWidth(text) / 2;
        }
        if (centerY) {
            y -= 4;
        }
        this.field_146289_q.func_78276_b(text, this.field_147003_i + x, this.field_147009_r + y, color);
    }

    public int getStringWidth(String text) {
        return this.field_146289_q.func_78256_a(text);
    }

    public void drawTooltip(int x, int y, List<String> text) {
        this.queuedTooltips.add(new Tooltip(text, x, y));
    }

    public void drawTooltip(int x, int y, ItemStack stack) {
        assert (!ModUtils.isEmpty(stack));
        this.func_146285_a(stack, x, y);
    }

    public void drawTooltipOnlyName(int x, int y, ItemStack stack, List<String> strings) {
        assert (!ModUtils.isEmpty(stack));
        this.renderToolTipOnlyName(stack, x, y, strings);
    }

    protected void renderToolTipOnlyName(ItemStack stack, int x, int y, List<String> strings) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        this.drawHoveringText(strings, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    public void flushTooltips() {
        for (Tooltip tooltip : this.queuedTooltips) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_146283_a(tooltip.text, tooltip.x, tooltip.y);
            GlStateManager.func_179140_f();
        }
        this.queuedTooltips.clear();
    }

    protected void addElement(GuiElement<?> element) {
        this.elements.add(element);
    }

    public final void bindTexture() {
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
    }

    protected abstract ResourceLocation getTexture();

    private static class Tooltip {
        final int x;
        final int y;
        final List<String> text;

        Tooltip(List<String> text, int x, int y) {
            this.text = text;
            this.x = x;
            this.y = y;
        }
    }
}

