/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.EnumTypeComponentSlot;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public abstract class GuiIU<T extends ContainerBase<? extends IInventory>>
extends GuiCore<T> {
    private final EnumTypeStyle style;
    public boolean isBlack = false;
    protected GuiComponent inventory;
    protected GuiComponent slots;
    protected List<InvSlot> invSlotList = new ArrayList<InvSlot>();
    protected List<GuiComponent> componentList = new ArrayList<GuiComponent>();

    public GuiIU(T container) {
        super(container);
        this.style = EnumTypeStyle.DEFAULT;
        this.inventory = new GuiComponent(this, 7, 83, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public GuiIU(T container, EnumTypeStyle style) {
        super(container);
        this.style = style;
        this.inventory = new GuiComponent(this, 7, 83, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public GuiIU(T container, EnumTypeComponent style) {
        super(container);
        this.style = this.getStyle(style);
        this.inventory = new GuiComponent(this, 7, 83, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public float adjustTextScale(String text, int canvasWidth, int canvasHeight, float scale, float scaleStep) {
        float newScale;
        block4: {
            FontRenderer fontRenderer = this.field_146297_k.field_71466_p;
            newScale = scale;
            float min = 70.0f;
            float max = 0.0f;
            boolean prevScaleDecrease = false;
            boolean prevScaleIncrease = false;
            while (true) {
                if (newScale < min) {
                    min = newScale;
                }
                if (newScale > max) {
                    max = newScale;
                }
                List<String> lines = this.splitTextToLines(text, canvasWidth, newScale, fontRenderer);
                int totalTextHeight = (int)((float)(lines.size() * fontRenderer.field_78288_b) * newScale);
                if (this.isTextTooLarge(lines, canvasWidth, canvasHeight, newScale, fontRenderer)) {
                    newScale *= 1.0f - scaleStep;
                    prevScaleDecrease = true;
                    if (!prevScaleIncrease) continue;
                    newScale = (min + max) * 0.95f / 2.0f;
                    break block4;
                }
                if (!((float)totalTextHeight < (float)canvasHeight * 0.8f)) break block4;
                prevScaleIncrease = true;
                newScale *= 1.0f + scaleStep;
                if (prevScaleDecrease) break;
            }
            newScale = (min + max) * 1.2f / 2.0f;
        }
        return newScale;
    }

    public boolean isTextTooLarge(List<String> lines, int canvasWidth, int canvasHeight, float scale, FontRenderer fontRenderer) {
        int totalHeight = (int)((float)(lines.size() * fontRenderer.field_78288_b) * scale);
        for (String line : lines) {
            int lineWidth = (int)((float)fontRenderer.func_78256_a(line) * scale);
            if (lineWidth <= canvasWidth) continue;
            return true;
        }
        return totalHeight > canvasHeight;
    }

    public List<String> wrapTextWithNewlines(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\n")) {
            List<String> wrappedLines = this.wrapText(paragraph, maxWidth);
            lines.addAll(wrappedLines);
        }
        return lines;
    }

    public List<String> wrapText(String text, int maxWidth) {
        String[] words;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            if (this.field_146289_q.func_78256_a(currentLine + word) <= maxWidth) {
                currentLine.append(word).append(" ");
                continue;
            }
            lines.add(currentLine.toString().trim());
            while (this.field_146289_q.func_78256_a(word) > maxWidth) {
                int partLength = maxWidth / this.field_146289_q.func_78263_a(' ');
                String part = word.substring(0, partLength);
                lines.add(part);
                word = word.substring(part.length());
            }
            currentLine.setLength(0);
            currentLine.append(word).append(" ");
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    private void enableScissor(int x, int y, int width, int height) {
        ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
        int scaleFactor = scaledResolution.func_78325_e();
        int scaledHeight = scaledResolution.func_78328_b();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * scaleFactor), (int)((scaledHeight - (y + height)) * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    private void disableScissor() {
        GL11.glDisable((int)3089);
    }

    public void drawTextInCanvasWithScissor(String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale) {
        int maxWidth = (int)((float)canvasWidth / scale);
        int x = this.field_147003_i + canvasX;
        int y = this.field_147009_r + canvasY;
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.field_146289_q.func_78276_b(line, (int)((float)x / scale), (int)((float)y / scale), 0xFFFFFF);
            GlStateManager.func_179121_F();
            y += 10;
        }
    }

    public void drawTextInCanvas(String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale) {
        int maxWidth = (int)((float)canvasWidth / scale);
        int lineHeight = (int)(10.0f * scale);
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.field_146289_q.func_78276_b(line, (int)((float)x / scale), (int)((float)y / scale), 0xFFFFFF);
            GlStateManager.func_179121_F();
            y += lineHeight;
        }
    }

    public void drawTextInCanvas(String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale, int color) {
        int maxWidth = (int)((float)canvasWidth / scale);
        int lineHeight = (int)(10.0f * scale);
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.field_146289_q.func_78276_b(line, (int)((float)x / scale), (int)((float)y / scale), color);
            GlStateManager.func_179121_F();
            y += lineHeight;
        }
    }

    public List<String> splitTextToLines(String text, int canvasWidth, float scale, FontRenderer fontRenderer) {
        String[] manualLines;
        LinkedList<String> lines = new LinkedList<String>();
        for (String manualLine : manualLines = text.split("\n")) {
            String[] words;
            StringBuilder currentLine = new StringBuilder();
            for (String word : words = manualLine.split(" ")) {
                String testLine = currentLine.length() == 0 ? word : currentLine + " " + word;
                int lineWidth = (int)((float)fontRenderer.func_78256_a(testLine) * scale);
                if (lineWidth > canvasWidth) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder(word);
                    continue;
                }
                currentLine.append(currentLine.length() == 0 ? word : " " + word);
            }
            if (currentLine.length() <= 0) continue;
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public EnumTypeComponent getComponent() {
        switch (this.style) {
            case ADVANCED: {
                return EnumTypeComponent.ADVANCED;
            }
            case IMPROVED: {
                return EnumTypeComponent.IMPROVED;
            }
            case PERFECT: {
                return EnumTypeComponent.PERFECT;
            }
            case PHOTONIC: {
                return EnumTypeComponent.PHOTONIC;
            }
            case STEAM: {
                return EnumTypeComponent.STEAM_DEFAULT;
            }
            case BIO: {
                return EnumTypeComponent.BIO_DEFAULT;
            }
            case SPACE: {
                return EnumTypeComponent.SPACE_DEFAULT;
            }
        }
        return EnumTypeComponent.DEFAULT;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public EnumTypeStyle getStyle(EnumTypeComponent style) {
        switch (style) {
            case ADVANCED: {
                return EnumTypeStyle.ADVANCED;
            }
            case IMPROVED: {
                return EnumTypeStyle.IMPROVED;
            }
            case PERFECT: {
                return EnumTypeStyle.PERFECT;
            }
            case PHOTONIC: {
                return EnumTypeStyle.PHOTONIC;
            }
            case STEAM_DEFAULT: {
                return EnumTypeStyle.STEAM;
            }
            case BIO_DEFAULT: {
                return EnumTypeStyle.BIO;
            }
            case SPACE_DEFAULT: {
                return EnumTypeStyle.SPACE;
            }
        }
        return EnumTypeStyle.DEFAULT;
    }

    public EnumTypeStyle getStyle() {
        return this.style;
    }

    public void addComponent(GuiComponent component) {
        this.componentList.add(component);
    }

    public void removeComponent(int index) {
        this.componentList.remove(index);
    }

    public void removeComponent(GuiComponent component) {
        this.componentList.remove(component);
    }

    public void drawForeground(int mouseX, int mouseY) {
        this.componentList.forEach(guiComponent -> guiComponent.drawForeground(mouseX, mouseY));
    }

    public void drawBackground() {
        int xoffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yoffset = (this.field_146295_m - this.field_147000_g) / 2;
        this.componentList.forEach(guiComponent -> guiComponent.drawBackground(xoffset, yoffset));
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
        this.componentList.forEach(guiComponent -> guiComponent.buttonClicked(x, y));
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawBackground();
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(this.container.base.func_70005_c_());
        int textWidth = this.field_146289_q.func_78256_a(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int centerX = this.field_147003_i + this.field_146999_f / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.field_147009_r + 6) / scale);
        this.field_146289_q.func_78276_b(name, textX, textY, 0x404040);
        GlStateManager.func_179121_F();
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.drawForeground(par1, par2);
    }
}

