/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.ComponentEmpty;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.TankGauge;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.container.ContainerMultiMatter;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileMultiMatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMultiMatter
extends GuiIU<ContainerMultiMatter> {
    public final ContainerMultiMatter container;
    public final String progressLabel;
    public final String amplifierLabel;

    public GuiMultiMatter(ContainerMultiMatter container1) {
        super(container1, ((TileMultiMatter)container1.base).getStyle());
        this.container = container1;
        this.progressLabel = Localization.translate("Matter.gui.info.progress");
        this.amplifierLabel = Localization.translate("Matter.gui.info.amplifier");
        this.addComponent(new GuiComponent(this, 4, 15, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.componentList.add(new GuiComponent(this, 117, 41, EnumTypeComponent.FLUID_PART, new Component<ComponentEmpty>(new ComponentEmpty())));
        this.componentList.add(new GuiComponent(this, 45, 60, EnumTypeComponent.WORK_BUTTON, new Component<1>(new ComponentButton((TileEntityBlock)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return ((TileMultiMatter)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((TileMultiMatter)this.getEntityBlock()).work;
            }
        })));
    }

    private static List<ItemStack> getCompatibleUpgrades(IUpgradableBlock block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<UpgradableProperty> properties = block.getUpgradableProperties();
        for (ItemStack stack : UpgradeRegistry.getUpgrades()) {
            IUpgradeItem item = (IUpgradeItem)stack.func_77973_b();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack stack : GuiMultiMatter.getCompatibleUpgrades((IUpgradableBlock)((Object)this.container.base))) {
                text.add(stack.func_82833_r());
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        TankGauge.createNormal(this, 96, 22, (IFluidTank)((TileMultiMatter)this.container.base).fluidTank).drawForeground(par1, par2);
        this.field_146289_q.func_78276_b(this.progressLabel, 8, 29, 0x404040);
        this.field_146289_q.func_78276_b(((TileMultiMatter)this.container.base).getProgressAsString(), 18, 39, 0x404040);
        if (((TileMultiMatter)this.container.base).scrap > 0) {
            this.field_146289_q.func_78276_b(this.amplifierLabel, 8, 49, 0x404040);
            this.field_146289_q.func_78276_b("" + ((TileMultiMatter)this.container.base).scrap, 8, 59, 0x404040);
        }
        this.drawForeground(par1, par2);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        TankGauge.createNormal(this, 96, 22, (IFluidTank)((TileMultiMatter)this.container.base).fluidTank).drawBackground(this.field_147003_i, this.field_147009_r);
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(((TileMultiMatter)this.container.base).func_70005_c_());
        int textWidth = this.field_146289_q.func_78256_a(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int centerX = this.field_147003_i + this.field_146999_f / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.field_147009_r + 6) / scale);
        this.field_146289_q.func_78276_b(name, textX, textY, 0x404040);
        GlStateManager.func_179121_F();
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

