/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.ComponentEmpty;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ImageInterface;
import com.denfop.api.gui.ImageScreen;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.VeinSystem;
import com.denfop.blocks.FluidName;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerQuarryVein;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileQuarryVein;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.biome.BiomeTaiga;
import org.lwjgl.opengl.GL11;

public class GuiQuarryVein
extends GuiIU<ContainerQuarryVein> {
    public final ContainerQuarryVein container;
    public int[][] colors = new int[39][66];

    public GuiQuarryVein(ContainerQuarryVein container1) {
        super(container1, ((TileQuarryVein)container1.base).getStyle());
        this.container = container1;
        for (int x1 = 74; x1 <= 112; ++x1) {
            for (int y1 = 14; y1 <= 79; ++y1) {
                int y2 = this.getCoord(y1, ((TileQuarryVein)this.container.base).getBlockPos().func_177956_o());
                int x2 = this.getCoordX(x1, ((TileQuarryVein)this.container.base).getBlockPos().func_177958_n(), 88);
                BlockPos pos = new BlockPos(x2, y2, ((TileQuarryVein)this.container.base).getBlockPos().func_177952_p());
                IBlockState state = ((TileQuarryVein)this.container.base).func_145831_w().func_180495_p(pos);
                this.colors[x1 - 74][y1 - 14] = this.getColor(state, ((TileQuarryVein)this.container.base).func_145831_w(), pos);
            }
        }
        this.field_147000_g += 30;
        this.inventory.setY(this.inventory.getY() + 30);
        this.elements.add(new ImageInterface(this, 0, 0, this.field_146999_f, this.field_147000_g));
        this.elements.add(new ImageScreen(this, 7, 30, 60, 15));
        this.addComponent(new GuiComponent(this, 69, 28, EnumTypeComponent.BIGGEST_FRAME, new Component<ComponentEmpty>(new ComponentEmpty())));
        this.addComponent(new GuiComponent(this, 129, 58, EnumTypeComponent.ENERGY_HEIGHT, new Component<Energy>(((TileQuarryVein)this.container.base).energy)));
    }

    int getChance(Biome biome) {
        if (Biome.func_185362_a((Biome)biome) == 2) {
            return 65;
        }
        if (Biome.func_185362_a((Biome)biome) == 0) {
            return 40;
        }
        if (Biome.func_185362_a((Biome)biome) == 24) {
            return 65;
        }
        if (Biome.func_185362_a((Biome)biome) == 10) {
            return 40;
        }
        if (Biome.func_185362_a((Biome)biome) == 17) {
            return 65;
        }
        if (Biome.func_185362_a((Biome)biome) == 7) {
            return 50;
        }
        if (Biome.func_185362_a((Biome)biome) == 35) {
            return 50;
        }
        return 10;
    }

    List<String> getList() {
        ArrayList<String> lst = new ArrayList<String>();
        Biome biome = ((TileQuarryVein)this.container.base).func_145831_w().getBiomeForCoordsBody(((TileQuarryVein)this.container.base).getBlockPos());
        lst.add(Localization.translate("iu.biome") + biome.func_185359_l());
        int col = biome instanceof BiomeHills ? 25 : 0;
        int col1 = biome instanceof BiomeTaiga || biome instanceof BiomeSnow ? 15 : 0;
        lst.add(Localization.translate("iu.gettingvein") + (int)((double)Math.max(0, this.getChance(biome) - col - col1) * 0.85) + "%");
        lst.add(Localization.translate("iu.gettingvein1") + String.valueOf(15 + col) + "%");
        lst.add(Localization.translate("iu.gettingvein2") + String.valueOf(15 + col + col1) + "%");
        return lst;
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 73 && mouseX <= 113 && mouseY >= 33 && mouseY < 100) {
            int y = this.getCoord(mouseY, ((TileQuarryVein)this.container.base).getBlockPos().func_177956_o());
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.quarryveininformation"));
            List<String> compatibleUpgrades = this.getList();
            compatibleUpgrades.add("Y: " + y);
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        } else if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.quarryvein_info"));
            List<String> compatibleUpgrades = ListInformationUtils.quarryvein;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    private int getCoord(int mouseY, int y) {
        double m = (double)y * 1.0 / 59.0;
        double m1 = mouseY - 21;
        return (int)Math.min(Math.max((double)y - (m *= m1), 0.0), 256.0);
    }

    private int getCoordX(int mouseX, int x, int center) {
        int x1 = x;
        x1 = mouseX < center ? (x1 -= (center - mouseX) * 2) : (x1 += (center - mouseX) * 2);
        return x1;
    }

    private void handleUpgradeTooltip1(int mouseX, int mouseY) {
        if (mouseX >= 122 && mouseX <= 166 && mouseY >= 23 && mouseY <= 39) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.canupdate"));
            String m = "";
            switch (((TileQuarryVein)this.container.base).level) {
                case 2: {
                    m = Localization.translate("iu.upgradekitmachine.upgradepanelkitmachine1");
                    break;
                }
                case 3: {
                    m = Localization.translate("iu.upgradekitmachine.upgradepanelkitmachine2");
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    m = Localization.translate("iu.upgradekitmachine.upgradepanelkitmachine");
                }
            }
            List<String> compatibleUpgrades = Collections.singletonList(m);
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            if (!m.equals("")) {
                this.drawTooltip(mouseX, mouseY, text);
            }
        }
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        String name = Localization.translate(((TileQuarryVein)this.container.base).func_70005_c_());
        switch (((TileQuarryVein)this.container.base).level) {
            case 2: {
                name = TextFormatting.GOLD + Localization.translate("iu.advanced_name") + " " + name.toLowerCase();
                break;
            }
            case 3: {
                name = TextFormatting.BLUE + Localization.translate("iu.improved_name") + " " + name.toLowerCase();
                break;
            }
            case 4: {
                name = TextFormatting.DARK_PURPLE + Localization.translate("iu.perfect_name") + " " + name.toLowerCase();
                break;
            }
        }
        int nmPos = (this.field_146999_f - this.field_146289_q.func_78256_a(name)) / 2;
        this.field_146289_q.func_78276_b(name, nmPos, 4, 0x404040);
        this.field_146289_q.func_78276_b(Localization.translate("iu.level"), 122, 23, 0x404040);
        switch (((TileQuarryVein)this.container.base).level) {
            case 2: {
                this.field_146289_q.func_78276_b(TextFormatting.GOLD + Localization.translate("iu.advanced"), 122, 31, 0x404040);
                break;
            }
            case 3: {
                this.field_146289_q.func_78276_b(TextFormatting.BLUE + Localization.translate("iu.improved"), 122, 31, 0x404040);
                break;
            }
            case 4: {
                this.field_146289_q.func_78276_b(TextFormatting.DARK_PURPLE + Localization.translate("iu.perfect"), 122, 31, 0x404040);
                break;
            }
            default: {
                this.field_146289_q.func_78276_b(Localization.translate("iu.simply"), 122, 31, 0x404040);
            }
        }
        this.handleUpgradeTooltip1(par1, par2);
        if (((TileQuarryVein)this.container.base).vein == null || ((TileQuarryVein)this.container.base).progress < 1200) {
            this.field_146289_q.func_78276_b(((TileQuarryVein)this.container.base).progress * 100 / 1200 + "%", 29, 34, ModUtils.convertRGBcolorToInt(13, 229, 34));
        }
        this.handleUpgradeTooltip(par1, par2);
        if (((TileQuarryVein)this.container.base).vein != VeinSystem.system.getEMPTY() && ((TileQuarryVein)this.container.base).vein.get()) {
            if (((TileQuarryVein)this.container.base).vein.getType() == Type.EMPTY || ((TileQuarryVein)this.container.base).vein.getMaxCol() == 0) {
                this.field_146289_q.func_78276_b(Localization.translate("iu.empty"), 27, 34, ModUtils.convertRGBcolorToInt(13, 229, 34));
            } else {
                String name_vein;
                boolean isOil;
                this.field_146289_q.func_78276_b(Localization.translate("iu.find"), 19, 34, ModUtils.convertRGBcolorToInt(13, 229, 34));
                int col = ((TileQuarryVein)this.container.base).vein.getCol();
                int colmax = ((TileQuarryVein)this.container.base).vein.getMaxCol();
                boolean bl = isOil = ((TileQuarryVein)this.container.base).vein.getType() == Type.OIL;
                if (!isOil) {
                    if (((TileQuarryVein)this.container.base).vein.getType() != Type.GAS) {
                        name_vein = ((TileQuarryVein)this.container.base).vein.isOldMineral() ? new ItemStack((Block)IUItem.heavyore, 1, ((TileQuarryVein)this.container.base).vein.getMeta()).func_82833_r() : new ItemStack((Block)IUItem.mineral, 1, ((TileQuarryVein)this.container.base).vein.getMeta()).func_82833_r();
                    } else {
                        name_vein = new ItemStack(FluidName.fluidgas.getInstance().getBlock()).func_82833_r();
                        isOil = true;
                    }
                } else {
                    name_vein = Localization.translate("iu.fluidneft");
                }
                ((Area)new AdvArea(this, 20, 54, 68, 72).withTooltip(name_vein + " " + col + (isOil ? "mb" : "") + "/" + colmax + (isOil ? "mb" : ""))).drawForeground(par1, par2);
            }
        }
    }

    private int getColor(IBlockState state, World world, BlockPos pos) {
        if (state.func_185904_a() == Material.field_151579_a) {
            return (int)((TileQuarryVein)this.container.base).func_145831_w().field_73011_w.getCloudColor((float)0.0f).field_72450_a;
        }
        MapColor color = state.func_185909_g((IBlockAccess)world, pos);
        return color.field_76291_p | 0xFF000000;
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        int h = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        int m = ((TileQuarryVein)this.container.base).progress * 34 / 1200;
        for (int x1 = 74; x1 <= 112; ++x1) {
            for (int y1 = 14; y1 <= 79; ++y1) {
                this.drawColoredRect(x1, y1 + 20, 1, 1, this.colors[x1 - 74][y1 - 14]);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(h + 88, k + 42, 183, 50, 1, m);
        switch (((TileQuarryVein)this.container.base).level) {
            case 2: {
                this.func_73729_b(h + 88, k + 41, 184, 48, 1, 1);
                break;
            }
            case 3: {
                this.func_73729_b(h + 88, k + 41, 185, 48, 1, 1);
                break;
            }
            case 4: {
                this.func_73729_b(h + 88, k + 41, 186, 48, 1, 1);
                break;
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.func_73729_b(h + 3, k + 3, 0, 0, 10, 10);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        if (((TileQuarryVein)this.container.base).vein != null && ((TileQuarryVein)this.container.base).vein.get() && ((TileQuarryVein)this.container.base).vein.getType() != Type.EMPTY) {
            RenderHelper.func_74520_c();
            GL11.glPushMatrix();
            GL11.glColor4f((float)0.1f, (float)1.0f, (float)0.1f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)32826);
            GlStateManager.func_179140_f();
            GlStateManager.func_179126_j();
            this.field_73735_i = 100.0f;
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            ItemStack stack = ((TileQuarryVein)this.container.base).vein.getType() == Type.VEIN ? (((TileQuarryVein)this.container.base).vein.isOldMineral() ? new ItemStack((Block)IUItem.heavyore, 1, ((TileQuarryVein)this.container.base).vein.getMeta()) : new ItemStack((Block)IUItem.mineral, 1, ((TileQuarryVein)this.container.base).vein.getMeta())) : (((TileQuarryVein)this.container.base).vein.getType() == Type.OIL ? new ItemStack(IUItem.oilblock) : new ItemStack((Block)IUItem.gasBlock));
            this.field_146296_j.func_180450_b(stack, h + 32, k + 54);
            GL11.glEnable((int)2896);
            GlStateManager.func_179145_e();
            RenderHelper.func_74519_b();
            GL11.glColor4f((float)0.1f, (float)1.0f, (float)0.1f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiquarryvein.png");
    }
}

