/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.radiationsystem.EnumCoefficient;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerRadiationPurifier;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileRadiationPurifier;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;

public class GuiRadiationPurifier
extends GuiIU<ContainerRadiationPurifier> {
    public GuiRadiationPurifier(ContainerRadiationPurifier guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.addComponent(new GuiComponent(this, 8, 62, EnumTypeComponent.ENERGY, new Component<Energy>(((TileRadiationPurifier)((ContainerRadiationPurifier)this.container).base).energy)));
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        if (((TileRadiationPurifier)((ContainerRadiationPurifier)this.container).base).radiation != null) {
            ((Area)new Area(this, 13, 11, 28, 10).withTooltip(Localization.translate("radiation.dose") + Math.max(1, (int)((TileRadiationPurifier)((ContainerRadiationPurifier)this.container).base).radiation.getRadiation()) + " " + ModUtils.getUnit(((TileRadiationPurifier)((ContainerRadiationPurifier)this.container).base).radiation.getCoef()) + "Sv")).drawForeground(par1, par2);
        } else {
            ((Area)new Area(this, 13, 11, 28, 10).withTooltip(Localization.translate("radiation.dose") + Math.max(0.5, 0.0) + " " + ModUtils.getUnit(EnumCoefficient.NANO) + "Sv")).drawForeground(par1, par2);
        }
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.radiationpurifier.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 4; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.radiationpurifier.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.func_73729_b(this.field_147003_i + 3, this.field_147009_r + 3, 0, 0, 10, 10);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        this.bindTexture();
        if (((TileRadiationPurifier)((ContainerRadiationPurifier)this.container).base).radiation == null) {
            this.drawTexturedRect(41.0, 12.0, 1.0, 3.0, 180.0, 19.0);
        } else {
            Radiation radiation = ((TileRadiationPurifier)((ContainerRadiationPurifier)this.container).base).radiation;
            if (radiation.getLevel() == EnumLevelRadiation.LOW) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(41.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.DEFAULT) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(35.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.MEDIUM) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(29.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.HIGH) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(23.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.VERY_HIGH) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(17.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            }
        }
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guipurifier.png");
    }
}

