/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.CustomButton;
import com.denfop.api.gui.FluidItem;
import com.denfop.api.gui.GuiElement;
import com.denfop.container.ContainerSmelteryController;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.smeltery.ITank;
import com.denfop.tiles.smeltery.TileEntitySmelteryController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class GuiSmelteryController
extends GuiIU<ContainerSmelteryController> {
    List<FluidTank> fluidTanks = new ArrayList<FluidTank>();
    List<FluidTank> fluidTanks1 = new ArrayList<FluidTank>();
    List<Integer> integerList = new ArrayList<Integer>();
    boolean hover1 = false;
    boolean hover2 = false;
    boolean hover3 = false;

    public GuiSmelteryController(ContainerSmelteryController guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        int i = 0;
        for (ITank tank : ((TileEntitySmelteryController)guiContainer.base).listTank) {
            this.fluidTanks.add(tank.getTank());
            this.integerList.add(i);
            ++i;
        }
        this.addElement(new CustomButton(this, 139, 33, 22, 22, (TileEntityBlock)((Object)((ContainerSmelteryController)this.container).base), -1, ""){

            @Override
            public String getText() {
                return Localization.translate("iu.mix");
            }

            @Override
            public boolean visible() {
                return ((TileEntitySmelteryController)((ContainerSmelteryController)GuiSmelteryController.this.container).base).list.size() > 1;
            }

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                this.getGui().bindTexture();
                if (this.highlighted) {
                    this.gui.func_73729_b(this.gui.field_147003_i + this.x, GuiSmelteryController.this.field_147009_r + this.y, 177, 25, 22, 22);
                }
            }
        });
        this.addElement(new CustomButton(this, 139, 9, 22, 22, (TileEntityBlock)((Object)((ContainerSmelteryController)this.container).base), -3, ""){

            @Override
            public String getText() {
                return Localization.translate("iu.separate");
            }

            @Override
            public boolean visible() {
                return ((TileEntitySmelteryController)((ContainerSmelteryController)GuiSmelteryController.this.container).base).list.size() == 1;
            }

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                this.getGui().bindTexture();
                if (this.highlighted) {
                    this.gui.func_73729_b(this.gui.field_147003_i + this.x, GuiSmelteryController.this.field_147009_r + this.y, 177, 1, 22, 22);
                }
            }
        });
        this.addElement(new CustomButton(this, 139, 57, 22, 22, (TileEntityBlock)((Object)((ContainerSmelteryController)this.container).base), -2, ""){

            @Override
            public String getText() {
                return Localization.translate("iu.mix_max");
            }

            @Override
            public boolean visible() {
                return ((TileEntitySmelteryController)((ContainerSmelteryController)GuiSmelteryController.this.container).base).list.size() > 1;
            }

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                this.getGui().bindTexture();
                if (this.highlighted) {
                    this.gui.func_73729_b(this.gui.field_147003_i + this.x, GuiSmelteryController.this.field_147009_r + this.y, 177, 49, 22, 22);
                }
            }
        });
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("smeltery_info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 10; ++i) {
                compatibleUpgrades.add(Localization.translate("smeltery_info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
        for (i = 0; i < this.fluidTanks1.size(); ++i) {
            if (x < 21 + i % 6 * 18 || x >= 21 + (i % 6 + 1) * 18 || y < 17 + i / 6 * 18 || y >= 17 + (i / 6 + 1) * 18) continue;
            new PacketUpdateServerTile((TileEntity)((ContainerSmelteryController)this.container).base, i);
        }
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.tanksRefresh();
        this.handleUpgradeTooltip(par1, par2);
        int i = 0;
        while (i < this.fluidTanks1.size()) {
            final int finalI = i++;
            new FluidItem(this, 21 + finalI % 6 * 18, 17 + finalI / 6 * 18, this.fluidTanks1.get(finalI).getFluid()){

                @Override
                protected List<String> getToolTip() {
                    ArrayList<String> ret = new ArrayList<String>();
                    FluidStack fs = GuiSmelteryController.this.fluidTanks1.get(finalI).getFluid();
                    if (fs != null && fs.amount > 0) {
                        Fluid fluid = fs.getFluid();
                        if (fluid != null) {
                            ret.add(fluid.getLocalizedName(fs));
                            ret.add("Amount: " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                            String state = fs.getFluid().isGaseous() ? "Gas" : "Liquid";
                            ret.add("Type: " + state);
                            ret.add("Ingots: " + fs.amount / 144);
                        } else {
                            ret.add("Invalid FluidStack instance.");
                        }
                    } else {
                        ret.add("No Fluid");
                        ret.add("Amount: 0 " + Localization.translate("iu.generic.text.mb"));
                        ret.add("Type: Not Available");
                    }
                    return ret;
                }
            }.drawForeground(par1, par2);
        }
    }

    private void tanksRefresh() {
        this.fluidTanks1 = this.fluidTanks.stream().sorted((tank1, tank2) -> {
            boolean hasFluid2;
            FluidStack fluid1 = tank1.getFluid();
            FluidStack fluid2 = tank2.getFluid();
            boolean hasFluid1 = fluid1 != null && fluid1.amount > 0;
            boolean bl = hasFluid2 = fluid2 != null && fluid2.amount > 0;
            if (hasFluid1 && !hasFluid2) {
                return -1;
            }
            if (!hasFluid1 && hasFluid2) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (GuiElement element : this.elements) {
            element.drawBackground(this.field_147003_i, this.field_147009_r);
        }
        this.bindTexture();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < this.fluidTanks1.size(); ++i) {
            this.bindTexture();
            new FluidItem(this, 21 + i % 6 * 18, 17 + i / 6 * 18, this.fluidTanks1.get(i).getFluid()).drawBackground(this.field_147003_i, this.field_147009_r);
        }
        this.bindTexture();
        for (i = 0; i < ((TileEntitySmelteryController)((ContainerSmelteryController)this.container).base).list.size(); ++i) {
            int index = ((TileEntitySmelteryController)((ContainerSmelteryController)this.container).base).list.get(i);
            this.func_73729_b(this.field_147003_i + 21 + index % 6 * 18, this.field_147009_r + 17 + index / 6 * 18, 200, 1, 18, 18);
        }
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guismeltery.png");
    }
}

