/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerSmelteryFuelTank;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.smeltery.TileEntitySmelteryFuelTank;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.input.Keyboard;

public class GuiSmelteryFuelTank
extends GuiIU<ContainerSmelteryFuelTank> {
    public GuiSmelteryFuelTank(ContainerSmelteryFuelTank guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.addElement(new TankGauge(this, 67, 15, 37, 49, (IFluidTank)((TileEntitySmelteryFuelTank)((ContainerSmelteryFuelTank)this.container).base).getFuelTank(), TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                FluidStack fs = ((TileEntitySmelteryFuelTank)((ContainerSmelteryFuelTank)GuiSmelteryFuelTank.this.container).base).getFuelTank().getFluid();
                if (Keyboard.isKeyDown((int)42)) {
                    if (this.tank instanceof Fluids.InternalFluidTank) {
                        Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                        ret.add(Localization.translate("iu.tank.fluids"));
                        ret.addAll(tank1.getFluidList());
                    }
                } else if (fs != null && fs.amount > 0) {
                    Fluid fluid = fs.getFluid();
                    if (fluid != null) {
                        ret.add(fluid.getLocalizedName(fs) + ": " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                    } else {
                        ret.add("invalid fluid stack");
                    }
                } else {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                }
                return ret;
            }

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                FluidStack fs = this.tank.getFluid();
                if (fs != null && fs.amount > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 3;
                        fluidY += 3;
                        fluidWidth = 37;
                        fluidHeight = 49;
                    }
                    TextureAtlasSprite sprite = (fluid = fs.getFluid()) != null ? 1.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
                    int color = fluid != null ? fluid.getColor(fs) : -1;
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.amount / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(fluidX, (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    this.gui.bindTexture();
                    this.gui.func_73729_b(this.gui.field_147003_i + 95, this.gui.field_147009_r + 21, 177, 1, 19, 46);
                }
            }
        });
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guismeltery_fuel.png");
    }
}

