/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.TankGauge;
import com.denfop.container.ContainerSolarDestiller;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.mechanism.solardestiller.TileEntityBaseSolarDestiller;
import com.denfop.utils.ModUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSolarDestiller
extends GuiIU<ContainerSolarDestiller> {
    public GuiSolarDestiller(ContainerSolarDestiller container) {
        super(container, ((TileEntityBaseSolarDestiller)container.base).getStyle());
        this.field_147000_g = 170;
        this.inventory.setY(101);
        this.componentList.clear();
        this.addElement(new TankGauge(this, 38, 20, 22, 40, (IFluidTank)((TileEntityBaseSolarDestiller)container.base).inputTank, TankGauge.TankGuiStyle.Normal){

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                FluidStack fs = this.tank.getFluid();
                if (fs != null && fs.amount > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 3;
                        fluidY += 3;
                        fluidWidth = 17;
                        fluidHeight = 44;
                    }
                    TextureAtlasSprite sprite = (fluid = fs.getFluid()) != null ? 1.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
                    int color = fluid != null ? fluid.getColor(fs) : -1;
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.amount / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(fluidX, (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    this.gui.bindTexture();
                    this.gui.func_73729_b(this.gui.field_147003_i + this.x + 2, this.gui.field_147009_r + this.y + 2, 179, 53, 19, 46);
                }
            }
        });
        this.addElement(new TankGauge(this, 115, 20, 22, 40, (IFluidTank)((TileEntityBaseSolarDestiller)container.base).outputTank, TankGauge.TankGuiStyle.Normal){

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                FluidStack fs = this.tank.getFluid();
                if (fs != null && fs.amount > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 3;
                        fluidY += 3;
                        fluidWidth = 17;
                        fluidHeight = 44;
                    }
                    TextureAtlasSprite sprite = (fluid = fs.getFluid()) != null ? 2.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
                    int color = fluid != null ? fluid.getColor(fs) : -1;
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.amount / (double)this.tank.getCapacity(), 0.0, 1.0);
                    2.bindBlockTexture();
                    this.gui.drawSprite(fluidX, (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    this.gui.bindTexture();
                    this.gui.func_73729_b(this.gui.field_147003_i + this.x + 2, this.gui.field_147009_r + this.y + 2, 179, 53, 19, 46);
                }
            }
        });
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(((TileEntityBaseSolarDestiller)((ContainerSolarDestiller)this.container).base).func_70005_c_());
        if (!this.isBlack) {
            this.drawXCenteredString(this.field_146999_f / 2, 6, name, ModUtils.convertRGBcolorToInt(216, 216, 216), false);
        } else {
            this.drawXCenteredString(this.field_146999_f / 2, 6, name, ModUtils.convertRGBcolorToInt(216, 216, 216), false);
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.bindTexture();
        if (((TileEntityBaseSolarDestiller)((ContainerSolarDestiller)this.container).base).canWork()) {
            int tick = ((TileEntityBaseSolarDestiller)((ContainerSolarDestiller)this.container).base).getTickRate();
            double progress = (double)(((TileEntityBaseSolarDestiller)((ContainerSolarDestiller)this.container).base).func_145831_w().func_72820_D() % (long)tick) / ((double)tick * 1.0);
            progress = Math.min(1.0, progress);
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 40, 201, 1, (int)(52.0 * progress), 10);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        switch (((TileEntityBaseSolarDestiller)((ContainerSolarDestiller)this.container).base).getStyle()) {
            case DEFAULT: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guisolardestiller.png");
            }
            case ADVANCED: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guiadvsolardestiller.png");
            }
            case IMPROVED: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guiimpsolardestiller.png");
            }
            case PERFECT: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guipersolardestiller.png");
            }
            case PHOTONIC: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guiphosolardestiller.png");
            }
        }
        return new ResourceLocation("industrialupgrade", "textures/gui/guisolardestiller.png");
    }
}

