/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerSteamTank;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.mechanism.steam.TileSteamStorage;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiSteamTank
extends GuiIU<ContainerSteamTank> {
    public final ContainerSteamTank container;

    public GuiSteamTank(ContainerSteamTank container1) {
        super(container1, EnumTypeStyle.STEAM);
        this.container = container1;
        this.addElement(new TankGauge(this, 59, 15, 58, 58, (IFluidTank)((TileSteamStorage)this.container.base).getFluidTank(), TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                FluidStack fs = ((TileSteamStorage)GuiSteamTank.this.container.base).getFluidTank().getFluid();
                if (Keyboard.isKeyDown((int)42)) {
                    if (this.tank instanceof Fluids.InternalFluidTank) {
                        Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                        ret.add(Localization.translate("iu.tank.fluids"));
                        ret.addAll(tank1.getFluidList());
                    }
                } else if (fs != null && fs.amount > 0) {
                    Fluid fluid = fs.getFluid();
                    if (fluid != null) {
                        ret.add(fluid.getLocalizedName(fs) + ": " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                    } else {
                        ret.add("invalid fluid stack");
                    }
                } else {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                }
                return ret;
            }

            @Override
            public void drawBackground(int mouseX, int mouseY) {
                FluidStack fs = ((TileSteamStorage)GuiSteamTank.this.container.base).getFluidTank().getFluid();
                if (fs != null && fs.amount > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 6;
                        fluidY += 6;
                        fluidWidth = 46;
                        fluidHeight = 46;
                    }
                    TextureAtlasSprite sprite = (fluid = fs.getFluid()) != null ? 1.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
                    int color = fluid != null ? fluid.getColor(fs) : -1;
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.amount / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(fluidX, (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.gui.bindTexture();
                    this.gui.func_73729_b(this.gui.field_147003_i + 99, this.gui.field_147009_r + 23, 177, 1, 12, 46);
                }
            }
        });
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        int xOffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yOffset = (this.field_146295_m - this.field_147000_g) / 2;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guisteamtank.png");
    }
}

