/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.ae;

import appeng.api.config.Actionable;
import appeng.tile.powersink.AEBasePoweredTile;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.sytem.InfoTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class AESink
implements IEnergySink {
    private final AEBasePoweredTile entity;
    List<Integer> energyTicks = new ArrayList<Integer>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    boolean hasHashCode = false;
    int hashCodeSource;
    private double pastEnergy;
    private double perEnergy;
    private double tick;
    private int hashCode;
    private long id;

    public AESink(AEBasePoweredTile entity) {
        this.entity = entity;
    }

    @Override
    public Map<EnumFacing, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void RemoveTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.entity.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public void AddTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.entity.func_145831_w().field_72995_K && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.func_176734_d()));
        }
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = super.hashCode();
            return this.hashCode;
        }
        return this.hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter var1, EnumFacing var2) {
        return true;
    }

    @Override
    public double getPerEnergy() {
        return this.perEnergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perEnergy += setEnergy;
    }

    @Override
    public void addTick(double tick) {
        this.tick = tick;
    }

    @Override
    public double getTick() {
        return this.tick;
    }

    @Override
    public boolean isSink() {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return (this.entity.getAEMaxPower() - this.entity.getAECurrentPower()) / 2.0;
    }

    @Override
    public int getSinkTier() {
        return 14;
    }

    @Override
    public void receiveEnergy(double var2) {
        this.entity.injectAEPower(var2 * 2.0, Actionable.MODULATE);
    }

    @Override
    public List<Integer> getEnergyTickList() {
        return this.energyTicks;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.entity;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.entity.func_174877_v();
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

